package swing.controls;

import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;

/**
 * 密码输入框
 */
public class YPasswordField extends JComponent {
    private JLabel titleLable;
    private JPasswordField valuePasswordField;

    /**
     * 构造函数
     *
     * @param title 输入框标题
     */
    public YPasswordField(String title) {
        super();
        titleLable = new JLabel(title.equals("") ? "" : (title + ":"), JLabel.RIGHT);
        titleLable.setPreferredSize(new Dimension(50, 25));
        titleLable.setOpaque(false);

        valuePasswordField = new JPasswordField();
        valuePasswordField.setPreferredSize(new Dimension(150, 25));

        this.setLayout(new FlowLayout());
        this.add(titleLable);
        this.add(valuePasswordField);
        if (YUIParameter.isdebug) {
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    /**
     * 设置输入框标题
     *
     * @param title
     * @return
     */
    public YPasswordField setTitle(String title) {
        titleLable.setText(title.equals("") ? "" : (title + ":"));
        return this;
    }

    /**
     * 获取输入框标题
     *
     * @return
     */
    public String getTitle() {
        return titleLable.getText();
    }

    /**
     * 设置标题提示
     *
     * @param tip
     * @return
     */
    public YPasswordField setTitleTip(String tip) {
        titleLable.setToolTipText(tip);
        return this;
    }

    /**
     * 获取标题提示
     *
     * @param tip
     * @return
     */
    public String getTitleTip() {
        return titleLable.getToolTipText();
    }

    /**
     * 设置标题字体颜色
     *
     * @param color
     * @return
     */
    public YPasswordField setTitleFontColor(Color color) {
        titleLable.setForeground(color);
        return this;
    }

    /**
     * 设置标题字体
     *
     * @param font
     * @return
     */
    public YPasswordField setTitleFont(Font font) {
        titleLable.setFont(font);
        return this;
    }

    /**
     * 设置密码框的值
     *
     * @param value
     * @return
     */
    public YPasswordField setValue(String value) {
        valuePasswordField.setText(value);
        return this;
    }

    /**
     * 获取密码框的值
     *
     * @return
     */
    public String getPassword() {
        return String.valueOf(valuePasswordField.getPassword());
    }

}
