package swing.controls;

import net.miginfocom.swing.MigLayout;
import swing.YUIParameter;

import javax.swing.*;
import java.awt.*;

public class YPanel extends JPanel implements Yui {
    MigLayout migLayout;
    String layoutconstraints;
    String columnconstraints;
    String rowconstraints;

    public YPanel(LayoutManager layout) {
        super(layout);
        initialize();
    }

    public YPanel() {
        this("", "", "");
    }

    /**
     * @param layoutconstraints wrap + 数字：指定默认在第几个组件后进行换行，如： wrap 2 表示在第二个组件后进行分行。
     *                          insets + 数字：指定默认与边界的距离，有两种方式：insets 10 表示四边均为10，insets 1 2 3 4 分别指示顶部、左侧、下部、右侧距离
     * @param columnconstraints 指定横向的单元格的各个属性。每个单元格的属性用[]括起来。如[][][]表示一行有三个单元格。各单元格可以定制的属性如下：
     *                          grow: x 方向按上一级的宽度进行延伸。注意如果此处不添加grow，那么在添加组件的时候使用growx会没有效果。
     *                          40!: 表明该列的单元格宽度固定为40
     *                          10:30:40：表明该列的单元格宽度最小为10、最佳为30、最大为40
     *                          ::40：表明该单元格最大值为４０。其它也可以是:30: 或者：30::等。
     *                          center/right/left： 指定该组件在水平方向的对齐方式
     *                          同时，也可以指定各个单元格之间的间隔：[]30[][]说明第一个和第二个单元格之间相隔30
     * @param rowconstraints    指定纵向的单元格的各个属性。
     *                          grow: 指定纵向是否进行延伸
     *                          ::: ：指定高度属性，与第二个参数意义一致。
     *                          top/bottom/center：指定在垂直方向的对齐方式。
     */
    public YPanel(String layoutconstraints, String columnconstraints, String rowconstraints) {
        super();
        this.layoutconstraints = layoutconstraints;
        this.columnconstraints = columnconstraints;
        this.rowconstraints = rowconstraints;
        initialize();
    }

    private void initialize() {
        if (YUIParameter.isdebug) {
            setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
        migLayout = new MigLayout(layoutconstraints, columnconstraints, rowconstraints);
        setLayout(migLayout);
        setOpaque(false);

        /**
         * 用户初始化
         */
        this.init();
        /**
         * 创建界面
         */
        view();
        /**
         * 创建数据
         */
        data();
        /**
         * 设置参数、动作等
         */
        control();
        /**
         * 默认显示
         */
        setVisible(true);
    }

    @Override
    public void init() {

    }

    @Override
    public void view() {

    }

    @Override
    public void control() {

    }

    @Override
    public void data() {

    }
}
