package swing.controls;

import javax.swing.*;
import java.awt.*;

/**
 * 消息对话框
 */
public class YMessageDialog {

    /**
     * 错误消息对话框
     *
     * @param container
     * @param message
     */
    public static void showErrMessage(Component container, String message) {
        JOptionPane.showMessageDialog(container, message, "错误", JOptionPane.ERROR_MESSAGE);
    }

    /**
     * 提示消息对话框
     *
     * @param container
     * @param message
     */
    public static void showInfoMessage(Component container, String message) {
        JOptionPane.showMessageDialog(container, message, "提示", JOptionPane.INFORMATION_MESSAGE);
    }


    /**
     * 确认消息对话框
     *
     * @param container
     * @param message
     * @return 1表示确定 0表示取消 -1表示否
     */
    public static int showQuestionMessage(Component container, String message) {
        int i = JOptionPane.showConfirmDialog(container, message, "提示", JOptionPane.YES_NO_CANCEL_OPTION);
        return i == 0 ? 1 : i == 2 ? 0 : -1;
    }

}
