package restcontroller.sysmanage.develop.wechatapp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "微信操作端注，用于维护微信应用的相关参数")
public class wechatapp extends Controller {
    public wechatapp(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "微信操作端列表查询", apiversion = R.ID10018301.v1.class)
    public String query_wechatappList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_wechatapp");
        for (Row row : rows) {
            row.put("pages", row.getJSONArray("pages"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "微信操作端新增，修改", apiversion = R.ID10018401.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = wechatapp.class, method = {"query_wechatappList"})})
    public String insertormodify_wechatapp() throws YosException {
        long wechatappid = content.getLong("wechatappid");
        String systemclient = content.getString("systemclient");
        String appid = content.getString("appid");
        String secret = content.getString("secret");
        String remarks = content.getString("remarks");
        String mch_id = content.getStringValue("mch_id");
        String mch_key = content.getStringValue("mch_key");
        boolean isvisitor = content.getBooleanValue("isvisitor");
        String siteid = isvisitor ? content.getStringValue("siteid") : "";
        Long visitor_roleid = isvisitor ? content.getLongValue("visitor_roleid") : 0;
        String systemclient_auth = content.getStringValue("systemclient_auth");


        JSONArray pagesArray = new JSONArray();
        if (content.containsKey("pages")) {
            pagesArray = content.getJSONArray("pages");
        }

        String work_token = content.getStringValue("work_token");
        String work_encodingaeskey = content.getStringValue("work_encodingaeskey");
        String work_corpid = content.getStringValue("work_corpid");
        String work_corpsecret = content.getStringValue("work_corpsecret");
        String work_agentid = content.getStringValue("work_agentid");
        String work_messagingclasspath = content.getStringValue("work_messagingclasspath");

        SQLFactory sqlFactory = null;
        if (wechatappid <= 0 || dbConnect.runSqlQuery("select wechatappid from sys_wechatapp where wechatappid=" + wechatappid).isEmpty()) {
            if (!dbConnect.runSqlQuery("select wechatappid from sys_wechatapp where systemclient='" + systemclient + "'").isEmpty()) {
                return getErrReturnObject().setErrMsg("该操作端已注册，不可重复注册！").toString();
            }
            wechatappid = createTableID("sys_wechatapp");
            sqlFactory = new SQLFactory(this, "微信应用新增");
        } else {
            sqlFactory = new SQLFactory(this, "微信应用修改");
        }
        sqlFactory.addParameter("wechatappid", wechatappid);
        sqlFactory.addParameter("systemclient", systemclient);
        sqlFactory.addParameter("appid", appid);
        sqlFactory.addParameter("secret", secret);
        sqlFactory.addParameter("remarks", remarks);
        sqlFactory.addParameter("mch_id", mch_id);
        sqlFactory.addParameter("mch_key", mch_key);
        sqlFactory.addParameter("work_token", work_token);
        sqlFactory.addParameter("work_encodingaeskey", work_encodingaeskey);
        sqlFactory.addParameter("work_corpid", work_corpid);
        sqlFactory.addParameter("work_corpsecret", work_corpsecret);
        sqlFactory.addParameter("work_agentid", work_agentid);
        sqlFactory.addParameter("work_messagingclasspath", work_messagingclasspath);
        sqlFactory.addParameter("pages", pagesArray);
        sqlFactory.addParameter("isvisitor", isvisitor);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("visitor_roleid", visitor_roleid);
        sqlFactory.addParameter("systemclient_auth", systemclient_auth);

        dbConnect.runSqlUpdate(sqlFactory);
        return query_wechatappList();
    }

    @API(title = "微信操作端删除", apiversion = R.ID10018501.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = wechatapp.class, method = {"query_wechatappList"})})
    public String delete_wechatapp() throws YosException {
        long wechatappid = content.getLong("wechatappid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_wechatapp where wechatappid=" + wechatappid);
        dbConnect.runSqlUpdate(list);
        return query_wechatappList();
    }
}
