package restcontroller.sysmanage.develop.datamag.administrativearea;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.io.IOException;
import java.util.ArrayList;

/**
 * 行政区域管理
 */
public class administrativearea extends Controller {

    public administrativearea(JSONObject content) throws YosException {
        super(content);
    }


    @API(title = "国家查询", apiversion = R.ID10030601.v1.class)
    public String queryCountry() throws YosException {
        Rows provinceRows = dbConnect.runSqlQuery("select * from t_country order by countryid");
        return getSucReturnObject().setData(provinceRows).toString();
    }

    @API(title = "国家新增", apiversion = R.ID10030701.v1.class)
    public String insertOrModifyCountry() throws YosException {
        long countryid = content.getLong("countryid");
        String countrynum = content.getString("countrynum");
        String country = content.getString("country");
        if (countryid <= 0 || dbConnect.runSqlQuery("select * from t_country where countryid=" + countryid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_country");
            insertSQL.setValue("countryid", createTableID("t_country"));
            insertSQL.setValue("countrynum", countrynum);
            insertSQL.setValue("country", country);
            insertSQL.insert();
        } else {
            UpdateSQL rowupdate = SQLFactory.createUpdateSQL(this, "t_country");
            rowupdate.setValue("countrynum", countrynum);
            rowupdate.setValue("country", country);
            rowupdate.setWhere("countryid", countryid);
            rowupdate.update();
        }
        return getSucReturnObject().toString();
    }


    @API(title = "国家删除", apiversion = R.ID10030801.v1.class)
    public String deleteCountry() throws YosException {
        long countryid = content.getLong("countryid");
        dbConnect.runSqlUpdate("delete from t_country where countryid=" + countryid);
        return getSucReturnObject().toString();
    }


    @API(title = "省份查询", apiversion = R.ID10010501.v1.class)
    public String queryProvinces() throws YosException {
        long countryid = content.getLong("countryid");
        Rows provinceRows = dbConnect.runSqlQuery("select * from t_province where countryid=" + countryid + " order by provinceid");
        return getSucReturnObject().setData(provinceRows).toString();
    }

    @API(title = "省份新增", apiversion = R.ID10010601.v1.class)
    public String insertOrModifyProvinces() throws YosException {
        long countryid = content.getLong("countryid");
        long provinceid = content.getLong("provinceid");
        String provincenum = content.getString("provincenum");
        String province = content.getString("province");
        if (provinceid <= 0 || dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_province");
            insertSQL.setValue("provinceid", createTableID("t_province"));
            insertSQL.setValue("provincenum", provincenum);
            insertSQL.setValue("province", province);
            insertSQL.setValue("countryid", countryid);
            insertSQL.insert();
        } else {
            UpdateSQL rowupdate = SQLFactory.createUpdateSQL(this, "t_province");
            rowupdate.setValue("provincenum", provincenum);
            rowupdate.setValue("province", province);
            rowupdate.setWhere("countryid", countryid);
            rowupdate.setWhere("provinceid", provinceid);
            rowupdate.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "省份删除", apiversion = R.ID10010701.v1.class)
    public String deleteProvinces() throws YosException {
        long provinceid = content.getLong("provinceid");
        dbConnect.runSqlUpdate("delete from t_province where provinceid=" + provinceid);
        return getSucReturnObject().toString();
    }

    @API(title = "城市查询", apiversion = R.ID10010801.v1.class)
    public String queryCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        Rows cityRows = dbConnect.runSqlQuery("select * from t_city where provinceid=" + provinceid + " order by cityid");
        return getSucReturnObject().setData(cityRows).toString();
    }

    @API(title = "城市新增", apiversion = R.ID10010901.v1.class)
    public String insertOrModifyCitys() throws YosException {
        long provinceid = content.getLong("provinceid");
        long cityid = content.getLong("cityid");
        String citynum = content.getString("citynum");
        String city = content.getString("city");

        if (dbConnect.runSqlQuery("select * from t_province where provinceid=" + provinceid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的省份信息").toString();
        }
        if (cityid <= 0 || dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_city");
            insertSQL.setValue("cityid", createTableID("t_city"));
            insertSQL.setValue("provinceid", provinceid);
            insertSQL.setValue("citynum", citynum);
            insertSQL.setValue("city", city);
            insertSQL.insert();
        } else {
            UpdateSQL rowInsert = SQLFactory.createUpdateSQL(this, "t_city");
            rowInsert.setValue("citynum", citynum);
            rowInsert.setValue("city", city);
            rowInsert.setWhere("provinceid", provinceid);
            rowInsert.setWhere("cityid", cityid);
            rowInsert.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "城市删除", apiversion = R.ID10011001.v1.class)
    public String deleteCitys() throws YosException {
        long cityid = content.getLong("cityid");
        dbConnect.runSqlUpdate("delete from t_city where cityid=" + cityid);
        return getSucReturnObject().toString();
    }


    @API(title = "区县查询", apiversion = R.ID10011101.v1.class)
    public String queryCounties() throws YosException {
        long cityid = content.getLong("cityid");
        Rows countyRows = dbConnect.runSqlQuery("select * from t_county where cityid=" + cityid + " order by countyid");
        return getSucReturnObject().setData(countyRows).toString();
    }

    @API(title = "区县新增", apiversion = R.ID10011201.v1.class)
    public String insertOrModifyCounties() throws YosException {
        long cityid = content.getLong("cityid");
        long countyid = content.getLong("countyid");
        String countynum = content.getString("countynum");
        String county = content.getString("county");

        if (dbConnect.runSqlQuery("select * from t_city where cityid=" + cityid).isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到相应的城市信息").toString();
        }
        if (countyid <= 0 || dbConnect.runSqlQuery("select * from t_county where countyid=" + countyid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_county");
            insertSQL.setValue("countyid", createTableID("t_county"));
            insertSQL.setValue("cityid", cityid);
            insertSQL.setValue("countynum", countynum);
            insertSQL.setValue("county", county);
            insertSQL.insert();
        } else {
            UpdateSQL rowInsert = SQLFactory.createUpdateSQL(this, "t_county");
            rowInsert.setValue("countynum", countynum);
            rowInsert.setValue("county", county);
            rowInsert.setWhere("cityid", cityid);
            rowInsert.setWhere("countyid", countyid);
            rowInsert.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "区县删除", apiversion = R.ID10011301.v1.class)
    public String deleteCounties() throws YosException {
        long countyid = content.getLong("countyid");
        dbConnect.runSqlUpdate("delete from t_county where countyid=" + countyid);
        return getSucReturnObject().toString();
    }


    @API(title = "中国行政代码导入")
    public String uploaddata() throws YosException {
        String countryid = content.getString("countryid");//国家代码
        Rows sys_dataimportRow = dbConnect.runSqlQuery("select * from t_country where countryid='" + countryid + "'");
        if (sys_dataimportRow.isEmpty()) {
            return getErrReturnObject().setErrMsg("不存在的国家代码").toString();
        }
        if (sys_dataimportRow.size() != 1) {
            return getErrReturnObject().setErrMsg("国家代码不唯一").toString();
        }
        try {
            SQLFactory sqlFactory = new SQLFactory(this, "行政代码查询");
            sqlFactory.addParameter("countryid", countryid);
            RowsMap oldRowsMap = dbConnect.runSqlQuery(sqlFactory.getSQL()).toRowsMap("code");

            ArrayList<String> fieldlist = new ArrayList<>();
            fieldlist.add("code");
            fieldlist.add("name");

            ArrayList<String> sqlist = new ArrayList<>();
            Rows datarows = getPostExcelFactory().getSheetRows(0, fieldlist, 1);
            for (Row row : datarows) {
                String code = row.getString("code").trim().replace(".0", "");
                String name = row.getString("name").trim();
                if (oldRowsMap.containsKey(code)) {
                    long id = oldRowsMap.get(code).get(0).getLong("id");
                    if (code.endsWith("0000")) {
                        sqlist.add("update t_province set province='" + name + "' where provinceid=" + id);
                    } else if (code.endsWith("00")) {
                        sqlist.add("update t_city set city='" + name + "' where cityid=" + id);
                    } else {
                        sqlist.add("update t_county set county='" + name + "' where countyid=" + id);
                    }
                }
            }
            dbConnect.runSqlUpdate(sqlist);
            sqlist.clear();
            for (Row row : datarows) {
                String code = row.getString("code").trim().replace(".0", "");
                String name = row.getString("name").trim();
                if (!oldRowsMap.containsKey(code)) {
                    if (code.endsWith("0000")) {
                        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_province");
                        insertSQL.setValue("provincenum", code);
                        insertSQL.setValue("province", name);
                        insertSQL.setValue("countryid", countryid);
                        insertSQL.insert();
                    } else if (code.endsWith("00")) {
                        String provincenum = code.substring(0, 2) + "0000";
                        Rows provincerows = dbConnect.runSqlQuery("select * from t_province where countryid=" + countryid + " and provincenum='" + provincenum + "'");
                        for (Row provincerow : provincerows) {
                            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_city");
                            insertSQL.setValue("citynum", code);
                            insertSQL.setValue("city", name);
                            insertSQL.setValue("provinceid", provincerow.getLong("provinceid"));
                            insertSQL.insert();
                        }
                    } else {
                        String provincenum = code.substring(0, 2) + "0000";
                        String citynum = code.substring(0, 4) + "00";
                        Rows cityrows = dbConnect.runSqlQuery("select * from t_city where citynum=" + citynum + " and exists(select * from t_province where t_province.countryid=" + countryid + " and t_province.provincenum='" + provincenum + "' and t_city.provinceid=t_province.provinceid)");
                        for (Row cityrow : cityrows) {
                            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "t_county");
                            insertSQL.setValue("countynum", code);
                            insertSQL.setValue("county", name);
                            insertSQL.setValue("cityid", cityrow.getLong("cityid"));
                            insertSQL.insert();
                        }
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return getSucReturnObject().toString();
    }

}
