package service;

import common.ServiceController;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.mq.ClientMQTT;
import common.mq.MQMessage;
import org.apache.activemq.broker.jmx.BrokerViewMBean;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * mqtt设备在线监控
 */
public class MqttClientCheck extends ServiceController {

    @Override
    public void serviceRun() throws YosException {
        try {
            ArrayList<String> onlineDevices = dbConnect.runSqlQuery("select serialnumber from w_device where status ='在线'").toArrayList("serialnumber");//在线设备查询
            HashMap<String, String> online = new HashMap<>();

            Rows sys_mqRows = dbConnect.runSqlQuery("select jmxrmiaddress,password,username,sys_mqid from sys_mq where isused=1");
            for (Row sys_mqRow : sys_mqRows) {
                long sys_mqid = sys_mqRow.getLong("sys_mqid");
                String jmxserviceURL = sys_mqRow.getString("jmxrmiaddress");        //brokername是对应的ip

                JMXServiceURL url = new JMXServiceURL(jmxserviceURL);
                JMXConnector connector = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                ObjectName name = new ObjectName("org.apache.activemq:brokerName=localhost,type=Broker");
                BrokerViewMBean brokerViewMBean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
                ObjectName[] objectNames = brokerViewMBean.getDynamicDestinationProducers();
                logger.info("mqtt检测当前在线数：" + objectNames.length);
                for (ObjectName objectName : objectNames) {
                    String clientId = objectName.getKeyProperty("clientId");
                    String producerId = objectName.getKeyProperty("producerId").replace("_-1_1", "");

                    online.put(clientId, producerId);

                    ClientMQTT.connectClientIDMap.put(producerId, clientId);
                    ClientMQTT.connectClientIDMQIDMap.put(clientId, sys_mqid);
                    dbConnect.runSqlUpdate("update w_device set status='在线',lastconnecttime=now() where serialnumber='" + clientId + "' and ifnull(status,'离线')='离线'");
                    try {
                        Rows rows = new DBConnect().runSqlQuery("select w_function_queueid from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.invalid=0 and t1.deleted=0 and t1.isreceive=0 and t2.serialnumber='" + clientId + "' order by w_function_queueid");
                        for (Row row : rows) {
                            logger.info("mqtt指令发送：" + row.getLong("w_function_queueid"));
                            ClientMQTT.publish(row.getLong("w_function_queueid"));
                            Thread.sleep(100L);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    MQMessage.deviceMsgStatusInit(clientId);
                }
                connector.close();

                for (String serialnumber : onlineDevices) {
                    if (!online.containsKey(serialnumber)) {
                        dbConnect.runSqlUpdate("update w_device set status='离线' where serialnumber='" + serialnumber + "'");
                        SQLFactory.createInsertSQL(new DBConnect(), "sys_mqttlogintrack").setValue("connectionid", online.get(serialnumber)).setValue("action", "off").setValue("clientid", serialnumber).setDateValue("createdate").insert();

                        ClientMQTT.onlineClientid.remove(serialnumber);
                        ClientMQTT.connectClientIDMap.remove(online.get(serialnumber));
                        ClientMQTT.connectClientIDMQIDMap.remove(serialnumber);
                        MQMessage.deviceMsgStatusInit(serialnumber);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
