package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-系统应用注册管理-小组件管理")
public class appregistry_wedgit extends Controller {

    public appregistry_wedgit(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 应用小组件查询
     *
     * @return
     */
    @API(title = "应用小组件查询", apiversion = R.ID10007001.v1.class)
    @CACHEING
    public String query_appwedgitlist() throws YosException {
        long systemappid = content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用小组件查询");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用小组件新增修改
     *
     * @return
     */
    @API(title = "应用小组件新增修改", apiversion = R.ID10007101.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry_wedgit.class, method = {"query_appwedgitlist"})})
    public String insertormodify_appwedgit() throws YosException {
        long systemappid = content.getLong("systemappid");
        long wedgitid = content.getLongValue("wedgitid");//新增时传0
        String wedgit = content.getString("wedgit");
        String wedgitname = content.getString("wedgitname");
        String siteids = content.getString("siteids");
        int sequence = content.getInteger("sequence");
        String wedgittype = content.getString("wedgittype");

        if (wedgit.equals("") || !String.valueOf(wedgit.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("小组件名称必须以英文字母开头").toString();
        }
        if (!wedgit.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("小组件名称必须为英文字母或英文数字组合").toString();
        }
        SQLFactory sqlFactory;
        if (wedgitid <= 0 || dbConnect.runSqlQuery("select wedgitid from sys_systemapp_wedgits where wedgitid=" + wedgitid).isEmpty()) {
            wedgitid = createTableID("sys_systemapp_wedgits");
            sqlFactory = new SQLFactory(this, "应用小组件新增");
            sqlFactory.addParameter("systemappid", systemappid);
            sqlFactory.addParameter("wedgitid", wedgitid);
            sqlFactory.addParameter("wedgit", wedgit);
            sqlFactory.addParameter("wedgitname", wedgitname);
            sqlFactory.addParameter("siteids", siteids);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("wedgittype", wedgittype);
        } else {
            sqlFactory = new SQLFactory(this, "应用小组件修改");
            sqlFactory.addParameter("wedgitid", wedgitid);
            sqlFactory.addParameter("wedgit", wedgit);
            sqlFactory.addParameter("wedgitname", wedgitname);
            sqlFactory.addParameter("siteids", siteids);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("wedgittype", wedgittype);
        }
        dbConnect.runSqlUpdate(sqlFactory);
        return query_appwedgitlist();
    }

    /**
     * 应用小组件删除
     *
     * @return
     */
    @API(title = "应用小组件删除", apiversion = R.ID10007201.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry_wedgit.class, method = {"query_appwedgitlist"})})
    public String delete_appwedgit() throws YosException {
        long wedgitid = content.getLong("wedgitid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_wedgits where wedgitid=" + wedgitid);
        dbConnect.runSqlUpdate(list);
        return query_appwedgitlist();
    }
}
