package common;

import beans.translate.Translate;
import common.data.Row;
import common.data.Rows;

import java.util.HashMap;

public class ReturnObject_Code extends ReturnObject {

    public ReturnObject_Code(Controller controller) {
        super(controller);
        this.put("code", 1);
    }

    public ReturnObject_Code setCode(String code, String... params) throws YosException {
        this.put("msgcode", code);
        Row row = getMessage(code);
        if (!row.isEmpty()) {
            switch (row.getString("type")) {
                case "error": {
                    this.put("code", 0);
                    break;
                }
            }
            this.put("title", row.getString("title"));

            String content = row.getString("content");
            for (int i = 0; i < params.length; i++) {
                //消息内容替换，如果参数需要翻译则自动进行简单的翻译匹配
                content = content.replace("{" + (i + 1) + "}", Translate.getSimpleTranslate(controller.languagecode, params[i]));
            }
            this.put("msg", content);
        } else {
            this.put("code", 0);
            this.put("title", "can't find the message by code " + code);
            this.put("msg", "can't find the message by code " + code);
        }
        return this;
    }

    public ReturnObject_Code addKeyValue(String key, Object value) {
        this.put(key, value);
        return this;
    }

    //<code,<languagecode,row>>
    public static HashMap<String, HashMap<String, Row>> messageMap = new HashMap<>();

    private Row getMessage(String code) throws YosException {
        if (!messageMap.containsKey(code) || !messageMap.get(code).containsKey(controller.languagecode)) {
            Rows rows = controller.dbConnect.runSqlQuery(
                    "select t1.sysmessageid,t1.type,t1.code," +
                            "case when t2.translateid is null then t1.title else t2.value_translate end as title," +
                            "case when t3.translateid is null then t1.content else t3.value_translate end as content " +
                            "from sys_sysmessage t1 " +
                            "left join sys_translate t2 on t1.sysmessageid=t2.ownerid and t2.ownertable='sys_sysmessage' and t2.columnname='title' and t2.languagecode='" + controller.languagecode + "' " +
                            "left join sys_translate t3 on t1.sysmessageid=t3.ownerid and t3.ownertable='sys_sysmessage' and t3.columnname='content'and t3.languagecode='" + controller.languagecode + "' " +
                            "where t1.code='" + code + "'");
            HashMap<String, Row> msgMap = messageMap.getOrDefault(code, new HashMap<>());
            msgMap.put(controller.languagecode, rows.isNotEmpty() ? rows.get(0) : new Row());
            messageMap.put(code, msgMap);
        }
        return messageMap.getOrDefault(code, new HashMap<>()).getOrDefault(controller.languagecode, new Row());
    }

}
