package common;

import beans.attachment.Attachment;
import beans.department.Department;
import beans.parameter.Parameter;
import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.api.YOSAPI;
import common.data.*;
import common.data.db.DataPool;
import common.parameter.parameter;
import org.apache.commons.fileupload.FileItem;
import restcontroller.ClientUserInfo;
import utility.huawei.obs.BucketFile;
import utility.tools.Encryption;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * API接口父类，所有接口类都必须继承该类
 */
public class Controller extends BaseClass {
    public ClientUserInfo userInfo;
    /**
     * 接口请求正文
     */
    public JSONObject content;
    /**
     * 接口返回对象
     */
    private ReturnObject returnObject;
    /**
     * 用户请求端
     */
    public String systemclient = "";
    /**
     * 分页查询接口的页码，缺省值：1
     */
    public int pageNumber = 1;
    /**
     * 分页查询接口的每页返回数量，缺省值：20
     */
    public int pageSize = 20;

    public int rowindex = 0;
    /**
     * 用户（账号）ID，公共接口该值为0
     */
    public long userid = 0L;
    /**
     * 用户（账号）站点数据ID，公共接口该值为0
     */
    public long usersiteid = 0L;
    /**
     * 用户（账号）类型，公共接口该值为0
     */
    public int usertype = 0;
    /**
     * 用户（账号）名称，公共接口该值为空
     */
    public String username = "";
    /**
     * 站点ID
     */
    public String siteid = "";
    /**
     * 用户手机号
     */
    public String phonenumber = "";
    /**
     * 用户部门ID
     */
    public long departmentid = 0L;
    /**
     * 内部人员的人员ID，外部人员为0，如商户人员
     */
    public long hrid = 0L;
    /**
     * 企业档案ID
     */
    public long sys_enterpriseid = 0L;
    /**
     * 用户是否为部门负责人或经销商负责人
     */
    public boolean isleader = false;
    public String pageSorting;
    public JSONArray pageSortingArray;
    // public JSONObject tablefilter = new JSONObject();

    public List<FileItem> requestFileItemList;


    public YOSAPI requestAPI;
    public YOSAPI.YosRequest request;
    private String accesstoken = "";
    public String languagecode = "ZH";

    /**
     * 构造函数
     *
     * @param content
     */
    public Controller(JSONObject content) throws YosException {
        super();
        try {
            this.dbConnect.setCreatesqllog(Parameter.get("system_db_sqllog").equalsIgnoreCase("true"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        this.content = content;
        returnObject = new ReturnObject(this);
        if (this.content.containsKey("pageNumber")) {
            pageNumber = this.content.getIntValue("pageNumber");
        }
        if (this.content.containsKey("pageSize")) {
            pageSize = this.content.getIntValue("pageSize");
        }
        if (this.content.containsKey("rowindex")) {
            rowindex = this.content.getIntValue("rowindex");
        }
        if (this.content.containsKey("accesstoken")) {
            accesstoken = this.content.getString("accesstoken");
            if (common.parameter.parameter.tokenlist.containsKey(accesstoken)) {
                usersiteid = common.parameter.parameter.tokenlist.get(accesstoken);
            }
        }
//        if (this.content.containsKey("where") && this.content.getJSONObject("where").containsKey("tablefilter")) {
//            tablefilter = this.content.getJSONObject("where").getJSONObject("tablefilter");
//        }
        if (parameter.usersiteIdList.containsKey(usersiteid)) {
            Row row = parameter.usersiteIdList.get(usersiteid);
            userid = row.getLong("userid");
            siteid = row.getString("siteid");
            username = row.getString("name");
            phonenumber = row.getString("phonenumber");
            systemclient = row.getString("systemclient");
            departmentid = row.getLong("departmentid");
            usertype = row.getInteger("usertype");
            hrid = row.getLong("hrid");

            if (row.containsKey("sys_enterpriseid")) {
                sys_enterpriseid = row.getLong("sys_enterpriseid");
            } else {
                Row enterpriseRow = getEnterpriseByUserid(userid);
                sys_enterpriseid = enterpriseRow.getLong("sys_enterpriseid");
                row.put("sys_enterpriseid", sys_enterpriseid);
                parameter.usersiteIdList.put(usersiteid, row);
            }

            if (row.containsKey("isleader")) {
                isleader = row.getBoolean("isleader");
            } else {
                isleader = getHr(userid).getBoolean("isleader") || getEnterpriseHr(userid).getBoolean("isleader");
                row.put("isleader", isleader);
                parameter.usersiteIdList.put(usersiteid, row);
            }
        }
        if (siteid == null || siteid.equals("") || content.containsKey("siteid")) {
            siteid = (String) content.getOrDefault("siteid", "");
        }
        userInfo = new ClientUserInfo(this);
        userInfo.setUserId(userid);
        userInfo.setUserName(username);
        userInfo.setPhoneNumber(phonenumber);
        userInfo.setSiteId(siteid);
        userInfo.setUserSiteId(usersiteid);
        userInfo.setUserType(usertype);
    }
//
//    /**
//     * 获取表格过滤条件
//     *
//     * @param table_alias 表名或查询表别名
//     * @param fieldname   数据表字段名称
//     * @param exact       true 精确搜索 false模糊搜索
//     */
//    public String getTableFilter(String table_alias, String fieldname, boolean exact) throws YosException {
//        if (tablefilter.containsKey(fieldname) && !tablefilter.getString(fieldname).equals("")) {
//            if (exact) {
//                return " and " + table_alias + "." + fieldname + "='" + tablefilter.getString(fieldname) + "'";
//            } else {
//                return " and " + table_alias + "." + fieldname + " like'%" + tablefilter.getString(fieldname) + "%'";
//            }
//        }
//        return "";
//    }
//
//    /**
//     * 获取表格过滤条件
//     *
//     * @param table_alias 表名或查询表别名
//     * @param fieldname   数据表字段名称
//     * @param field_alias 前端字段名称
//     * @param exact       true 精确搜索 false模糊搜索
//     */
//    public String getTableFilter(String table_alias, String fieldname, String field_alias, boolean exact) throws YosException {
//        if (tablefilter.containsKey(field_alias) && !tablefilter.getString(field_alias).equals("")) {
//            if (exact) {
//                return " and " + table_alias + "." + fieldname + "='" + tablefilter.getString(field_alias) + "'";
//            } else {
//                return " and " + table_alias + "." + fieldname + " like'%" + tablefilter.getString(field_alias) + "%'";
//            }
//        }
//        return "";
//    }

    public void setYosapi(YOSAPI requestAPI, YOSAPI.YosRequest request) {
        this.requestAPI = requestAPI;
        this.request = request;
        this.languagecode = request.getLanguageCode();
        this.userInfo.setLanguageCode(languagecode);
    }

    public String getAccesstoken() {
        return this.accesstoken;
    }

    public void setSorting() throws YosException {
        Sorting sorting = new Sorting(this, requestAPI);
        pageSorting = sorting.getOrderBy();
        pageSortingArray = sorting.getSorts();
    }

    public void setrequestFileItemList(List<FileItem> requestFileItemList) {
        this.requestFileItemList = requestFileItemList;
    }

    /**
     * 获取通过servlet接口上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory() throws IOException {
        for (FileItem item : requestFileItemList) {
            if (!item.isFormField()) {
                String filename = new String(item.getName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
                filename = filename.substring(0, filename.lastIndexOf("."));
                return new ExcelFactory(filename, item.getInputStream());
            }
        }
        return null;
    }


    /**
     * 获取通过华为云上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory(String obsObjectname) throws IOException, YosException {
        BucketFile bucketFile = new BucketFile(siteid);
        return new ExcelFactory(bucketFile.getObjectInputStream(obsObjectname));
    }


    /**
     * 获取通过华为云上传的excel
     *
     * @return
     * @throws IOException
     */
    public ExcelFactory getPostExcelFactory(Long attachmentid) throws IOException, YosException {
        Rows rows = dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return getPostExcelFactory(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public InputStream getPostFileInputStream(String obsObjectname) throws YosException {
        BucketFile bucketFile = new BucketFile(siteid);
        return bucketFile.getObjectInputStream(obsObjectname);
    }

    public InputStream getPostFileInputStream(Long attachmentid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return getPostFileInputStream(rows.get(0).getString("serialnumber"));
        }
        return null;
    }


    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows);
        return uploadExcelToObs(excelFactory);
    }

    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param columnwidths  列宽
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, columnwidths);
        return uploadExcelToObs(excelFactory);
    }


    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param titlemap      列标题
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap);
        return uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, exportFieldsArray, dataarrays);
        return uploadExcelToObs(excelFactory);
    }

    public Rows uploadEasyExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        EasyExcelFactory easyExcelFactory = new EasyExcelFactory(excelfilename);
        easyExcelFactory.setTableid(content.getLongValue("tableid"), siteid);
        easyExcelFactory.write(sheetname, exportFieldsArray, dataarrays);
        return uploadExcelToObs(easyExcelFactory);
    }

    public Rows uploadCSVToObs(String excelfilename, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        CSVFactory csvFactory = new CSVFactory(excelfilename);
        csvFactory.write(exportFieldsArray, dataarrays);
        return uploadExcelToObs(csvFactory);
    }

    /**
     * 将Rows生成excel并上传至华为云，同时返回附件信息
     *
     * @param excelfilename excel文件名称
     * @param sheetname     sheet名称
     * @param rows          数据
     * @param titlemap      列标题
     * @param columnwidths  列宽
     * @return
     * @throws YosException
     * @throws IOException
     */
    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap, columnwidths);
        return uploadExcelToObs(excelFactory);
    }

    /**
     * 将excel上传至华为云，并返回附件信息
     *
     * @return
     */
    public Rows uploadExcelToObs(ExcelFactory excelFactory) throws YosException {
        if (!excelFactory.isWrite) {
            try {
                excelFactory.write();
            } catch (Exception e) {
                throw new YosException("excel写入错误");
            }
        }
        return uploadFileToObs(excelFactory.getFile());
    }

    public Rows uploadExcelToObs(EasyExcelFactory easyExcelFactory) throws YosException {
        return uploadFileToObs(easyExcelFactory.getFile());
    }


    public Rows uploadExcelToObs(CSVFactory csvFactory) throws YosException {
        return uploadFileToObs(csvFactory.getFile());
    }


    /**
     * 将文件上传至华为云并返回附件信息
     *
     * @return
     */
    public Rows uploadFileToObs(File file) throws YosException {
        String document = file.getName();
        String postfix = "";
        try {
            postfix = document.substring(document.lastIndexOf(".") + 1);
        } catch (Exception e) {
            e.printStackTrace();
        }

        String serialnumber = createMD5FileName() + "." + postfix;
        BucketFile bucketFile = new BucketFile(siteid);
        bucketFile.upload(serialnumber, file);
        if (bucketFile.doesObjectExist(serialnumber)) {
            String appfolderid = Parameter.get(siteid, "appfolderid");
            long attachmentid = createTableID("sys_attachment");
            SQLFactory sqlFactory = new SQLFactory("附件信息插入");
            sqlFactory.addParameter("parentid", appfolderid);
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("createby", username);
            sqlFactory.addParameter("type", "sourcefile");
            sqlFactory.addParameter("postfix", postfix);
            sqlFactory.addParameter("serialnumber", serialnumber);
            sqlFactory.addParameter("document", document);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(serialnumber));
            sqlFactory.addParameter("mpctaskid", "null");
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(serialnumber).getContentLength());
            dbConnect.runSqlUpdate(sqlFactory);
            return getAttachmentUrl(attachmentid);
        }

        return new Rows();
    }

    /**
     * 创建媒体数据关联
     *
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @param attachmentid
     * @throws YosException
     */
    public void createFileLink(String ownertable, Long ownerid, String usetype, Long attachmentid) throws YosException {
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_attachment_links");
        insertSQL.setUniqueid(createTableID("sys_attachment_links"));
        insertSQL.setSiteid(siteid);
        insertSQL.setValue("attachmentid", attachmentid);
        insertSQL.setValue("ownertable", ownertable);
        insertSQL.setValue("ownerid", ownerid);
        insertSQL.setValue("usetype", usetype);
        insertSQL.setValue("createby", username);
        insertSQL.setDateValue("createdate");
        insertSQL.insert();
    }

    /**
     * 根据userid获取组织人员信息
     *
     * @param userid
     * @return
     */
    public Row getHr(long userid) throws YosException {
        return getHr(userid, siteid);
    }

    /**
     * 根据userid获取所属部门信息
     *
     * @param userid
     * @return
     */
    public Row getDepartment(long userid) throws YosException {
        return getDepartment(userid, siteid);
    }


    /**
     * 根据userid获取企业档案信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseByUserid(long userid) throws YosException {
        return getEnterpriseByUserid(userid, siteid);
    }

    /**
     * 根据userid获取企业人员信息
     *
     * @param userid
     * @return
     */
    public Row getEnterpriseHr(long userid) throws YosException {
        return getEnterpriseHr(userid, siteid);
    }

    /**
     * 根据sys_enterpriseid获取企业人员信息列表
     *
     * @param sys_enterpriseid
     * @return
     */
    public Rows getEnterpriseHrs(long sys_enterpriseid) throws YosException {
        return getEnterpriseHrs(sys_enterpriseid, siteid);
    }


    /**
     * 错误结果返回体
     *
     * @return
     */
    public ReturnObject_Err getErrReturnObject() {
        return returnObject.getErrObject();
    }

    public ReturnObject_Code getReturnObject() throws YosException {
        return returnObject.getCodeObject();
    }

    /**
     * 提醒（警告）结果返回体
     *
     * @return
     */
    public ReturnObject_Warn getWarnReturnObject() {
        return returnObject.getWarnObject();
    }

    /**
     * 成功结果返回体
     *
     * @return
     */
    public ReturnObject_Suc getSucReturnObject() {
        return returnObject.getSucObject();
    }

    /**
     * 使指定角色的账户登出
     *
     * @param roleid
     */
    public void logroleout(long roleid) throws YosException {
        ArrayList<String> useridlist = dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (!id.equals(String.valueOf(userid))) {
                loguserout(Long.parseLong(id));
            }
        }
    }

    /**
     * 获取附件信息
     *
     * @param ownertable 表名
     * @param ownerid    数据ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid) throws YosException {
        ArrayList<Long> ownerids = new ArrayList<>();
        ownerids.add(ownerid);
        return getAttachmentUrl(ownertable, ownerids).get(String.valueOf(ownerid));
    }

    /**
     * 获取附件信息
     *
     * @param ownertable 表名
     * @param ownerids   数据ID
     * @return
     */
    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids) throws YosException {
        return Attachment.get(this, ownertable, ownerids);
    }


    /**
     * 媒体信息查询
     *
     * @param attachmentid 媒体ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(Long... attachmentids) throws YosException {
        return Attachment.get(this, attachmentids);
    }

    /**
     * 媒体信息查询
     *
     * @param attachmentid 媒体ID
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(ArrayList<Long> attachmentid) throws YosException {
        return Attachment.get(this, attachmentid);
    }

    /**
     * 根据附件用途获取附件信息
     *
     * @param ownertable 表名
     * @param ownerid    数据ID
     * @param usetype    附件用途
     * @return
     */
    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid, String usetype) throws YosException {
        return Attachment.get(this, ownertable, ownerid, usetype);
    }

    /**
     * 根据附件用途获取附件信息
     *
     * @param ownertable 表名
     * @param ownerids   数据ID
     * @param usetype    附件用途
     * @return
     */
    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        return Attachment.get(this, ownertable, ownerids, usetype);
    }

    /**
     * 根据附件id查询子附件信息（转换附件或文件夹内附件）
     *
     * @param attachmentid 附件iD
     * @return
     */
    @Deprecated
    public Rows getSubAttachmentUrl(Long attachmentid) throws YosException {
        ArrayList<Long> attachmentids = new ArrayList<>();
        attachmentids.add(attachmentid);
        return getSubAttachmentUrl(attachmentids).get(attachmentid);
    }

    /**
     * 根据附件id查询子附件信息（转换附件或文件夹内附件）
     *
     * @param attachmentids 附件iD
     * @return
     */
    @Deprecated
    public RowsMap getSubAttachmentUrl(ArrayList<Long> attachmentids) throws YosException {
        return Attachment.getSub(this, attachmentids);
    }


    private static HashMap<Long, String> headPicMap = new HashMap<Long, String>();

    /**
     * 获取用户头像
     *
     * @return
     */
    public String getHeadPic(long userid) throws YosException {
        if (!headPicMap.containsKey(userid)) {
            Rows rows = Attachment.get(this, "sys_users", userid, "headportrait");
            headPicMap.put(userid, rows.isEmpty() ? "" : rows.get(0).getString("url"));
        }
        return headPicMap.getOrDefault(userid, "");
    }

    /**
     * 获取数据修改日志
     *
     * @param tablename
     * @param dataid
     * @return
     */
    public Rows getDataLog(String tablename, long dataid) throws YosException {
        Rows rows = dbConnect.runSqlQuery("select * from sys_datalog where table_name='" + tablename + "' and dataid=" + dataid + " order by changedate desc");
        for (Row row : rows) {
            row.put("olddata", JSONObject.parseObject(row.getString("olddata")));
            row.put("newdata", JSONObject.parseObject(row.getString("newdata")));
        }
        return rows;
    }

    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap<Long, ArrayList<Long>>();

    /**
     * 根据消息对话框ID获取用户id
     *
     * @param timdialogid
     * @return
     */
    public ArrayList<Long> getImDialogUserIds(long timdialogid) throws YosException {
        return getImDialogUserIds(timdialogid, siteid);
    }

    /**
     * 获取当前账号登陆时间
     *
     * @return
     */
    public Date getLoginDate() {
        return getLoginDate(usersiteid);
    }


    /**
     * 将除了当前账号外的其他账号全部登出
     *
     * @throws YosException
     */
    public void loguserout() throws YosException {
        ArrayList<String> usersiteids = dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid!=" + userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (common.parameter.parameter.usersiteIdList.containsKey(usersiteid)) {
                String token = common.parameter.parameter.usersiteIdList.get(usersiteid).getString("token");
                parameter.tokenlist.remove(token);
            }
        }
        dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + userid + "'");
    }

    public String createBillCode(String coderuletype) throws YosException {
        return createBillCode(siteid, coderuletype);
    }


    /**
     * 获取系统的图标url
     *
     * @param systemid
     * @return
     */
    public String getSystemIconUrl(Long systemid, String usetype) throws YosException {
        Row row = Attachment.getLatest(this, "sys_system", systemid, usetype);
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(dbConnect, "YOSSYS", "sys_system", systemid, usetype);
        return row.getString("url");
    }

    /**
     * 获取模块封面
     *
     * @param systemmoduleid
     * @return
     * @throws YosException
     */
    public String getSystemModuleCoverUrl(Long systemmoduleid) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemmodule", systemmoduleid, "cover");
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(dbConnect, "YOSSYS", "sys_systemmodule", systemmoduleid, "cover");
        return row.getString("url");
    }

    /**
     * 获取系统模块的图标url
     *
     * @param systemmoduleid
     * @return
     */
    public String getSystemModuleIconUrl(Long systemmoduleid, String usetype) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemmodule", systemmoduleid, usetype);
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(dbConnect, "YOSSYS", "sys_systemmodule", systemmoduleid, usetype);
        return row.getString("url");
    }

    public String getSystemAppCoverUrl(Long systemappid) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemapp", systemappid, "cover");
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(dbConnect, "YOSSYS", "sys_systemapp", systemappid, "cover");
        return row.getString("url");
    }


    /**
     * 创建一个报表请求日志，并且返回一个token
     *
     * @return
     */
    public String getReportToken(long sys_reportid) throws YosException {
        return getReportToken(sys_reportid, 0);
    }

    /**
     * 创建一个打印请求日志，并且返回一个token
     *
     * @return
     */
    public String getReportToken(long sys_reportid, long dataid) throws YosException {
        long sys_report_sessionid = createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(siteid + sys_reportid + sys_report_sessionid + username + userid);
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_report_session");
        insertSQL.setSiteid(siteid).setUniqueid(sys_report_sessionid);
        insertSQL.setValue("sys_reportid", sys_reportid);
        insertSQL.setValue("userid", userid);
        insertSQL.setDateValue("createdate");
        insertSQL.setValue("token", token);
        insertSQL.setValue("dataid", dataid);
        insertSQL.setValue("systemclient", systemclient);
        insertSQL.insert();
        return token;
    }

    /**
     * 清除当前账号的所有缓存
     */
    public void cleanAllDataPool() {
        DataPool.removeByAccesstoken(accesstoken);
    }

    /**
     * 清除指定账号的所有缓存
     *
     * @param userid
     */
    public void cleanAllDataPool(long userid) {
        DataPool.removeByUserid(userid);
    }


    /**
     * 清除指定账号的缓存，清理规则按照CACHEING_CLEAN注解
     *
     * @param userid
     */
    public void CACHEING_CLEAN(Long userid) {
        try {
            request.addCacheing_cleanUser(userid);
        } catch (Exception ignored) {
        }
    }


    /**
     * SQL系统参数处理
     *
     * @param sqlstr
     * @return
     * @throws YosException
     */
    public String SQLSystemParamHandle(String sqlstr) throws YosException {
        sqlstr = sqlstr.replaceAll("(?i):sys_enterpriseid", "'" + sys_enterpriseid + "'");
        sqlstr = sqlstr.replaceAll("(?i):userid", "'" + userid + "'");
        sqlstr = sqlstr.replaceAll("(?i):hrid", "'" + hrid + "'");
        sqlstr = sqlstr.replaceAll("(?i):departmentid", "'" + departmentid + "'");
        sqlstr = sqlstr.replaceAll("(?i):siteid", "'" + siteid + "'");

        if (sqlstr.contains(":subuserids")) {
            ArrayList<Long> sublist = User.getSubUserIds(this);
            sublist.add(userid);
            sqlstr = sqlstr.replaceAll("(?i):subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        if (sqlstr.contains(":subhrids")) {
            ArrayList<Long> sublist = User.getSubHrIds(this);
            sublist.add(hrid);
            sqlstr = sqlstr.replaceAll("(?i):subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        if (sqlstr.contains(":subsys_enterpriseids")) {
            ArrayList<Long> sublist = User.getSubEnterpriseids(this);
            if (sublist.isEmpty()) {
                sqlstr = sqlstr.replaceAll("(?i):subsys_enterpriseids", "(null)");
            } else {
                sqlstr = sqlstr.replaceAll("(?i):subsys_enterpriseids", sublist.toString().replace("[", "(").replace("]", ")"));
            }
        }
        if (sqlstr.contains(":subdepartmentids")) {
            ArrayList<Long> sublist = Department.getSubDepartmentIds(this);
            sublist.add(departmentid);
            sqlstr = sqlstr.replaceAll("(?i):subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        return sqlstr;
    }

}
