/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.sysmsg;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.management.OperatingSystemMXBean;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.parameter.License;
import common.parameter.parameter;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import restcontroller.R;
import utility.tools.Math;
import utility.tools.WebRequest;

public class sysmsg
extends Controller {
    public sysmsg(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u5783\u573e\u56de\u6536", apiversion=R.ID10026001.v1.class, intervaltime=5000L)
    public String gc() throws YosException {
        System.gc();
        return this.getSucReturnObject().toString();
    }

    @API(title="yos\u65e5\u5fd7\u67e5\u8be2", apiversion=R.ID10030101.v1.class)
    public String getyoslog() throws YosException {
        SQLiteTable sqLiteTable = SQLiteTable.getTable("YOSUPDATELOG");
        Rows logrows = SQLiteMemory.runSqlQuery("select * from YOSUPDATELOG order by RESOLVETIME desc,VERSION desc,LOG");
        RowsMap versionMaps = logrows.toRowsMap("VERSION");
        RowsMap versiontimeMaps = logrows.toRowsMap("VERSION", "RESOLVETIME");
        RowsMap versionMap = this.dbConnect.runSqlQuery("select version,updatetime from sys_yosupdatelog").toRowsMap("version");
        ArrayList<String> versioncache = new ArrayList<String>();
        ArrayList<String> versiontimecache = new ArrayList<String>();
        for (Row row : logrows) {
            String VERSION = row.getString("VERSION");
            String RESOLVETIME = row.getString("RESOLVETIME");
            row.put("UPDATETIME", versionMap.get(VERSION).get(0).getString("updatetime"));
            if (versioncache.contains(VERSION)) {
                row.put("rowversionspan", 0);
            } else {
                row.put("rowversionspan", versionMaps.get(VERSION).size());
                versioncache.add(VERSION);
            }
            if (versiontimecache.contains(VERSION + RESOLVETIME)) {
                row.put("rowtimespan", 0);
                continue;
            }
            row.put("rowtimespan", versiontimeMaps.get(VERSION + RESOLVETIME).size());
            versiontimecache.add(VERSION + RESOLVETIME);
        }
        return this.getSucReturnObject().setData(logrows).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(title="\u7cfb\u7edf\u76d1\u63a7", apiversion=R.ID10024601.v1.class)
    public String getMsg() throws YosException {
        long hourtimes;
        JSONObject javaObject;
        RuntimeMXBean runtime;
        JSONObject object;
        block43: {
            File[] roots;
            object = new JSONObject();
            JSONObject yosObject = new JSONObject();
            String datetime = "";
            String version2 = "";
            ClassLoader classLoader = sysmsg.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                    String filepath = url.getFile();
                    if (!filepath.contains("yos.core") || filepath.contains("sources")) continue;
                    File file = new File(filepath);
                    datetime = sysmsg.getDateTime_Str(file.lastModified());
                    version2 = file.getName().replace("yos.core", "").replace("-", "").replace(".jar", "");
                }
            }
            yosObject.put("datetime", (Object)datetime);
            yosObject.put("version", (Object)version2);
            object.put("yos", (Object)yosObject);
            License license = License.get();
            JSONObject yosObject2 = new JSONObject();
            yosObject2.put("VerifyDays", (Object)license.getVerifyDays());
            yosObject2.put("LicenseType", (Object)license.getLicenseType());
            yosObject2.put("Customer", (Object)license.getCustomer());
            yosObject2.put("MaxDBConCount", (Object)license.getMaxDBConCount());
            yosObject2.put("ExpiresDate", (Object)sysmsg.getDate_Str(license.getExpiresDate()));
            object.put("yoslicense", (Object)yosObject2);
            String url = Parameter.get("system_rest_requesturl");
            JSONObject sslObject = new JSONObject();
            if (!url.equals("") && url.startsWith("https")) {
                sslObject = WebRequest.getDomainCertificateInfo(url);
            }
            object.put("sslcert", (Object)sslObject);
            OperatingSystemMXBean system2 = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            JSONObject systemObject = new JSONObject();
            systemObject.put("Name", (Object)system2.getName());
            systemObject.put("Version", (Object)system2.getVersion());
            systemObject.put("Arch", (Object)system2.getArch());
            systemObject.put("TotalPhysicalMemorySize", (Object)Math.div(system2.getTotalPhysicalMemorySize(), 1048576.0, 2));
            systemObject.put("FreePhysicalMemorySize", (Object)Math.div(system2.getFreePhysicalMemorySize(), 1048576.0, 2));
            systemObject.put("PhysicalMemoryUseRate", (Object)(1.0 - Math.div(system2.getFreePhysicalMemorySize(), system2.getTotalPhysicalMemorySize(), 6)));
            systemObject.put("ProcessCpuLoad", (Object)Math.mul(system2.getProcessCpuLoad(), 100.0, 2));
            systemObject.put("SystemCpuLoad", (Object)Math.mul(system2.getSystemCpuLoad(), 100.0, 2));
            try {
                systemObject.put("HostName", (Object)InetAddress.getLocalHost().getHostName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            systemObject.put("AvailableProcessors", (Object)system2.getAvailableProcessors());
            object.put("system", (Object)systemObject);
            JSONArray diskArray = new JSONArray();
            for (File root : roots = File.listRoots()) {
                String path = root.getAbsolutePath();
                long totalSpace = root.getTotalSpace();
                long usableSpace = root.getUsableSpace();
                JSONObject usedObject = new JSONObject();
                usedObject.put("type", (Object)"\u5df2\u7528");
                usedObject.put("path", (Object)path);
                usedObject.put("value", (Object)((totalSpace - usableSpace) / 0x40000000L));
                usedObject.put("label", (Object)sysmsg.formatSize(totalSpace - usableSpace));
                if (totalSpace > 0L) {
                    usedObject.put("rate", (Object)Math.div(totalSpace - usableSpace, totalSpace, 2));
                } else {
                    usedObject.put("rate", (Object)0);
                }
                diskArray.add((Object)usedObject);
                JSONObject usableObject = new JSONObject();
                usableObject.put("type", (Object)"\u7a7a\u95f2");
                usableObject.put("path", (Object)path);
                usableObject.put("value", (Object)(usableSpace / 0x40000000L));
                usableObject.put("label", (Object)sysmsg.formatSize(usableSpace));
                if (totalSpace > 0L) {
                    usableObject.put("rate", (Object)Math.div(usableSpace, totalSpace, 2));
                } else {
                    usableObject.put("rate", (Object)0);
                }
                diskArray.add((Object)usableObject);
            }
            object.put("disk", (Object)diskArray);
            runtime = ManagementFactory.getRuntimeMXBean();
            javaObject = new JSONObject();
            javaObject.put("PID", (Object)runtime.getName().split("@")[0]);
            javaObject.put("SpecVersion", (Object)runtime.getSpecVersion());
            javaObject.put("StartTime", (Object)sysmsg.getDateTime_Str(runtime.getStartTime()));
            javaObject.put("VmVersion", (Object)runtime.getVmVersion());
            double totalMemory = 0.0;
            try {
                List<String> args = runtime.getInputArguments();
                if (args == null || args.isEmpty()) break block43;
                for (String arg : args) {
                    if (!(arg = arg.toLowerCase()).contains("-xmx")) continue;
                    if ((arg = arg.replace("-xmx", "").replace("-", "")).contains("mb")) {
                        totalMemory = Math.div(Double.parseDouble(arg.replace("mb", "")), 1024.0, 2);
                    } else if (arg.contains("m")) {
                        totalMemory = Math.div(Double.parseDouble(arg.replace("m", "")), 1024.0, 2);
                    } else if (arg.contains("gb")) {
                        totalMemory = Double.parseDouble(arg.replace("gb", ""));
                    } else if (arg.contains("g")) {
                        totalMemory = Double.parseDouble(arg.replace("g", ""));
                    }
                    break;
                }
            }
            finally {
                if (totalMemory > 0.0) {
                    javaObject.put("totalMemory", (Object)totalMemory);
                } else {
                    javaObject.put("totalMemory", (Object)Math.div(Runtime.getRuntime().maxMemory(), 1.073741824E9, 2));
                }
            }
        }
        long runtitme = runtime.getUptime();
        String timestr = "";
        long daytimes = 86400000L;
        if (runtitme / daytimes > 0L) {
            timestr = runtitme / daytimes + "\u5929";
            runtitme %= daytimes;
        }
        if (runtitme / (hourtimes = 3600000L) > 0L) {
            timestr = timestr + runtitme / hourtimes + "\u5c0f\u65f6";
            runtitme %= hourtimes;
        }
        long mtimes = 60000L;
        if (!timestr.contains("\u5929") && runtitme / mtimes > 0L) {
            timestr = timestr + runtitme / mtimes + "\u5206";
        }
        javaObject.put("UpTime", (Object)timestr);
        JSONObject array = new JSONObject();
        List<GarbageCollectorMXBean> garbages = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean g : garbages) {
            JSONObject object1 = new JSONObject();
            object1.put("count", (Object)g.getCollectionCount());
            object1.put("time", (Object)g.getCollectionTime());
            array.put(g.getName().replace(" ", ""), (Object)object1);
        }
        javaObject.put("GarbageCollector", (Object)array);
        JSONObject MemoryUsageObject = new JSONObject();
        MemoryUsageObject.put("NonHeap", JSON.toJSON((Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
        MemoryUsageObject.put("Heap", JSON.toJSON((Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
        javaObject.put("MemoryUsage", (Object)MemoryUsageObject);
        List<MemoryPoolMXBean> memoryPoolMXBeansList = ManagementFactory.getMemoryPoolMXBeans();
        JSONObject memoryPoolMXBeansObject = new JSONObject();
        for (MemoryPoolMXBean m : memoryPoolMXBeansList) {
            String poolname = m.getName().replace(" ", "");
            memoryPoolMXBeansObject.put(poolname, JSON.toJSON((Object)m.getUsage()));
        }
        javaObject.put("MemoryPool", (Object)memoryPoolMXBeansObject);
        object.put("java", (Object)javaObject);
        ThreadMXBean thread = ManagementFactory.getThreadMXBean();
        JSONObject threadObject = new JSONObject();
        threadObject.put("threadCount", (Object)thread.getThreadCount());
        threadObject.put("peakThreadCount", (Object)thread.getPeakThreadCount());
        long[] deadlockedIds = thread.findDeadlockedThreads();
        if (deadlockedIds != null && deadlockedIds.length > 0) {
            threadObject.put("deadlockedthreads", JSON.toJSON((Object)thread.getThreadInfo(deadlockedIds)));
        } else {
            threadObject.put("deadlockedthreads", (Object)new JSONArray());
        }
        object.put("threads", (Object)threadObject);
        JSONObject mysqlObject = new JSONObject();
        mysqlObject.put("Version", (Object)this.dbConnect.runSqlQuery("select version() as version ").get(0).getString("version"));
        Rows variableRows = this.dbConnect.runSqlQuery("show variables where Variable_name in('innodb_buffer_pool_size','innodb_log_file_size','innodb_log_buffer_size','key_buffer_size','tmp_table_size','read_buffer_size','sort_buffer_size','read_rnd_buffer_size')");
        mysqlObject.put("Variables", (Object)variableRows);
        JSONArray processArray = new JSONArray();
        Rows processRows = this.dbConnect.runSqlQuery("SHOW full PROCESSLIST");
        for (Row processRow : processRows) {
            if (processRow.getString("User").equalsIgnoreCase("event_scheduler")) continue;
            JSONObject ProcessObject = new JSONObject();
            ProcessObject.put("User", (Object)processRow.getString("User"));
            ProcessObject.put("Command", (Object)processRow.getString("Command"));
            ProcessObject.put("State", (Object)processRow.getString("State"));
            ProcessObject.put("Time", (Object)processRow.getString("Time"));
            ProcessObject.put("Id", (Object)processRow.getLong("Id"));
            ProcessObject.put("Info", (Object)processRow.getString("Info"));
            ProcessObject.put("db", (Object)processRow.getString("db"));
            if (DBConnectPool.connectionIDList.contains(processRow.getLong("Id"))) {
                ProcessObject.put("from", (Object)"yos");
            } else {
                ProcessObject.put("from", (Object)"other");
            }
            processArray.add((Object)ProcessObject);
        }
        processArray.sort((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                JSONObject object1 = (JSONObject)o1;
                JSONObject object2 = (JSONObject)o2;
                String Command_o1 = "";
                String Command_o2 = "";
                String From_o1 = "";
                String From_o2 = "";
                try {
                    Command_o1 = object1.getString("Command");
                    Command_o2 = object2.getString("Command");
                    From_o1 = object1.getString("from");
                    From_o2 = object2.getString("from");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (From_o1.equals("yos") && !From_o1.equals(From_o2)) {
                    return -2;
                }
                if (!Command_o1.equals("Sleep") && !Command_o2.equals(Command_o1)) {
                    return -1;
                }
                if (Command_o1.equals(Command_o2)) {
                    return 0;
                }
                return 1;
            }
        });
        mysqlObject.put("Processlist", (Object)processArray);
        int ConnectPoolsSize = DBConnectPool.POOLS_MAP.get("default").size();
        int ConnectTotalCount = ConnectPoolsSize + DBConnectPool.useingConnectionkeyMap.get("default").size();
        mysqlObject.put("ConnectPoolsSize", (Object)(ConnectPoolsSize == 0 ? ConnectPoolsSize : ConnectPoolsSize - 1));
        mysqlObject.put("ConnectTotalCount", (Object)ConnectTotalCount);
        ArrayList<String> dblist = this.dbConnect.runSqlQuery("select distinct dbname from sys_datasource where isdataarchive=1").toArrayList("dbname");
        dblist.add(this.dbConnect.getDBName());
        StringBuffer b = new StringBuffer();
        for (String db : dblist) {
            if (!b.toString().equals("")) {
                b.append(",");
            }
            b.append("'").append(db).append("'");
        }
        Row datarow = this.dbConnect.runSqlQuery("SELECT SUM(data_length) AS datavolume,SUM(index_length) AS indexvolume,sum(table_rows)as data_rows FROM information_schema.TABLES where table_schema in(" + b + ") ").get(0);
        mysqlObject.put("datavolume", (Object)Math.div(Long.parseLong(datarow.getString("datavolume")), 1.073741824E9, 2));
        mysqlObject.put("indexvolume", (Object)Math.div(Long.parseLong(datarow.getString("indexvolume")), 1.073741824E9, 2));
        mysqlObject.put("datarows", (Object)Math.div(Long.parseLong(datarow.getString("data_rows")), 10000.0, 1));
        object.put("mysql", (Object)mysqlObject);
        HashMap<String, String> usertypeMap = this.getOptionType("usertype");
        RowsMap systemclientMap = this.dbConnect.runSqlQuery("select distinct systemclient,systemclientname from sys_systemclient").toRowsMap("systemclient");
        Object[] usersiteids = parameter.websocketClients.keySet().toArray(new Long[0]);
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
        querySQL.setWhere("usersiteid", usersiteids);
        Rows loginuserrows = querySQL.query();
        for (Row loginuserrow : loginuserrows) {
            Set tokens = parameter.websocketClients.getOrDefault(loginuserrow.getLong("usersiteid"), new ConcurrentHashMap()).keySet();
            JSONArray array2 = new JSONArray();
            for (String token : tokens) {
                String c = parameter.tokensystemclientlist.getOrDefault(token, "");
                if (systemclientMap.containsKey(c)) {
                    c = systemclientMap.get(c).get(0).getString("systemclientname");
                }
                if (c.equals("") || array2.contains((Object)c)) continue;
                array2.add((Object)c);
            }
            loginuserrow.put("systemclients", array2);
            loginuserrow.put("usertype", usertypeMap.getOrDefault(loginuserrow.getString("usertype"), loginuserrow.getString("usertype")));
        }
        object.put("loginusers", (Object)loginuserrows);
        QuerySQL querySQL2 = SQLFactory.createQuerySQL(this, "sys_usersite", "usersiteid", "userid", "siteid", "usertype");
        querySQL2.addJoinTable(BaseClass.JOINTYPE.inner, "sys_users", "sys_users", "userid=:userid", "accountno", "name", "sysadministrator", "phonenumber");
        querySQL2.addJoinTable(BaseClass.JOINTYPE.inner, "sys_userrequestlog", "sys_userrequestlog", "usersiteid=:usersiteid");
        querySQL2.addQueryFields("requesttimes", "sum(requesttimes)").addQueryFields("lastrequestdate", "max(lastrequestdate)");
        querySQL2.addGroupBy(new String[0]);
        querySQL2.setWhere("sys_userrequestlog.date=date_format(now(),'%Y-%m-%d')");
        Rows loginuserrows2 = querySQL2.query();
        for (Row loginuserrow : loginuserrows2) {
            loginuserrow.put("usertype", usertypeMap.getOrDefault(loginuserrow.getString("usertype"), loginuserrow.getString("usertype")));
        }
        object.put("requestusers", (Object)loginuserrows2);
        Rows rows = this.dbConnect.runSqlQuery("select postfix,count(0) filecount,sum(contentlength) as contentlength from sys_attachment group by postfix order by sum(contentlength) desc");
        for (Row row : rows) {
            double contentlength = row.getDouble("contentlength");
            if (contentlength / 1.073741824E9 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1.073741824E9, 2) + " GB");
                continue;
            }
            if (contentlength / 1048576.0 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1048576.0, 2) + " MB");
                continue;
            }
            if (contentlength / 1024.0 > 1.0) {
                row.put("contentlength", Math.div(contentlength, 1024.0, 2) + " KB");
                continue;
            }
            row.put("contentlength", new Double(contentlength).longValue() + " byte");
        }
        object.put("attachmentmsg", (Object)rows);
        return this.getSucReturnObject().setData(object).toString();
    }

    public static String formatSize(long bytes) {
        double size;
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int unitIndex = 0;
        for (size = (double)bytes; size >= 1024.0 && unitIndex < units.length - 1; size /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f %s", size, units[unitIndex]);
    }
}

