/*
 * Decompiled with CFR 0.152.
 */
package restcontroller.sysmanage.develop.sys_object;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.DBConnectPool;
import common.data.db.SQLiteMemory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import restcontroller.R;

@API(title="\u7ba1\u7406\u7aef-\u5f00\u53d1-\u6570\u636e\u5e93\u7ba1\u7406")
public class sys_object
extends Controller {
    private static long lasttableAnalyzeTime = 0L;

    public sys_object(JSONObject content) throws YosException {
        super(content);
    }

    @API(title="\u8868\u4fe1\u606f\u67e5\u8be2", apiversion=R.ID10000101.v1.class)
    public String queryObjectList() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where")) {
            JSONObject whereObject = this.content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.uniquecolumnname ='").append(whereObject.getString("condition")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("issystem") && !"".equals(whereObject.getString("issystem"))) {
                where.append(" and(");
                where.append("t1.issystem ='").append(whereObject.getString("issystem")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("app") && !"".equals(whereObject.getString("app"))) {
                where.append(" and(");
                where.append("exists (select * from sys_objectapps inner join sys_systemapp on sys_objectapps.systemappid=sys_systemapp.systemappid and sys_objectapps.table_name=t1.table_name and (sys_systemapp.systemapp like'%" + whereObject.getString("app") + "%' or sys_systemapp.systemappname like '%" + whereObject.getString("app") + "%')  )");
                where.append(")");
            }
            if (whereObject.containsKey("fieldname") && !"".equals(whereObject.getString("fieldname"))) {
                where.append(" and(");
                where.append("exists (select * from sys_objectcols where sys_objectcols.table_name=t1.table_name and (sys_objectcols.column_name like'%" + whereObject.getString("fieldname") + "%' or sys_objectcols.column_title like '%" + whereObject.getString("fieldname") + "%')  )");
                where.append(")");
            }
        }
        SQLFactory selectTable = new SQLFactory(this, "\u8868\u4fe1\u606f\u67e5\u8be2", this.pageSize, this.pageNumber, this.pageSorting);
        selectTable.addParameter_SQL("where", where);
        selectTable.addParameter("TABLE_SCHEMA", this.dbConnect.getDBName());
        Rows tableRows = this.dbConnect.runSqlQuery(selectTable.getSQL());
        QuerySQL sys_objectappsQuerySQL = SQLFactory.createQuerySQL(this, "sys_objectapps", "table_name");
        sys_objectappsQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_systemapp", "sys_systemapp", "systemappid=:systemappid", "systemappname");
        sys_objectappsQuerySQL.setWhere("sys_objectapps.table_name", tableRows.toArrayList("table_name"));
        RowsMap sys_objectappsRowsMap = sys_objectappsQuerySQL.query().toRowsMap("table_name");
        ArrayList<String> sys_objectcolsList = this.dbConnect.runSqlQuery("select distinct table_name from sys_objectcols where savedatalog=1").toArrayList("table_name");
        for (Row row : tableRows) {
            String table_name = row.getString("table_name");
            row.put("apps", sys_objectappsRowsMap.get(table_name).toJsonArray("systemappname"));
            row.put("savedatalog", sys_objectcolsList.contains(table_name) ? 1 : 0);
        }
        if (Calendar.getInstance().getTimeInMillis() - lasttableAnalyzeTime > 600000L) {
            lasttableAnalyzeTime = Calendar.getInstance().getTimeInMillis();
            this.tableAnalyze(tableRows.toArrayList("table_name"));
        }
        return this.getSucReturnObject().setData(tableRows).toString();
    }

    public void tableAnalyze(final ArrayList<String> tablelist) throws YosException {
        new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    ArrayList<String> sqlist = new ArrayList<String>();
                    for (String table_name : tablelist) {
                        sqlist.add("ANALYZE TABLE " + table_name + ";");
                    }
                    sys_object.this.dbConnect.runSqlUpdate(sqlist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    @API(title="\u8868\u5b57\u6bb5\u4fe1\u606f\u67e5\u8be2", apiversion=R.ID10000201.v1.class)
    public String queryObjectColList() throws YosException {
        String table_name = this.content.getString("table_name");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_objectcols", new String[0]).setPage(this.pageSize, this.pageNumber);
        querySQL.addQueryFields("table_name,column_name,column_title,column_default,numeric_precision,numeric_scale,column_type,column_comment,is_nullable,status,createdate,changedate, savedatalog,uniqued,sequence");
        querySQL.setWhere("table_name", table_name);
        querySQL.setCondition("column_name", "column_comment");
        Rows tableRows = querySQL.query();
        return this.getSucReturnObject().setData(tableRows).toString();
    }

    @API(title="\u65b0\u589e\u4fee\u6539\u8868", apiversion=R.ID10000301.v1.class)
    public String insertormodify_object() throws YosException {
        String table_name = this.content.getString("table_name").toLowerCase();
        String table_comment = this.content.getString("table_comment");
        int sequence = this.content.getIntValue("sequence");
        if (table_name.equals("") || !String.valueOf(table_name.charAt(0)).matches("^[a-zA-Z]*")) {
            return this.getErrReturnObject().setErrMsg("\u8868\u540d\u5fc5\u987b\u4ee5\u5c0f\u5199\u82f1\u6587\u5b57\u6bcd\u5f00\u5934").toString();
        }
        if (!table_name.replace("_", "").matches("^[a-z0-9]*")) {
            return this.getErrReturnObject().setErrMsg("\u8868\u540d\u5fc5\u987b\u4e3a\u5c0f\u5199\u82f1\u6587\u5b57\u6bcd\u6216\u82f1\u6587\u6570\u5b57\u7ec4\u5408").toString();
        }
        if ("".equals(table_comment)) {
            return this.getErrReturnObject().setErrMsg("\u6570\u636e\u8868\u63cf\u8ff0\u4e0d\u53ef\u4e3a\u7a7a").toString();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'").isEmpty()) {
            String uniquecolumnname = table_name + "id";
            SQLFactory insertTable = new SQLFactory(this, "\u8868\u65b0\u589e");
            insertTable.addParameter("table_name", table_name);
            insertTable.addParameter("table_comment", table_comment);
            insertTable.addParameter("uniquecolumnname", uniquecolumnname);
            insertTable.addParameter("sequence", sequence);
            list.add(insertTable.getSQL());
            SQLFactory insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", uniquecolumnname);
            insertCol.addParameter("column_title", table_comment + "ID");
            insertCol.addParameter("column_default", "null");
            insertCol.addParameter("numeric_precision", 19);
            insertCol.addParameter("numeric_scale", 0);
            insertCol.addParameter("column_type", "bigint");
            insertCol.addParameter("column_comment", table_comment + "ID");
            insertCol.addParameter("is_nullable", 0);
            insertCol.addParameter("savedatalog", 0);
            insertCol.addParameter("uniqued", 1);
            insertCol.addParameter("sequence", 1);
            list.add(insertCol.getSQL());
            insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", "siteid");
            insertCol.addParameter("column_title", "\u7ad9\u70b9");
            insertCol.addParameter("column_default", "null");
            insertCol.addParameter("numeric_precision", 50);
            insertCol.addParameter("numeric_scale", 0);
            insertCol.addParameter("column_type", "varchar");
            insertCol.addParameter("column_comment", "\u7ad9\u70b9ID");
            insertCol.addParameter("is_nullable", 0);
            insertCol.addParameter("savedatalog", 0);
            insertCol.addParameter("uniqued", 0);
            insertCol.addParameter("sequence", 2);
            list.add(insertCol.getSQL());
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createuserid");
                insertCol.addParameter("column_title", "\u521b\u5efa\u4eba\u8d26\u53f7ID");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "bigint");
                insertCol.addParameter("column_comment", "\u521b\u5efa\u4eba\u8d26\u53f7ID");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1002);
                list.add(insertCol.getSQL());
            }
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createby");
                insertCol.addParameter("column_title", "\u521b\u5efa\u4eba");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 50);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "varchar");
                insertCol.addParameter("column_comment", "\u521b\u5efa\u4eba");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1003);
                list.add(insertCol.getSQL());
            }
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "createdate");
                insertCol.addParameter("column_title", "\u521b\u5efa\u65f6\u95f4");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "datetime");
                insertCol.addParameter("column_comment", "\u521b\u5efa\u65f6\u95f4");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1004);
                list.add(insertCol.getSQL());
            }
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changeuserid");
                insertCol.addParameter("column_title", "\u4fee\u6539\u4eba\u8d26\u53f7ID");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "bigint");
                insertCol.addParameter("column_comment", "\u4fee\u6539\u4eba\u8d26\u53f7ID");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1007);
                list.add(insertCol.getSQL());
            }
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changeby");
                insertCol.addParameter("column_title", "\u4fee\u6539\u4eba");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 50);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "varchar");
                insertCol.addParameter("column_comment", "\u4fee\u6539\u4eba");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1008);
                list.add(insertCol.getSQL());
            }
            if (!this.content.getBooleanValue("isasync")) {
                insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", "changedate");
                insertCol.addParameter("column_title", "\u4fee\u6539\u65f6\u95f4");
                insertCol.addParameter("column_default", "null");
                insertCol.addParameter("numeric_precision", 19);
                insertCol.addParameter("numeric_scale", 0);
                insertCol.addParameter("column_type", "datetime");
                insertCol.addParameter("column_comment", "\u4fee\u6539\u65f6\u95f4");
                insertCol.addParameter("is_nullable", 1);
                insertCol.addParameter("savedatalog", 0);
                insertCol.addParameter("uniqued", 0);
                insertCol.addParameter("sequence", 1009);
                list.add(insertCol.getSQL());
            }
        } else {
            Rows sys_objectrows = this.dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
            if (sys_objectrows.isEmpty()) {
                return this.getErrReturnObject().setErrMsg("\u4e0d\u5b58\u5728\u7684\u8868\uff01").toString();
            }
            if (sys_objectrows.get(0).getBoolean("issystem")) {
                return this.getErrReturnObject().setErrMsg("\u7cfb\u7edf\u8868\u4e0d\u53ef\u4fee\u6539\uff01").toString();
            }
            String old_table_comment = sys_objectrows.get(0).getString("table_comment");
            if (!old_table_comment.equals(table_comment)) {
                SQLFactory modifyTable = new SQLFactory(this, "\u8868\u4fee\u6539");
                modifyTable.addParameter("table_name", table_name);
                modifyTable.addParameter("table_comment", table_comment);
                modifyTable.addParameter("sequence", sequence);
                list.add(modifyTable.getSQL());
                String uniquecolumnname = sys_objectrows.get(0).getString("uniquecolumnname");
                list.add("update sys_objectcols set status=(case when status is null then 'C' else status end ),column_title='" + table_comment + "',column_comment='" + table_comment + "ID' where table_name='" + table_name + "' and column_name='" + uniquecolumnname + "'");
                list.add("update sys_objectcols set status=(case when status is null then 'C' else status end ),column_title='" + table_comment + "',column_comment='" + table_comment + "ID' where table_name!='" + table_name + "' and column_name='" + uniquecolumnname + "'");
                list.add("update sys_object set status=(case when status is null then 'C' else status end ) where table_name!='" + table_name + "' and exists(select * from sys_objectcols where sys_objectcols.table_name=sys_object.table_name and column_name='" + uniquecolumnname + "')");
            } else {
                list.add("update sys_object set sequence=" + sequence + " where table_name='" + table_name + "'");
            }
        }
        this.dbConnect.runSqlUpdate(list);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5220\u9664\u8868", apiversion=R.ID10000401.v1.class)
    public String delete_object() throws YosException {
        String table_name = this.content.getString("table_name").toLowerCase();
        boolean isdelete = this.content.getBooleanValue("isdelete");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        boolean issystem = rows.get(0).getBoolean("issystem");
        if (issystem) {
            return this.getErrReturnObject().setErrMsg("\u7cfb\u7edf\u8868\u4e0d\u53ef\u5220\u9664\uff01").toString();
        }
        ArrayList<String> list = new ArrayList<String>();
        String oldstatus = rows.get(0).getString("status");
        if (oldstatus.equals("C")) {
            return this.getErrReturnObject().setErrMsg("\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01").toString();
        }
        if (isdelete) {
            if (oldstatus.equals("A")) {
                list.add("delete from sys_object where table_name='" + table_name + "'");
                list.add("delete from sys_objectcols where table_name='" + table_name + "'");
            } else {
                if (this.dbConnect.runSqlQuery("select count(0) as count from " + table_name).get(0).getLong("count") > 0L) {
                    return this.getErrReturnObject().setErrMsg("\u8be5\u8868\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01").toString();
                }
                list.add("update sys_object set status='D' where table_name='" + table_name + "'");
                list.add("update sys_objectcols set status='D' where table_name='" + table_name + "'");
            }
        } else {
            list.add("update sys_object set status=null where table_name='" + table_name + "'");
            list.add("update sys_objectcols set status=null where table_name='" + table_name + "'");
        }
        this.dbConnect.runSqlUpdate(list);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u65b0\u589e\u6570\u636e\u7248\u672c\u53f7\u5b57\u6bb5", apiversion=R.ID10023001.v1.class)
    public String insertDataVersionColumn() throws YosException {
        String table_name = this.content.getString("table_name").toLowerCase();
        Rows tablerows = this.dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        if (tablerows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u4e0d\u5b58\u5728\u8868" + table_name).toString();
        }
        if (!tablerows.get(0).getString("status").equals("")) {
            return this.getErrReturnObject().setErrMsg("\u5f53\u524d\u8868\u72b6\u6001\u4e0b\u4e0d\u53ef\u6dfb\u52a0\u6570\u636e\u7248\u672c\u53f7\u5b57\u6bb5\uff0c\u8bf7\u5148\u8fdb\u884c\u5e94\u7528\u914d\u7f6e\u66f4\u6539").toString();
        }
        String column_name = this.getdataversioncolumnname(table_name);
        if (this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'").isEmpty()) {
            ArrayList<String> sqlist = new ArrayList<String>();
            SQLFactory insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", column_name);
            insertCol.addParameter("column_default", "1");
            insertCol.addParameter("column_type", "int");
            insertCol.addParameter("numeric_precision", 10);
            insertCol.addParameter("numeric_scale", 0);
            insertCol.addParameter("column_comment", "\u6570\u636e\u7248\u672c\u53f7");
            insertCol.addParameter("column_title", "\u6570\u636e\u7248\u672c\u53f7");
            insertCol.addParameter("is_nullable", 0);
            insertCol.addParameter("savedatalog", 0);
            insertCol.addParameter("uniqued", 0);
            insertCol.addParameter("sequence", 3);
            sqlist.add(insertCol.getSQL());
            sqlist.add("update sys_object set status='C' where table_name='" + table_name + "' and ifnull(status,'')=''");
            this.dbConnect.runSqlUpdate(sqlist);
            this.cleanTableColumnTitle(table_name, column_name);
            this.cleanTableColumnNamesMaps(table_name);
            this.applydbchanges();
        }
        return this.getSucReturnObject().toString();
    }

    /*
     * Unable to fully structure code
     */
    @API(title="\u65b0\u589e\u4fee\u6539\u8868\u5b57\u6bb5", apiversion=R.ID10000501.v1.class)
    public String insertormodify_objectcol() throws YosException {
        table_name = this.content.getString("table_name").toLowerCase();
        column_name = this.content.getString("column_name").toLowerCase();
        issync = this.content.getBooleanValue("issync");
        if (column_name.equals("") || !String.valueOf(column_name.charAt(0)).matches("^[a-z]*")) {
            return this.getErrReturnObject().setErrMsg("\u5b57\u6bb5\u540d\u79f0\u5fc5\u987b\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934").toString();
        }
        if (!column_name.replace("_", "").matches("^[a-z0-9]*")) {
            return this.getErrReturnObject().setErrMsg("\u5b57\u6bb5\u540d\u79f0\u4e3a\u82f1\u6587\u5b57\u6bcd\u6216\u82f1\u6587\u6570\u5b57\u7ec4\u5408").toString();
        }
        column_default = this.content.getStringValue("column_default");
        column_type = this.content.getString("column_type");
        column_comment = this.content.getString("column_comment");
        column_title = this.content.getString("column_title");
        numeric_precision = this.content.getInteger("numeric_precision");
        numeric_scale = this.content.getInteger("numeric_scale");
        savedatalog = this.content.getBooleanValue("savedatalog");
        if (savedatalog && this.dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and column_name='changeuserid'").isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u6dfb\u52a0changeuserid\u540e\u624d\u53ef\u5f00\u542f\u6570\u636e\u65e5\u5fd7").toString();
        }
        is_nullable = this.content.getBooleanValue("is_nullable");
        var12_12 = column_type;
        var13_14 = -1;
        switch (var12_12.hashCode()) {
            case -1389167889: {
                if (!var12_12.equals("bigint")) break;
                var13_14 = 0;
                break;
            }
            case 1793702779: {
                if (!var12_12.equals("datetime")) break;
                var13_14 = 1;
                break;
            }
            case 104431: {
                if (!var12_12.equals("int")) break;
                var13_14 = 2;
                break;
            }
            case 3076014: {
                if (!var12_12.equals("date")) break;
                var13_14 = 3;
                break;
            }
            case -606531192: {
                if (!var12_12.equals("smallint")) break;
                var13_14 = 4;
                break;
            }
            case 64711720: {
                if (!var12_12.equals("boolean")) break;
                var13_14 = 5;
                break;
            }
            case 3271912: {
                if (!var12_12.equals("json")) break;
                var13_14 = 6;
            }
        }
        switch (var13_14) {
            case 0: 
            case 1: {
                numeric_precision = 19;
                numeric_scale = 0;
                break;
            }
            case 2: 
            case 3: {
                numeric_precision = 10;
                numeric_scale = 0;
                break;
            }
            case 4: {
                numeric_precision = 5;
                numeric_scale = 0;
                break;
            }
            case 5: {
                numeric_precision = 1;
                numeric_scale = 0;
                is_nullable = false;
                column_default = this.content.getBooleanValue("column_default") != false ? "true" : "false";
                break;
            }
            case 6: {
                try {
                    if (column_default.trim().startsWith("{")) {
                        column_default = this.content.getJSONObject("column_default").toString();
                        ** break;
                    }
                    if (column_default.trim().startsWith("[")) {
                        column_default = this.content.getJSONArray("column_default").toString();
                        ** break;
                    }
                    if (!column_default.trim().equals("")) {
                        return this.getErrReturnObject().setErrMsg("\u9ed8\u8ba4\u503c\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f").toString();
                    }
lbl77:
                    // 4 sources

                    break;
                }
                catch (Exception e) {
                    return this.getErrReturnObject().setErrMsg("\u9ed8\u8ba4\u503c\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f").toString();
                }
            }
        }
        uniqued = this.content.getBooleanValue("uniqued");
        sys_objectRows = this.dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg(table_name + "\u8868\u4e0d\u5b58\u5728\uff01").toString();
        }
        if (sys_objectRows.get(0).getBoolean("issystem") && !issync) {
            return this.getErrReturnObject().setErrMsg("\u7cfb\u7edf\u8868\u4e0d\u53ef\u4fee\u6539\uff01").toString();
        }
        if (sys_objectRows.get(0).getString("uniquecolumnname").equals(column_name) && !issync) {
            return this.getErrReturnObject().setErrMsg("\u8868ID\u5b57\u6bb5\u4e0d\u53ef\u4fee\u6539").toString();
        }
        if (this.getdataversioncolumnname(table_name).equalsIgnoreCase(column_name) && !issync) {
            return this.getErrReturnObject().setErrMsg("\u6570\u636e\u7248\u672c\u53f7\u5b57\u6bb5\u4e0d\u53ef\u4fee\u6539").toString();
        }
        if (this.getdataversioncolumnname(table_name).equals(column_name) && !issync) {
            return this.getErrReturnObject().setErrMsg("\u5f53\u524d\u5b57\u6bb5\u540d\u79f0\u4e3a\u7cfb\u7edf\u4fdd\u7559\u5b57\u6bb5\uff0c\u4e0d\u53ef\u624b\u5de5\u6dfb\u52a0").toString();
        }
        rows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
        sqllist = new ArrayList<String>();
        if (rows.isEmpty()) {
            insertCol = new SQLFactory(this, "\u5b57\u6bb5\u65b0\u589e");
            insertCol.addParameter("table_name", table_name);
            insertCol.addParameter("column_name", column_name);
            insertCol.addParameter("column_default", column_default);
            insertCol.addParameter("column_type", column_type);
            if (column_type.equals("text")) {
                insertCol.addParameter("numeric_precision", "null");
                insertCol.addParameter("numeric_scale", 0);
            } else {
                insertCol.addParameter("numeric_precision", numeric_precision);
                insertCol.addParameter("numeric_scale", numeric_scale);
            }
            insertCol.addParameter("column_comment", column_comment);
            insertCol.addParameter("column_title", column_title);
            insertCol.addParameter("is_nullable", is_nullable);
            insertCol.addParameter("savedatalog", savedatalog);
            insertCol.addParameter("uniqued", uniqued);
            insertCol.addParameter("sequence", 3);
            sqllist.add(insertCol.getSQL());
        } else {
            oldstatus = rows.get(0).getString("status");
            if (oldstatus.equals("D")) {
                return this.getErrReturnObject().setErrMsg("\u5220\u9664\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01").toString();
            }
            modifyCol = new SQLFactory(this, "\u5b57\u6bb5\u4fee\u6539");
            modifyCol.addParameter("table_name", table_name);
            modifyCol.addParameter("column_name", column_name);
            modifyCol.addParameter("column_title", column_title);
            modifyCol.addParameter("column_default", column_default);
            modifyCol.addParameter("column_type", column_type);
            if (column_type.equals("text")) {
                modifyCol.addParameter("numeric_precision", "null");
                modifyCol.addParameter("numeric_scale", 0);
            } else {
                modifyCol.addParameter("numeric_precision", numeric_precision);
                modifyCol.addParameter("numeric_scale", numeric_scale);
            }
            modifyCol.addParameter("numeric_precision", numeric_precision);
            modifyCol.addParameter("numeric_scale", numeric_scale);
            modifyCol.addParameter("column_comment", column_comment);
            modifyCol.addParameter("is_nullable", is_nullable);
            modifyCol.addParameter("savedatalog", savedatalog);
            modifyCol.addParameter("uniqued", uniqued);
            sqllist.add(modifyCol.getSQL());
        }
        sqllist.add("update sys_object set status='C' where table_name='" + table_name + "' and ifnull(status,'')=''");
        this.dbConnect.runSqlUpdate(sqllist);
        this.cleanTableColumnTitle(table_name, column_name);
        this.cleanTableColumnNamesMaps(table_name);
        this.cleanSpecialColumnsWidthDefaultValue(table_name);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5220\u9664\u5b57\u6bb5", apiversion=R.ID10000601.v1.class)
    public String delete_objectcol() throws YosException {
        String table_name = this.content.getString("table_name").toLowerCase();
        String column_name = this.content.getString("column_name").toLowerCase();
        boolean isdelete = this.content.getBooleanValue("isdelete");
        Rows sys_objectRows = this.dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'");
        if (sys_objectRows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg(table_name + "\u8868\u4e0d\u5b58\u5728\uff01").toString();
        }
        if (sys_objectRows.get(0).getBoolean("issystem")) {
            return this.getErrReturnObject().setErrMsg("\u7cfb\u7edf\u8868\u4e0d\u53ef\u4fee\u6539\uff01").toString();
        }
        if (sys_objectRows.get(0).getString("uniquecolumnname").equals(column_name)) {
            return this.getErrReturnObject().setErrMsg("\u8868ID\u5b57\u6bb5\u4e0d\u53ef\u5220\u9664").toString();
        }
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
        String oldstatus = rows.get(0).getString("status");
        if (oldstatus.equals("C")) {
            return this.getErrReturnObject().setErrMsg("\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01").toString();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (isdelete) {
            if ("A".equals(oldstatus)) {
                list.add("delete from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'");
            } else {
                list.add("update sys_objectcols set status='D' where table_name='" + table_name + "' and column_name='" + column_name + "'");
                list.add("update sys_object set status='C' where table_name='" + table_name + "'");
            }
        } else if ("D".equals(oldstatus)) {
            list.add("update sys_objectcols set status=null where table_name='" + table_name + "' and column_name='" + column_name + "'");
            list.add("update sys_object set status=null where table_name='" + table_name + "'and status='C' and not exists(select * from sys_objectcols where table_name='" + table_name + "' and column_name!='" + column_name + "' and status in ('A','D','C'))");
        }
        this.dbConnect.runSqlUpdate(list);
        this.cleanSpecialColumnsWidthDefaultValue(table_name);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u5feb\u901f\u6dfb\u52a0\u5b57\u6bb5\u67e5\u8be2", apiversion=R.ID10000701.v1.class)
    public String queryObjectColListForAdd() throws YosException {
        JSONObject whereObject;
        String table_name = this.content.getString("table_name");
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where") && (whereObject = this.content.getJSONObject("where")).containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
            where.append(" and(");
            where.append(" t1.column_name like'%").append(whereObject.getString("condition")).append("%' ");
            where.append("or t1.column_comment like'%").append(whereObject.getString("condition")).append("%' ");
            where.append("or t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
            where.append("or t2.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
            where.append(")");
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_objectcols", new String[0]).setTableAlias("t1");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_object", "t2", "t1.table_name=t2.table_name");
        querySQL.addQueryFields("t1.table_name,t2.table_comment, t1.column_name, t1.column_title, t1.column_comment, t1.column_default, t1.numeric_precision,t1.numeric_scale,t1.column_type,t1.is_nullable");
        querySQL.setWhere("not exists(select * from sys_objectcols t3 where t1.column_name=t3.column_name and t3.table_name='" + table_name + "')");
        querySQL.setWhere(where.toString());
        querySQL.setPage(this.pageSize, this.pageNumber);
        Rows tableRows = querySQL.query();
        return this.getSucReturnObject().setData(tableRows).toString();
    }

    @API(title="\u6570\u636e\u5e93\u5e94\u7528\u914d\u7f6e\u66f4\u6539", apiversion=R.ID10002001.v1.class)
    public String applydbchanges() throws YosException {
        String table_name = this.content.getString("table_name").toLowerCase();
        Rows tablerows = this.dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'");
        if (tablerows.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u8868").toString();
        }
        Rows tablecolrows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and status is not null ");
        Row tableRow = tablerows.get(0);
        String uniquecolumnname = tableRow.getString("uniquecolumnname");
        ArrayList<String> sqllist = new ArrayList<String>();
        String tablestatus = tableRow.getString("status");
        String table_comment = tableRow.getString("table_comment");
        switch (tablestatus) {
            case "C": {
                String column_default;
                String type;
                String column_comment;
                boolean is_nullable;
                int numeric_scale;
                int numeric_precision;
                String column_type;
                String column_name;
                sqllist.add("alter table " + table_name + " comment '" + table_comment + "';");
                for (Object tablecolrow : tablecolrows) {
                    String colstatus = ((Row)tablecolrow).getString("status");
                    column_name = ((Row)tablecolrow).getString("column_name");
                    column_type = ((Row)tablecolrow).getString("column_type");
                    numeric_precision = ((Row)tablecolrow).getInteger("numeric_precision");
                    numeric_scale = ((Row)tablecolrow).getInteger("numeric_scale");
                    is_nullable = ((Row)tablecolrow).getBoolean("is_nullable");
                    column_comment = ((Row)tablecolrow).getString("column_comment");
                    type = this.getColumn_type(column_type, numeric_precision, numeric_scale);
                    column_default = ((Row)tablecolrow).getString("column_default");
                    column_default = type.equals("json") ? "" : column_default;
                    switch (type) {
                        case "text": 
                        case "longtext": 
                        case "json": {
                            column_default = "";
                            break;
                        }
                        case "bit": {
                            column_default = column_default.equalsIgnoreCase("true") || column_default.equals("1") ? "1" : "0";
                            is_nullable = false;
                        }
                    }
                    boolean isallreadycolhave = !this.dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'").isEmpty();
                    switch (colstatus) {
                        case "C": 
                        case "A": {
                            if (isallreadycolhave) {
                                if (table_name.equalsIgnoreCase("sys_datalog") && column_name.equalsIgnoreCase("datalogid")) {
                                    sqllist.add("alter table " + table_name + " modify " + column_name + " bigint auto_increment comment '" + column_comment + "';");
                                    break;
                                }
                                sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                                break;
                            }
                            if (table_name.equalsIgnoreCase("sys_datalog") && column_name.equalsIgnoreCase("datalogid")) {
                                sqllist.add("alter table " + table_name + " add " + column_name + " bigint auto_increment comment '" + column_comment + "';");
                                break;
                            }
                            sqllist.add("alter table " + table_name + " add " + column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                            break;
                        }
                        case "D": {
                            if (isallreadycolhave) {
                                sqllist.add("alter table " + table_name + " drop column " + column_name + ";");
                            }
                            sqllist.add("delete from sys_objectcols where table_name='" + table_name + "' and  column_name='" + column_name + "';");
                            break;
                        }
                    }
                }
                break;
            }
            case "A": {
                String column_default;
                String type;
                String column_comment;
                boolean is_nullable;
                int numeric_scale;
                int numeric_precision;
                String column_type;
                String column_name;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("create table ").append(table_name);
                stringBuffer.append("(");
                for (Row tablecolrow : tablecolrows) {
                    column_name = tablecolrow.getString("column_name");
                    column_type = tablecolrow.getString("column_type");
                    numeric_precision = tablecolrow.getInteger("numeric_precision");
                    numeric_scale = tablecolrow.getInteger("numeric_scale");
                    is_nullable = tablecolrow.getBoolean("is_nullable");
                    column_comment = tablecolrow.getString("column_comment");
                    type = this.getColumn_type(column_type, numeric_precision, numeric_scale);
                    column_default = tablecolrow.getString("column_default");
                    column_default = type.equals("json") ? "" : column_default;
                    switch (type) {
                        case "text": 
                        case "longtext": 
                        case "json": {
                            column_default = "";
                            break;
                        }
                        case "bit": {
                            column_default = column_default.equalsIgnoreCase("true") || column_default.equals("1") ? "1" : "0";
                            is_nullable = false;
                        }
                    }
                    stringBuffer.append(column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "',");
                }
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
                stringBuffer.append(")");
                stringBuffer.append("comment '" + table_comment + "';");
                sqllist.add(stringBuffer.toString());
                break;
            }
            case "D": {
                boolean isallreadytablehave;
                boolean bl = isallreadytablehave = !this.dbConnect.runSqlQuery("SELECT TABLE_NAME,TABLE_COMMENT,TABLE_ROWS  FROM information_schema.`TABLES` where TABLE_SCHEMA='" + this.dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "'").isEmpty();
                if (isallreadytablehave) {
                    sqllist.add("drop table " + table_name + ";");
                }
                sqllist.add("delete from sys_object where table_name='" + table_name + "';");
                sqllist.add("delete from sys_objectcols where table_name='" + table_name + "';");
                break;
            }
        }
        if (sqllist.isEmpty()) {
            return this.getErrReturnObject().setErrMsg("\u65e0\u53ef\u6267\u884c\u7684\u6570\u636e\u5e93\u66f4\u6539").toString();
        }
        sqllist.add("update sys_object set status=null,changedate=now() where table_name='" + table_name + "'");
        sqllist.add("update sys_objectcols set status=null where table_name='" + table_name + "'");
        this.loguserout();
        LinkedList<DBConnectPool.YosConnection> list = DBConnectPool.POOLS_MAP.get("default");
        for (DBConnectPool.YosConnection connection : list) {
            try {
                connection.getConnection().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbConnect.runSqlUpdate(sqllist);
        this.createDataLogTrigger(table_name);
        this.createDataVersionTrigger(table_name);
        if (!tablestatus.equals("D")) {
            this.content.put("issimple", (Object)true);
            this.create_Index();
        }
        this.cleanTableColumnNamesMaps(table_name);
        return this.getSucReturnObject().toString();
    }

    private void createDataLogTrigger(String table_name) throws YosException {
        String[] trigger_names;
        ArrayList<String> sqllist = new ArrayList<String>();
        for (String trigger_name : trigger_names = new String[]{"insert_savedatalog_" + table_name, "update_savedatalog_" + table_name, "delete_savedatalog_" + table_name}) {
            if (!this.dbConnect.runSqlQuery("select * from information_schema.TRIGGERS where TRIGGER_SCHEMA='" + this.dbConnect.getDBName() + "' and TRIGGER_NAME='" + trigger_name + "'").isNotEmpty()) continue;
            sqllist.add("DROP TRIGGER " + trigger_name + ";");
        }
        boolean iscreatetrigger = true;
        Rows savedatalogColumns = this.dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and savedatalog=1");
        iscreatetrigger = !savedatalogColumns.isEmpty() && iscreatetrigger;
        Rows havechangeuserid = this.dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + table_name + "' and column_name='changeuserid'");
        boolean bl = iscreatetrigger = !havechangeuserid.isEmpty() && iscreatetrigger;
        if (iscreatetrigger) {
            String uniquecolumnname = this.getuniquecolumnname(table_name);
            for (String trigger_name : trigger_names) {
                StringBuffer stringBuffer;
                Object column_name;
                if (trigger_name.startsWith("insert")) {
                    StringBuffer newdatastr = new StringBuffer();
                    for (Row savedatalogColumnRow : savedatalogColumns) {
                        column_name = savedatalogColumnRow.getString("column_name");
                        newdatastr.append("CONCAT('\"" + (String)column_name + "\":\"',ifnull(new." + (String)column_name + ",''),'\",'),");
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" after insert on ").append(table_name).append(" FOR EACH ROW begin ");
                    stringBuffer.append(" insert into sys_datalog( type,table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                    stringBuffer.append(" select 'insert', '").append(table_name).append("',new.").append(uniquecolumnname).append(",").append(" '{}',").append(" CONCAT('{',CONCAT(" + newdatastr.substring(0, newdatastr.length() - 1) + "),CONCAT('\"dataid\":\"',new." + uniquecolumnname + ",'\"'),'}'),").append("new.changeuserid,now(),sys_users.name from sys_users ");
                    stringBuffer.append(" where sys_users.userid=new.changeuserid");
                    stringBuffer.append("; end; ");
                    sqllist.add(stringBuffer.toString());
                    continue;
                }
                if (trigger_name.startsWith("update")) {
                    StringBuffer wherestr = new StringBuffer();
                    StringBuffer olddatastr = new StringBuffer();
                    StringBuffer newdatastr = new StringBuffer();
                    for (Row savedatalogColumnRow : savedatalogColumns) {
                        String column_name2 = savedatalogColumnRow.getString("column_name");
                        if (wherestr.toString().equals("")) {
                            wherestr.append("ifnull(new." + column_name2 + ",'')!=ifnull(old." + column_name2 + ",'')");
                        } else {
                            wherestr.append(" OR ifnull(new." + column_name2 + ",'')!=ifnull(old." + column_name2 + ",'')");
                        }
                        olddatastr.append("case when ifnull(old." + column_name2 + ",'')!=ifnull(new." + column_name2 + ",'') then CONCAT('\"" + column_name2 + "\":\"',ifnull(old." + column_name2 + ",''),'\",') else '' end,");
                        newdatastr.append("case when ifnull(old." + column_name2 + ",'')!=ifnull(new." + column_name2 + ",'') then CONCAT('\"" + column_name2 + "\":\"',ifnull(new." + column_name2 + ",''),'\",') else '' end,");
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(" create TRIGGER ").append(trigger_name).append(" after update on ").append(table_name).append(" FOR EACH ROW begin ");
                    stringBuffer2.append(" insert into sys_datalog( type,table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                    stringBuffer2.append(" select 'update','").append(table_name).append("',new.").append(uniquecolumnname).append(",").append(" CONCAT('{',CONCAT(" + olddatastr.substring(0, olddatastr.length() - 1) + "),CONCAT('\"dataid\":\"',old." + uniquecolumnname + ",'\"'),'}'),").append(" CONCAT('{',CONCAT(" + newdatastr.substring(0, newdatastr.length() - 1) + "),CONCAT('\"dataid\":\"',new." + uniquecolumnname + ",'\"'),'}'),").append("new.changeuserid,now(),sys_users.name from sys_users ");
                    stringBuffer2.append(" where sys_users.userid=new.changeuserid and(" + wherestr + ")");
                    stringBuffer2.append("; end; ");
                    sqllist.add(stringBuffer2.toString());
                    continue;
                }
                if (!trigger_name.startsWith("delete")) continue;
                StringBuffer olddatastr = new StringBuffer();
                for (Row savedatalogColumnRow : savedatalogColumns) {
                    column_name = savedatalogColumnRow.getString("column_name");
                    olddatastr.append("CONCAT('\"" + (String)column_name + "\":\"',ifnull(old." + (String)column_name + ",''),'\",'),");
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" after delete on ").append(table_name).append(" FOR EACH ROW begin ");
                stringBuffer.append(" insert into sys_datalog(type, table_name, dataid, olddata, newdata, changeuserid, changedate, changeby)");
                stringBuffer.append(" select 'delete','").append(table_name).append("',old.").append(uniquecolumnname).append(",").append(" CONCAT('{',CONCAT(" + olddatastr.substring(0, olddatastr.length() - 1) + "),CONCAT('\"dataid\":\"',old." + uniquecolumnname + ",'\"'),'}'),").append(" '{}',").append("old.changeuserid,now(),sys_users.name from sys_users ");
                stringBuffer.append(" where sys_users.userid=old.changeuserid");
                stringBuffer.append("; end; ");
                sqllist.add(stringBuffer.toString());
            }
            this.dbConnect.runSqlUpdate(sqllist);
        }
    }

    private void createDataVersionTrigger(String table_name) throws YosException {
        String trigger_name = "update_" + table_name + "_dvc";
        String dataversioncolumnname = this.getdataversioncolumnname(table_name);
        ArrayList<String> sqllist = new ArrayList<String>();
        boolean isallreadyhavetrigger = this.dbConnect.runSqlQuery("select * from information_schema.TRIGGERS where TRIGGER_SCHEMA='" + this.dbConnect.getDBName() + "' and TRIGGER_NAME='" + trigger_name + "'").isNotEmpty();
        boolean isneedtrigger = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name='" + dataversioncolumnname + "'").isNotEmpty();
        if (isneedtrigger && !isallreadyhavetrigger) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" create TRIGGER ").append(trigger_name).append(" before update on ").append(table_name).append(" FOR EACH ROW begin ");
            stringBuffer.append(" IF NEW.").append(dataversioncolumnname).append(" = OLD.").append(dataversioncolumnname).append(" ");
            stringBuffer.append(" THEN SET NEW.").append(dataversioncolumnname).append(" = NEW.").append(dataversioncolumnname).append(" + 1;");
            stringBuffer.append(" ELSE SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = 'DataVersion conflict';");
            stringBuffer.append(" END IF");
            stringBuffer.append("; end; ");
            sqllist.add(stringBuffer.toString());
        } else if (!isneedtrigger && isallreadyhavetrigger) {
            sqllist.add("DROP TRIGGER " + trigger_name + ";");
        }
        if (!sqllist.isEmpty()) {
            this.dbConnect.runSqlUpdate(sqllist);
        }
    }

    private String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equalsIgnoreCase("varchar")) {
            return "varchar(" + numeric_precision + ")";
        }
        if (column_type.equalsIgnoreCase("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        }
        if (column_type.equalsIgnoreCase("integer")) {
            return "int";
        }
        if (column_type.equalsIgnoreCase("boolean")) {
            return "bit";
        }
        return column_type;
    }

    @API(title="\u4ece\u6570\u636e\u5e93\u63d0\u53d6\u6700\u65b0\u6570\u636e\u7ed3\u6784", apiversion=R.ID10016801.v1.class)
    public String refreshDbMsg() throws YosException {
        return this.getErrReturnObject().setErrMsg("\u529f\u80fd\u5df2\u505c\u7528").toString();
    }

    @API(title="\u8868\u89e6\u53d1\u5668\u67e5\u8be2", apiversion=R.ID10000801.v1.class)
    public String query_TriggerList() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "\u8868\u89e6\u53d1\u5668\u67e5\u8be2");
        sqlFactory.addParameter("table_name", this.content.getString("table_name"));
        sqlFactory.addParameter("dbname", this.dbConnect.getDBName());
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory);
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u8868\u7d22\u5f15\u67e5\u8be2", apiversion=R.ID10000901.v1.class)
    public String query_IndexList() throws YosException {
        String table_name = this.content.getString("table_name");
        RowsMap columnmap = this.getTableColumns(table_name);
        SQLFactory indexsql = new SQLFactory(this, "\u8868\u7d22\u5f15\u67e5\u8be2");
        indexsql.addParameter("table_name", this.dbConnect.getDBName() + "/" + table_name);
        Rows indexrows = this.dbConnect.runSqlQuery(indexsql.getSQL());
        for (Row indexrow : indexrows) {
            SQLFactory indexcolsql = new SQLFactory(this, "\u8868\u7d22\u5f15\u5b57\u6bb5\u67e5\u8be2");
            indexcolsql.addParameter("INDEX_ID", indexrow.getString("INDEX_ID"));
            Rows columns = this.dbConnect.runSqlQuery(indexcolsql.getSQL());
            for (Row column : columns) {
                String column_name = column.getString("NAME");
                if (columnmap.containsKey(column_name)) {
                    column.put("column_title", columnmap.get(column_name).get(0).getString("column_title"));
                    continue;
                }
                column.put("column_title", "");
            }
            indexrow.put("columns", columns);
        }
        return this.getSucReturnObject().setData(indexrows).toString();
    }

    @API(title="\u8868\u7d22\u5f15\u5220\u9664", apiversion=R.ID10022601.v1.class)
    public String delete_Index() throws YosException {
        String table_name = this.content.getString("table_name");
        String index_name = this.content.getString("name");
        if (index_name.equalsIgnoreCase("PRIMARY") || index_name.equalsIgnoreCase("GEN_CLUST_INDEX")) {
            return this.getErrReturnObject().setErrMsg("\u8be5\u7d22\u5f15\u4e0d\u53ef\u5220\u9664\uff01").toString();
        }
        this.dbConnect.runSqlUpdate("drop index " + index_name + " on " + table_name + ";");
        return this.getSucReturnObject().toString();
    }

    @API(title="\u8868\u7d22\u5f15\u521b\u5efa", apiversion=R.ID10022701.v1.class)
    public String create_Index() throws YosException {
        String table_name = this.content.getString("table_name");
        boolean issimple = this.content.getBooleanValue("issimple");
        if (issimple) {
            String uniquecolumnname = this.getuniquecolumnname(table_name);
            ArrayList<String> sqlist = new ArrayList<String>();
            if (!uniquecolumnname.equalsIgnoreCase("") && this.dbConnect.runSqlQuery("select *from INFORMATION_SCHEMA.KEY_COLUMN_USAGE where TABLE_NAME='" + table_name + "' and CONSTRAINT_NAME='PRIMARY'").isEmpty()) {
                sqlist.add("alter table " + table_name + " add constraint " + table_name + "_pk primary key (" + uniquecolumnname + ");");
            }
            Rows colrows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "' and column_name!='" + uniquecolumnname + "'");
            for (Row colrow : colrows) {
                String column_name = colrow.getString("column_name");
                boolean uniqued = colrow.getBoolean("uniqued");
                String uindex_name = column_name + "_uindex";
                String index_name = column_name + "_index_foreign";
                String siteid_index_name = "siteid_index";
                Rows uindexrows = this.dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + this.dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + uindex_name + "'; ");
                Rows indexrows = this.dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + this.dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + index_name + "'; ");
                Rows siteidindexrows = this.dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + this.dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + siteid_index_name + "'; ");
                if (uniqued && !indexrows.isEmpty()) {
                    sqlist.add("drop index " + index_name + " on " + table_name + ";");
                }
                if (!uniqued && uindexrows.isNotEmpty()) {
                    sqlist.add("drop index " + uindex_name + " on " + table_name + ";");
                }
                if (!uniqued && sys_object.isTableUniqueColumnName(column_name) && indexrows.isEmpty()) {
                    sqlist.add("create index " + index_name + " on " + table_name + " (" + column_name + ");");
                }
                if (uniqued && uindexrows.isEmpty()) {
                    sqlist.add("create unique index " + uindex_name + " on " + table_name + " (" + column_name + ");");
                }
                if (column_name.equals("siteid") && siteidindexrows.isEmpty()) {
                    sqlist.add("create index " + siteid_index_name + " on " + table_name + " (" + column_name + ");");
                }
                if (!this.getColumnType(table_name, column_name).equals("smallint") && !this.getColumnType(table_name, column_name).equals("boolean")) continue;
                index_name = column_name + "_index";
                Rows rows = this.dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + this.dbConnect.getDBName() + "/" + table_name + "' and t1.name='" + index_name + "'; ");
                if (!rows.isEmpty()) continue;
                sqlist.add("create index " + index_name + " on " + table_name + " (" + column_name + ");");
            }
            if (!sqlist.isEmpty()) {
                this.dbConnect.runSqlUpdate(sqlist);
            }
        } else {
            String index_name = this.content.getString("name");
            SQLFactory indexsql = new SQLFactory(this, "\u8868\u7d22\u5f15\u67e5\u8be2");
            indexsql.addParameter("table_name", this.dbConnect.getDBName() + "/" + table_name);
            RowsMap rowsMap = this.dbConnect.runSqlQuery(indexsql.getSQL()).toRowsMap("name");
            if (rowsMap.containsKey(index_name)) {
                return this.getErrReturnObject().setErrMsg("\u7d22\u5f15\u5df2\u5b58\u5728\uff01").toString();
            }
            JSONArray columns = this.content.getJSONArray("columns");
            StringBuilder c = new StringBuilder();
            for (Object o : columns) {
                if (c.toString().equals("")) {
                    c.append((String)o);
                    continue;
                }
                c.append(",").append((String)o);
            }
            if (c.toString().equals("")) {
                return this.getErrReturnObject().setErrMsg("\u8bf7\u6307\u5b9a\u7d22\u5f15\u5b57\u6bb5").toString();
            }
            this.dbConnect.runSqlUpdate("create index " + index_name + " on " + table_name + " (" + c + ");");
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u8868\u7d22\u5f15\u521b\u5efa_\u5168\u90e8", apiversion=R.ID10024501.v1.class)
    public String create_AllIndex() throws YosException {
        this.content.put("issimple", (Object)1);
        Rows objectrows = this.dbConnect.runSqlQuery("select table_name from sys_object where ifnull(status,'')=''");
        for (Row objectrow : objectrows) {
            String table_name = objectrow.getString("table_name");
            this.content.put("table_name", (Object)table_name);
            this.create_Index();
        }
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u8868\u5e94\u7528\u67e5\u8be2", apiversion=R.ID10001201.v1.class)
    public String queryObjectApps() throws YosException {
        String table_name = this.content.getString("table_name");
        SQLFactory sqlFactory = new SQLFactory(this, "\u6570\u636e\u8868\u5173\u8054\u5e94\u7528\u67e5\u8be2");
        sqlFactory.addParameter("table_name", table_name);
        Rows rows = this.dbConnect.runSqlQuery(sqlFactory.getSQL());
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u6570\u636e\u8868\u5e94\u7528\u9009\u62e9", apiversion=R.ID10001301.v1.class)
    public String selectObjectApps() throws YosException {
        JSONObject whereObject;
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (this.content.containsKey("where") && (whereObject = this.content.getJSONObject("where")).containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
            where.append(" and(");
            where.append("t1.systemapp like'%").append(whereObject.getString("condition")).append("%' ");
            where.append("or t1.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
            where.append(")");
        }
        String table_name = this.content.getString("table_name");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp", "systemappid", "systemapp", "systemappname", "remarks").setTableAlias("t1");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_systemmodule", "t2", "t1.systemmoduleid = t2.systemmoduleid", "systemmodulename");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_systemclient", "t3", "t2.systemclientid = t3.systemclientid", "systemclientname");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_system", "t4", "t3.systemid = t4.systemid", "systemname");
        ((QuerySQL)querySQL.setWhere(where.toString())).setWhere("not exists(select * from sys_objectapps t2 where t2.table_name = '" + table_name + "' and t1.systemappid = t2.systemappid)");
        querySQL.setPage(this.pageSize, this.pageNumber);
        Rows rows = querySQL.query();
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="\u6570\u636e\u8868\u5e94\u7528\u6dfb\u52a0", apiversion=R.ID10001401.v1.class)
    public String addObjectApps() throws YosException {
        String table_name = this.content.getString("table_name");
        long systemappid = this.content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "\u6570\u636e\u8868\u5173\u8054\u5e94\u7528\u6dfb\u52a0");
        sqlFactory.addParameter("sys_objectappsid", this.createTableID("sys_objectapps"));
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter("table_name", table_name);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u8868\u5e94\u7528\u5220\u9664", apiversion=R.ID10001501.v1.class)
    public String deleteObjectApps() throws YosException {
        String sys_objectappsid = this.content.getString("sys_objectappsid");
        this.dbConnect.runSqlUpdate("delete from sys_objectapps where sys_objectappsid=" + sys_objectappsid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6570\u636e\u8868\u6570\u636e\u67e5\u8be2", apiversion=R.ID10001601.v1.class)
    public String dataquery() throws YosException {
        String sql = this.content.getStringValue("sql", true);
        String datakey = this.content.getStringValue("datakey", "default");
        if ((sql = sql.replace("\\'", "'")).equals("")) {
            return this.getErrReturnObject().setErrMsg("\u8bf7\u8f93\u5165\u6709\u6548\u7684sql\u8bed\u53e5").toString();
        }
        Rows rows = null;
        long starttime = Calendar.getInstance().getTimeInMillis();
        try {
            rows = datakey.equalsIgnoreCase("sqliteCache") ? SQLiteMemory.runSqlQueryWithFieldMeta(sql) : new DBConnect(datakey).runSqlQuery(sql);
        }
        catch (YosException e) {
            return this.getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        long endtime = Calendar.getInstance().getTimeInMillis();
        JSONObject object = new JSONObject();
        object.put("rows", (Object)rows);
        object.put("columns", (Object)rows.getFieldList());
        JSONObject metaObject = (JSONObject)JSON.toJSON(rows.getFieldMetaMap());
        for (String fieldname : rows.getFieldMetaMap().keySet()) {
            String tablename = rows.getFieldMeta(fieldname).getTable_name();
            metaObject.getJSONObject(fieldname).put("column_title", (Object)this.getTableColumnTitle(tablename, rows.getFieldMeta(fieldname).getColumn_name()));
            metaObject.getJSONObject(fieldname).put("fieldtype", (Object)rows.getFieldMeta(fieldname).getFieldtype().getSimpleName());
        }
        object.put("columnsmeta", (Object)metaObject);
        object.put("runtime", (Object)((double)(endtime - starttime) / 1000.0));
        return this.getSucReturnObject().setData(object).toString();
    }

    @API(title="SQL\u8bed\u53e5\u6267\u884c\u8fc7\u7a0b\u89e3\u91ca", apiversion=R.ID10022801.v1.class)
    public String SQLExplain() throws YosException {
        String sql = this.content.getString("sql", true).toLowerCase();
        sql = sql.replace("\\'", "'");
        Rows rows = new DBConnect().runSqlQuery("explain " + sql);
        return this.getSucReturnObject().setData(rows).toString();
    }

    @API(title="sql\u6a21\u7248\u67e5\u8be2", apiversion=R.ID10001701.v1.class)
    public String queryTempletSQL() throws YosException {
        long sys_dataquery_sqltempletid = this.content.getLong("sys_dataquery_sqltempletid");
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_dataquery_sqltemplet where sys_dataquery_sqltempletid=" + sys_dataquery_sqltempletid);
        if (rows.isNotEmpty()) {
            return this.getSucReturnObject().setData(rows.get(0)).toString();
        }
        return this.getErrReturnObject().setErrMsg("\u627e\u4e0d\u5230\u6709\u6548\u7684SQL\u6a21\u677f").toString();
    }

    @API(title="sql\u6a21\u7248\u65b0\u589e", apiversion=R.ID10001801.v1.class)
    public String insertTempletSQL() throws YosException {
        String templetname = this.content.getString("templetname");
        String datakey = this.content.getString("datakey");
        String sqlstr = this.content.getString("sqlstr", true);
        SQLFactory sqlFactory = new SQLFactory("sql:insert into sys_dataquery_sqltemplet(sys_dataquery_sqltempletid,templetname,datakey,sqlstr) select $sys_dataquery_sqltempletid$,$templetname$,$datakey$,$sqlstr$");
        sqlFactory.addParameter("sys_dataquery_sqltempletid", this.createTableID("sys_dataquery_sqltemplet"));
        sqlFactory.addParameter("templetname", templetname);
        sqlFactory.addParameter("datakey", datakey);
        sqlFactory.addParameter("sqlstr", sqlstr);
        this.dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return this.getSucReturnObject().toString();
    }

    @API(title="sql\u6a21\u7248\u5220\u9664", apiversion=R.ID10001901.v1.class)
    public String deleteTempletSQL() throws YosException {
        long sys_dataquery_sqltempletid = this.content.getLong("sys_dataquery_sqltempletid");
        this.dbConnect.runSqlUpdate("delete from sys_dataquery_sqltemplet where sys_dataquery_sqltempletid=" + sys_dataquery_sqltempletid);
        return this.getSucReturnObject().toString();
    }

    @API(title="\u6839\u636edatakey\u67e5\u8be2\u6570\u636e\u5e93\u8868\u7ed3\u6784", apiversion=R.ID10003201.v1.class)
    @CACHEING(life=5)
    public String queryTableFieldsByDataKey() throws YosException {
        String datakey = this.content.getString("datakey");
        JSONObject object = new JSONObject();
        block4 : switch (datakey) {
            case "default": {
                RowsMap tableRowsMap = this.dbConnect.runSqlQuery("select table_name,column_name from sys_objectcols").toRowsMap("table_name");
                for (String table_name : tableRowsMap.keySet()) {
                    object.put(table_name, (Object)tableRowsMap.get(table_name).toArray("column_name"));
                }
                break;
            }
            case "sqliteCache": {
                RowsMap tableRowsMap = this.dbConnect.runSqlQuery("select table_name,column_name from sys_cacheobjectcols").toRowsMap("table_name");
                for (String table_name : tableRowsMap.keySet()) {
                    object.put(table_name, (Object)tableRowsMap.get(table_name).toArray("column_name"));
                }
                break;
            }
            default: {
                DBConnect dbConnect = new DBConnect(datakey);
                switch (dbConnect.getDBProduct()) {
                    case "MySQL": {
                        RowsMap tableRowsMap = dbConnect.runSqlQuery("SELECT TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "'").toRowsMap("TABLE_NAME");
                        for (String table_name : tableRowsMap.keySet()) {
                            object.put(table_name, (Object)tableRowsMap.get(table_name).toArray("COLUMN_NAME"));
                        }
                        break block4;
                    }
                    case "SQL Server": {
                        RowsMap tableRowsMap = dbConnect.runSqlQuery("select TABLE_NAME,COLUMN_NAME from information_schema.columns").toRowsMap("TABLE_NAME");
                        for (String table_name : tableRowsMap.keySet()) {
                            object.put(table_name, (Object)tableRowsMap.get(table_name).toArray("COLUMN_NAME"));
                        }
                        break block4;
                    }
                    case "Oracle": {
                        break block4;
                    }
                }
            }
        }
        return this.getSucReturnObject().setData(object).toString();
    }
}

