/*
 * Decompiled with CFR 0.152.
 */
package common.mq;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.YosLogger;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.InfluxDBConnect;
import common.mq.ClientMQTT;
import common.mq.EventValidate;
import common.mq.MQDatas;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MQMessage
implements MqttCallback,
YosLogger {
    long sys_mqid;
    private static HashMap<String, Integer> topicsdaymap = new HashMap();
    private static LinkedHashMap<Long, ArrayList<String>> devicemsgstatus = new LinkedHashMap();

    public MQMessage(long sys_mqid) {
        this.sys_mqid = sys_mqid;
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        BaseClass baseClass = new BaseClass();
        if (Parameter.get("system_topic_log").equalsIgnoreCase("true")) {
            long topics_log_savecount;
            InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_device_topics_log");
            rowInsert.setValue("w_device_topics_logid", baseClass.createTableID("w_device_topics_log"));
            rowInsert.setValue("topic", topic);
            rowInsert.setValue("content", new String(mqttMessage.getPayload(), StandardCharsets.UTF_8));
            rowInsert.setDateValue("createdate");
            rowInsert.insert();
            try {
                topics_log_savecount = Long.parseLong(Parameter.get("topics_log_savecount"));
            }
            catch (Exception e) {
                e.printStackTrace();
                topics_log_savecount = 10L;
            }
            baseClass.dbConnect.runSqlUpdate("delete t1 from w_device_topics_log t1 \nleft join (select w_device_topics_logid from w_device_topics_log where topic='" + topic + "' order by w_device_topics_logid desc limit " + topics_log_savecount + ") t2 on t1.w_device_topics_logid=t2.w_device_topics_logid\nwhere t1.topic='" + topic + "' and t2.w_device_topics_logid is null");
        }
        int day = Calendar.getInstance().get(5);
        if (!topicsdaymap.containsKey(topic) || topicsdaymap.get(topic) != day) {
            InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_topics_statistics");
            rowInsert.setValue("w_topics_statisticsid", baseClass.createTableID("w_topics_statistics"));
            rowInsert.setValue("times", 0);
            rowInsert.setValue("topic", topic);
            rowInsert.setDateValue("`date`");
            rowInsert.setDateValue("lasttime");
            rowInsert.setWhere("not exists(select *from w_topics_statistics where topic='" + topic + "' and `date`='" + baseClass.getDate_Str() + "')");
            rowInsert.insert();
            topicsdaymap.put(topic, day);
        }
        baseClass.dbConnect.runSqlUpdate("update w_topics_statistics set times=times+1,lasttime=now() where topic='" + topic + "' and `date`='" + baseClass.getDate_Str() + "'");
        if (topic.endsWith("data")) {
            try {
                Rows w_deviceRows = baseClass.dbConnect.runSqlQuery("select t1.siteid,t1.w_deviceid,t2.w_productid,t2.isfeedback,t3.issystem,t3.jarpath from w_device_topics t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid inner join sys_msgprotocol t3 on t2.sys_msgprotocolid=t3.sys_msgprotocolid and t3.protocoltype='mqtt' where t2.isused=1 and t1.topic='" + topic + "'");
                for (Row w_deviceRow : w_deviceRows) {
                    MQDatas mqDatas;
                    String siteid = w_deviceRow.getString("siteid");
                    long w_deviceid = w_deviceRow.getLong("w_deviceid");
                    long w_productid = w_deviceRow.getLong("w_productid");
                    boolean isfeedback = w_deviceRow.getBoolean("isfeedback");
                    boolean issystem = w_deviceRow.getBoolean("issystem");
                    if (issystem) {
                        mqDatas = new MQDatas();
                        String message2 = new String(mqttMessage.getPayload(), StandardCharsets.UTF_8);
                        JSONObject dataObject = JSONObject.parseObject((String)message2);
                        MQDatas.MQData mqData = mqDatas.createMQData(dataObject.getLong("ts"));
                        JSONObject data = dataObject.getJSONObject("d");
                        for (String key : data.keySet()) {
                            mqData.put(key, data.get(key));
                        }
                        if (isfeedback && dataObject.containsKey("msgid")) {
                            baseClass.dbConnect.runSqlUpdate("update w_function_queue set isreceive=1,receivetime='" + dataObject.getStringValue("ts") + "' where msgid='" + dataObject.getString("msgid") + "' and isreceive=0");
                        }
                    } else {
                        String jarpath = w_deviceRow.getString("jarpath");
                        jarpath = System.getProperty("os.name").contains("Windows") ? "file:/" + jarpath : "file://" + jarpath;
                        Class<?> MsgProtocol = Class.forName("MsgProtocol", true, new URLClassLoader(new URL[]{new URL(jarpath)}, this.getClass().getClassLoader()));
                        Object instance = MsgProtocol.newInstance();
                        Method method = MsgProtocol.getDeclaredMethod("receive", String.class, byte[].class, MQDatas.class);
                        mqDatas = (MQDatas)method.invoke(instance, topic, mqttMessage.getPayload(), new MQDatas());
                    }
                    if (mqDatas.size() <= 0) continue;
                    this.messageSave(siteid, w_productid, w_deviceid, mqDatas);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (topic.endsWith("rec")) {
            String recmsg = new String(mqttMessage.getPayload(), StandardCharsets.UTF_8);
            try {
                JSONObject object = JSONObject.parseObject((String)recmsg);
                if (object.containsKey("msgid")) {
                    baseClass.dbConnect.runSqlUpdate("update w_function_queue set isreceive=1,receivetime='" + object.getStringValue("ts") + "' where msgid='" + object.getString("msgid") + "' and isreceive=0");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void messageSave(String siteid, long w_productid, long w_deviceid, MQDatas mqDatas) throws YosException {
        BaseClass baseClass = new BaseClass();
        RowsMap w_dataparamList_save = baseClass.dbConnect.runSqlQuery("select param,datatype from w_dataparam where siteid='" + siteid + "' and ownertable='w_device' and ownerid=" + w_deviceid + " and rwtype=2").toRowsMap("param");
        RowsMap w_dataparamList_read = baseClass.dbConnect.runSqlQuery("select param,datatype from w_dataparam where siteid='" + siteid + "' and ownertable='w_device' and ownerid=" + w_deviceid).toRowsMap("param");
        for (MQDatas.MQData mqData : mqDatas) {
            ArrayList<String> sqlist = new ArrayList<String>();
            Row dataRow = new Row();
            HashMap<String, String> column_type = new HashMap<String, String>();
            for (String key : mqData.keySet()) {
                String datatype;
                Object value = mqData.get(key);
                if (w_dataparamList_save.containsKey(key)) {
                    datatype = w_dataparamList_save.get(key).get(0).getString("datatype");
                    dataRow.put(key, value);
                    column_type.put(key, datatype);
                }
                if (!w_dataparamList_read.containsKey(key)) continue;
                datatype = w_dataparamList_read.get(key).get(0).getString("datatype");
                if (datatype.equals("boolean") && value != null) {
                    if (value instanceof Number) {
                        value = ((Number)value).intValue();
                    } else if (value instanceof Boolean) {
                        value = (Boolean)value != false ? 1 : 0;
                    } else if (value instanceof String) {
                        value = "true".equalsIgnoreCase(value.toString()) ? 1 : 0;
                    }
                } else if (datatype.equals("int") && value != null) {
                    if (value instanceof Number) {
                        value = ((Number)value).intValue();
                    } else if (value instanceof String) {
                        value = ((Number)Float.valueOf(Float.parseFloat((String)value))).intValue();
                    }
                } else if (datatype.equals("long") && value != null) {
                    if (value instanceof Number) {
                        value = ((Number)value).longValue();
                    } else if (value instanceof String) {
                        value = ((Number)Float.valueOf(Float.parseFloat((String)value))).longValue();
                    }
                }
                sqlist.add("update w_dataparam set lastvalue='" + value + "',lastvaluetime='" + mqData.getTs() + "' where ownertable='w_device' and ownerid=" + w_deviceid + " and param='" + key + "'");
            }
            EventValidate.put(w_productid, w_deviceid, mqData);
            baseClass.dbConnect.runSqlUpdate(sqlist);
            InfluxDBConnect.runSqlUpdate(siteid, w_productid, w_deviceid, dataRow, column_type, mqData.getTs());
            MQMessage.deviceMsgStatusInit(w_deviceid);
        }
    }

    public static void deviceMsgStatusInit(long w_deviceid) {
        devicemsgstatus.put(w_deviceid, new ArrayList());
    }

    public static void deviceMsgStatusInit(String serialnumber) throws YosException {
        Rows row = new DBConnect().runSqlQuery("select w_deviceid from w_device where serialnumber='" + serialnumber + "'");
        if (row.isNotEmpty()) {
            devicemsgstatus.put(row.get(0).getLong("w_deviceid"), new ArrayList());
        }
    }

    public static boolean deviceMSGStatusCheck(long w_deviceid, String token) {
        if (devicemsgstatus.containsKey(w_deviceid)) {
            if (devicemsgstatus.get(w_deviceid).contains(token)) {
                return false;
            }
            devicemsgstatus.get(w_deviceid).add(token);
            return true;
        }
        return false;
    }

    public void connectionLost(Throwable throwable) {
        try {
            logger.error((Object)(this.sys_mqid + "\u8fde\u63a5\u5df2\u65ad\uff0c\u5c1d\u8bd5\u91cd\u8fde\uff01\uff01\uff01" + throwable.getMessage()));
            ClientMQTT.MQinit();
        }
        catch (Exception e) {
            logger.error((Object)(this.sys_mqid + "\u91cd\u8fde\u5931\u8d25\uff0c" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        System.out.println("This is deliveryComplete method----->" + iMqttDeliveryToken.isComplete());
    }
}

