/*
 * Decompiled with CFR 0.152.
 */
package common;

import beans.attachment.Attachment;
import beans.department.Department;
import beans.parameter.Parameter;
import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.ReturnObject;
import common.ReturnObject_Code;
import common.ReturnObject_Err;
import common.ReturnObject_Suc;
import common.ReturnObject_Warn;
import common.Sorting;
import common.YosException;
import common.api.YOSAPI;
import common.data.CSVFactory;
import common.data.EasyExcelFactory;
import common.data.ExcelFactory;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DataPool;
import common.parameter.parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import restcontroller.ClientUserInfo;
import utility.huawei.obs.BucketFile;
import utility.tools.Encryption;

public class Controller
extends BaseClass {
    public ClientUserInfo userInfo;
    public JSONObject content;
    private ReturnObject returnObject;
    public String systemclient = "";
    public int pageNumber = 1;
    public int pageSize = 20;
    public int rowindex = 0;
    public long userid = 0L;
    public long usersiteid = 0L;
    public int usertype = 0;
    public String username = "";
    public String siteid = "";
    public String phonenumber = "";
    public long departmentid = 0L;
    public long hrid = 0L;
    public long sys_enterpriseid = 0L;
    public boolean isleader = false;
    public String pageSorting;
    public JSONArray pageSortingArray;
    public List<FileItem> requestFileItemList;
    public YOSAPI requestAPI;
    public YOSAPI.YosRequest request;
    private String accesstoken = "";
    public String languagecode = "ZH";
    private static HashMap<Long, String> headPicMap = new HashMap();
    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap();

    public Controller(JSONObject content) throws YosException {
        try {
            this.dbConnect.setCreatesqllog(Parameter.get("system_db_sqllog").equalsIgnoreCase("true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.content = content;
        this.returnObject = new ReturnObject(this);
        if (this.content.containsKey("pageNumber")) {
            this.pageNumber = this.content.getIntValue("pageNumber");
        }
        if (this.content.containsKey("pageSize")) {
            this.pageSize = this.content.getIntValue("pageSize");
        }
        if (this.content.containsKey("rowindex")) {
            this.rowindex = this.content.getIntValue("rowindex");
        }
        if (this.content.containsKey("accesstoken")) {
            this.accesstoken = this.content.getString("accesstoken");
            if (parameter.tokenlist.containsKey(this.accesstoken)) {
                this.usersiteid = parameter.tokenlist.get(this.accesstoken);
            }
        }
        if (parameter.usersiteIdList.containsKey(this.usersiteid)) {
            Row row = parameter.usersiteIdList.get(this.usersiteid);
            this.userid = row.getLong("userid");
            this.siteid = row.getString("siteid");
            this.username = row.getString("name");
            this.phonenumber = row.getString("phonenumber");
            this.systemclient = row.getString("systemclient");
            this.departmentid = row.getLong("departmentid");
            this.usertype = row.getInteger("usertype");
            this.hrid = row.getLong("hrid");
            if (row.containsKey("sys_enterpriseid")) {
                this.sys_enterpriseid = row.getLong("sys_enterpriseid");
            } else {
                Row enterpriseRow = this.getEnterpriseByUserid(this.userid);
                this.sys_enterpriseid = enterpriseRow.getLong("sys_enterpriseid");
                row.put("sys_enterpriseid", this.sys_enterpriseid);
                parameter.usersiteIdList.put(this.usersiteid, row);
            }
            if (row.containsKey("isleader")) {
                this.isleader = row.getBoolean("isleader");
            } else {
                this.isleader = this.getHr(this.userid).getBoolean("isleader") || this.getEnterpriseHr(this.userid).getBoolean("isleader");
                row.put("isleader", this.isleader);
                parameter.usersiteIdList.put(this.usersiteid, row);
            }
        }
        if (this.siteid == null || this.siteid.equals("") || content.containsKey("siteid")) {
            this.siteid = (String)content.getOrDefault("siteid", "");
        }
        this.userInfo = new ClientUserInfo(this);
        this.userInfo.setUserId(this.userid);
        this.userInfo.setUserName(this.username);
        this.userInfo.setPhoneNumber(this.phonenumber);
        this.userInfo.setSiteId(this.siteid);
        this.userInfo.setUserSiteId(this.usersiteid);
        this.userInfo.setUserType(this.usertype);
    }

    public void setYosapi(YOSAPI requestAPI, YOSAPI.YosRequest request) {
        this.requestAPI = requestAPI;
        this.request = request;
        this.languagecode = request.getLanguageCode();
        this.userInfo.setLanguageCode(this.languagecode);
    }

    public String getAccesstoken() {
        return this.accesstoken;
    }

    public void setSorting() throws YosException {
        Sorting sorting = new Sorting(this, this.requestAPI);
        this.pageSorting = sorting.getOrderBy();
        this.pageSortingArray = sorting.getSorts();
    }

    public void setrequestFileItemList(List<FileItem> requestFileItemList) {
        this.requestFileItemList = requestFileItemList;
    }

    public ExcelFactory getPostExcelFactory() throws IOException {
        for (FileItem item : this.requestFileItemList) {
            if (item.isFormField()) continue;
            String filename = new String(item.getName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            filename = filename.substring(0, filename.lastIndexOf("."));
            return new ExcelFactory(filename, item.getInputStream());
        }
        return null;
    }

    public ExcelFactory getPostExcelFactory(String obsObjectname) throws IOException, YosException {
        BucketFile bucketFile = new BucketFile(this.siteid);
        return new ExcelFactory(bucketFile.getObjectInputStream(obsObjectname));
    }

    public ExcelFactory getPostExcelFactory(Long attachmentid) throws IOException, YosException {
        Rows rows = this.dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + this.siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return this.getPostExcelFactory(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public InputStream getPostFileInputStream(String obsObjectname) throws YosException {
        BucketFile bucketFile = new BucketFile(this.siteid);
        return bucketFile.getObjectInputStream(obsObjectname);
    }

    public InputStream getPostFileInputStream(Long attachmentid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select serialnumber from sys_attachment where siteid='" + this.siteid + "' and attachmentid=" + attachmentid);
        if (rows.isNotEmpty()) {
            return this.getPostFileInputStream(rows.get(0).getString("serialnumber"));
        }
        return null;
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, columnwidths);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, exportFieldsArray, dataarrays);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadEasyExcelToObs(String excelfilename, String sheetname, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        EasyExcelFactory easyExcelFactory = new EasyExcelFactory(excelfilename);
        easyExcelFactory.setTableid(this.content.getLongValue("tableid"), this.siteid);
        easyExcelFactory.write(sheetname, exportFieldsArray, dataarrays);
        return this.uploadExcelToObs(easyExcelFactory);
    }

    public Rows uploadCSVToObs(String excelfilename, JSONArray exportFieldsArray, JSONArray dataarrays) throws YosException, IOException {
        CSVFactory csvFactory = new CSVFactory(excelfilename);
        csvFactory.write(exportFieldsArray, dataarrays);
        return this.uploadExcelToObs(csvFactory);
    }

    public Rows uploadExcelToObs(String excelfilename, String sheetname, Rows rows, HashMap<String, String> titlemap, Integer[] columnwidths) throws YosException, IOException {
        ExcelFactory excelFactory = new ExcelFactory(excelfilename);
        excelFactory.addSheet(sheetname, rows, titlemap, columnwidths);
        return this.uploadExcelToObs(excelFactory);
    }

    public Rows uploadExcelToObs(ExcelFactory excelFactory) throws YosException {
        if (!excelFactory.isWrite.booleanValue()) {
            try {
                excelFactory.write();
            }
            catch (Exception e) {
                throw new YosException("excel\u5199\u5165\u9519\u8bef");
            }
        }
        return this.uploadFileToObs(excelFactory.getFile());
    }

    public Rows uploadExcelToObs(EasyExcelFactory easyExcelFactory) throws YosException {
        return this.uploadFileToObs(easyExcelFactory.getFile());
    }

    public Rows uploadExcelToObs(CSVFactory csvFactory) throws YosException {
        return this.uploadFileToObs(csvFactory.getFile());
    }

    public Rows uploadFileToObs(File file) throws YosException {
        String document = file.getName();
        String postfix = "";
        try {
            postfix = document.substring(document.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String serialnumber = this.createMD5FileName() + "." + postfix;
        BucketFile bucketFile = new BucketFile(this.siteid);
        bucketFile.upload(serialnumber, file);
        if (bucketFile.doesObjectExist(serialnumber)) {
            String appfolderid = Parameter.get(this.siteid, "appfolderid");
            long attachmentid = this.createTableID("sys_attachment");
            SQLFactory sqlFactory = new SQLFactory("\u9644\u4ef6\u4fe1\u606f\u63d2\u5165");
            sqlFactory.addParameter("parentid", appfolderid);
            sqlFactory.addParameter("attachmentid", attachmentid);
            sqlFactory.addParameter("siteid", this.siteid);
            sqlFactory.addParameter("createby", this.username);
            sqlFactory.addParameter("type", "sourcefile");
            sqlFactory.addParameter("postfix", postfix);
            sqlFactory.addParameter("serialnumber", serialnumber);
            sqlFactory.addParameter("document", document);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(serialnumber));
            sqlFactory.addParameter("mpctaskid", "null");
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(serialnumber).getContentLength());
            this.dbConnect.runSqlUpdate(sqlFactory);
            return this.getAttachmentUrl(attachmentid);
        }
        return new Rows();
    }

    public void createFileLink(String ownertable, Long ownerid, String usetype, Long attachmentid) throws YosException {
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_attachment_links");
        insertSQL.setUniqueid(this.createTableID("sys_attachment_links"));
        insertSQL.setSiteid(this.siteid);
        insertSQL.setValue("attachmentid", attachmentid);
        insertSQL.setValue("ownertable", ownertable);
        insertSQL.setValue("ownerid", ownerid);
        insertSQL.setValue("usetype", usetype);
        insertSQL.setValue("createby", this.username);
        insertSQL.setDateValue("createdate");
        insertSQL.insert();
    }

    public Row getHr(long userid) throws YosException {
        return this.getHr(userid, this.siteid);
    }

    public Row getDepartment(long userid) throws YosException {
        return this.getDepartment(userid, this.siteid);
    }

    public Row getEnterpriseByUserid(long userid) throws YosException {
        return this.getEnterpriseByUserid(userid, this.siteid);
    }

    public Row getEnterpriseHr(long userid) throws YosException {
        return this.getEnterpriseHr(userid, this.siteid);
    }

    public Rows getEnterpriseHrs(long sys_enterpriseid) throws YosException {
        return this.getEnterpriseHrs(sys_enterpriseid, this.siteid);
    }

    public ReturnObject_Err getErrReturnObject() {
        return this.returnObject.getErrObject();
    }

    public ReturnObject_Code getReturnObject() throws YosException {
        return this.returnObject.getCodeObject();
    }

    public ReturnObject_Warn getWarnReturnObject() {
        return this.returnObject.getWarnObject();
    }

    public ReturnObject_Suc getSucReturnObject() {
        return this.returnObject.getSucObject();
    }

    public void logroleout(long roleid) throws YosException {
        ArrayList<String> useridlist = this.dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (id.equals(String.valueOf(this.userid))) continue;
            this.loguserout(Long.parseLong(id));
        }
    }

    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid) throws YosException {
        ArrayList<Long> ownerids = new ArrayList<Long>();
        ownerids.add(ownerid);
        return this.getAttachmentUrl(ownertable, ownerids).get(String.valueOf(ownerid));
    }

    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids) throws YosException {
        return Attachment.get(this, ownertable, ownerids);
    }

    @Deprecated
    public Rows getAttachmentUrl(Long ... attachmentids) throws YosException {
        return Attachment.get(this, attachmentids);
    }

    @Deprecated
    public Rows getAttachmentUrl(ArrayList<Long> attachmentid) throws YosException {
        return Attachment.get(this, attachmentid);
    }

    @Deprecated
    public Rows getAttachmentUrl(String ownertable, Long ownerid, String usetype) throws YosException {
        return Attachment.get(this, ownertable, ownerid, usetype);
    }

    @Deprecated
    public RowsMap getAttachmentUrl(String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        return Attachment.get(this, ownertable, ownerids, usetype);
    }

    @Deprecated
    public Rows getSubAttachmentUrl(Long attachmentid) throws YosException {
        ArrayList<Long> attachmentids = new ArrayList<Long>();
        attachmentids.add(attachmentid);
        return this.getSubAttachmentUrl(attachmentids).get(attachmentid);
    }

    @Deprecated
    public RowsMap getSubAttachmentUrl(ArrayList<Long> attachmentids) throws YosException {
        return Attachment.getSub(this, attachmentids);
    }

    public String getHeadPic(long userid) throws YosException {
        if (!headPicMap.containsKey(userid)) {
            Rows rows = Attachment.get(this, "sys_users", (Long)userid, "headportrait");
            headPicMap.put(userid, rows.isEmpty() ? "" : rows.get(0).getString("url"));
        }
        return headPicMap.getOrDefault(userid, "");
    }

    public Rows getDataLog(String tablename, long dataid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_datalog where table_name='" + tablename + "' and dataid=" + dataid + " order by changedate desc");
        for (Row row : rows) {
            row.put("olddata", JSONObject.parseObject((String)row.getString("olddata")));
            row.put("newdata", JSONObject.parseObject((String)row.getString("newdata")));
        }
        return rows;
    }

    public ArrayList<Long> getImDialogUserIds(long timdialogid) throws YosException {
        return this.getImDialogUserIds(timdialogid, this.siteid);
    }

    public Date getLoginDate() {
        return this.getLoginDate(this.usersiteid);
    }

    public void loguserout() throws YosException {
        ArrayList<String> usersiteids = this.dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid!=" + this.userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (!parameter.usersiteIdList.containsKey(usersiteid)) continue;
            String token = parameter.usersiteIdList.get(usersiteid).getString("token");
            parameter.tokenlist.remove(token);
        }
        this.dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + this.userid + "'");
    }

    public String createBillCode(String coderuletype) throws YosException {
        return this.createBillCode(this.siteid, coderuletype);
    }

    public String getSystemIconUrl(Long systemid, String usetype) throws YosException {
        Row row = Attachment.getLatest(this, "sys_system", systemid, usetype);
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(this.dbConnect, "YOSSYS", "sys_system", systemid, usetype);
        return row.getString("url");
    }

    public String getSystemModuleCoverUrl(Long systemmoduleid) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemmodule", systemmoduleid, "cover");
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(this.dbConnect, "YOSSYS", "sys_systemmodule", systemmoduleid, "cover");
        return row.getString("url");
    }

    public String getSystemModuleIconUrl(Long systemmoduleid, String usetype) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemmodule", systemmoduleid, usetype);
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(this.dbConnect, "YOSSYS", "sys_systemmodule", systemmoduleid, usetype);
        return row.getString("url");
    }

    public String getSystemAppCoverUrl(Long systemappid) throws YosException {
        Row row = Attachment.getLatest(this, "sys_systemapp", systemappid, "cover");
        if (!row.getString("url").equals("")) {
            return row.getString("url");
        }
        row = Attachment.getLatest(this.dbConnect, "YOSSYS", "sys_systemapp", systemappid, "cover");
        return row.getString("url");
    }

    public String getReportToken(long sys_reportid) throws YosException {
        return this.getReportToken(sys_reportid, 0L);
    }

    public String getReportToken(long sys_reportid, long dataid) throws YosException {
        long sys_report_sessionid = this.createTableID("sys_report_session");
        String token = Encryption.Encode_MD5(this.siteid + sys_reportid + sys_report_sessionid + this.username + this.userid);
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_report_session");
        insertSQL.setSiteid(this.siteid).setUniqueid(sys_report_sessionid);
        insertSQL.setValue("sys_reportid", sys_reportid);
        insertSQL.setValue("userid", this.userid);
        insertSQL.setDateValue("createdate");
        insertSQL.setValue("token", token);
        insertSQL.setValue("dataid", dataid);
        insertSQL.setValue("systemclient", this.systemclient);
        insertSQL.insert();
        return token;
    }

    public void cleanAllDataPool() {
        DataPool.removeByAccesstoken(this.accesstoken);
    }

    public void cleanAllDataPool(long userid) {
        DataPool.removeByUserid(userid);
    }

    public void CACHEING_CLEAN(Long userid) {
        try {
            this.request.addCacheing_cleanUser(userid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String SQLSystemParamHandle(String sqlstr) throws YosException {
        ArrayList<Long> sublist;
        sqlstr = sqlstr.replaceAll("(?i):sys_enterpriseid", "'" + this.sys_enterpriseid + "'");
        sqlstr = sqlstr.replaceAll("(?i):userid", "'" + this.userid + "'");
        sqlstr = sqlstr.replaceAll("(?i):hrid", "'" + this.hrid + "'");
        sqlstr = sqlstr.replaceAll("(?i):departmentid", "'" + this.departmentid + "'");
        if ((sqlstr = sqlstr.replaceAll("(?i):siteid", "'" + this.siteid + "'")).contains(":subuserids")) {
            sublist = User.getSubUserIds(this);
            sublist.add(this.userid);
            sqlstr = sqlstr.replaceAll("(?i):subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        if (sqlstr.contains(":subhrids")) {
            sublist = User.getSubHrIds(this);
            sublist.add(this.hrid);
            sqlstr = sqlstr.replaceAll("(?i):subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        if (sqlstr.contains(":subsys_enterpriseids")) {
            sublist = User.getSubEnterpriseids(this);
            sqlstr = sublist.isEmpty() ? sqlstr.replaceAll("(?i):subsys_enterpriseids", "(null)") : sqlstr.replaceAll("(?i):subsys_enterpriseids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        if (sqlstr.contains(":subdepartmentids")) {
            sublist = Department.getSubDepartmentIds(this);
            sublist.add(this.departmentid);
            sqlstr = sqlstr.replaceAll("(?i):subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
        }
        return sqlstr;
    }
}

