package utility.wechat.work.receive.core;

public abstract class QYWechatMsgRecevier {
    public CreateMsg createMsg;

    public QYWechatMsgRecevier() {
        createMsg = new CreateMsg();
    }

    /**
     * 文字消息处理
     *
     * @param Content      文字消息内容
     * @param FromUserName
     * @param ToUserName
     * @return 返回的xml内容
     */
    public abstract String switchTextMsg(String AgentID, String Content, String FromUserName,
                                         String ToUserName);

    /**
     * 图片消息处理
     *
     * @param PicUrl       图片的地址
     * @param MediaId
     * @param FromUserName
     * @param ToUserName
     * @return 返回的xml内容
     */
    public abstract String switchImageMsg(String AgentID,String PicUrl, String MediaId,
                                          String FromUserName, String ToUserName);

    /**
     * 音频消息处理
     *
     * @param MediaId
     * @param Format       语音格式
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchVoiceMsg(String AgentID,String MediaId, String Format,
                                          String FromUserName, String ToUserName);

    /**
     * 视频消息处理
     *
     * @param MediaId
     * @param ThumbMediaId 视频消息缩略图的媒体id，可以调用获取媒体文件接口拉取数据
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchVideoMsg(String AgentID,String MediaId, String ThumbMediaId,
                                          String FromUserName, String ToUserName);

    /**
     * 小视频消息处理
     *
     * @param MediaId
     * @param ThumbMediaId 视频消息缩略图的媒体id，可以调用获取媒体文件接口拉取数据
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchShortvideoMsg(String AgentID,String MediaId,
                                               String ThumbMediaId, String FromUserName, String ToUserName);

    /**
     * 位置消息处理
     *
     * @param Location_X   纬度
     * @param Location_Y   经度
     * @param Scale        地图缩放大小
     * @param Label        地理位置信息
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchLocationMsg(String AgentID,String Location_X,
                                             String Location_Y, String Scale, String Label, String FromUserName,
                                             String ToUserName);

    /**
     * 成员关注取消事件处理
     *
     * @param AgentID
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchSubscribeEventMsg(String AgentID,
                                                   String FromUserName, String ToUserName);

    /**
     * 上报地理位置事件处理（自动上报）
     *
     * @param AgentID
     * @param Latitude     纬度
     * @param Longitude    经度
     * @param Precision    精度
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchLocationEventMsg(String AgentID,
                                                  String Latitude, String Longitude, String Precision,
                                                  String FromUserName, String ToUserName);

    /**
     * 点击菜单按钮的事件处理
     *
     * @param EventKey     事件KEY值，与自定义菜单接口中KEY值对应
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchClickEventMsg(String AgentID, String EventKey,
                                               String FromUserName, String ToUserName);

    /**
     * 点击菜单跳转链接的事件处理
     *
     * @param EventKey     事件KEY值，设置的跳转URL
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchViewEventMsg(String AgentID, String EventKey,
                                              String FromUserName, String ToUserName);

    /**
     * 成员进入应用的事件处理
     *
     * @param EventKey     事件KEY值，此事件该值为空
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchEnter_agentEventMsg(String AgentID, String EventKey,
                                                     String FromUserName, String ToUserName);

    /**
     * 扫码推事件的事件处理
     *
     * @param EventKey     事件KEY值，由开发者在创建菜单时设定
     * @param ScanType     扫描类型，一般是qrcode
     * @param ScanResult   扫描结果，即二维码对应的字符串信息
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchScancode_pushEventMsg(String AgentID,String EventKey,
                                                       String ScanType, String ScanResult, String FromUserName,
                                                       String ToUserName);

    /**
     * 扫码推事件且弹出“消息接收中”提示框的事件处理
     *
     * @param EventKey     事件KEY值，由开发者在创建菜单时设定
     * @param ScanType     扫描类型，一般是qrcode
     * @param ScanResult   扫描结果，即二维码对应的字符串信息
     * @param FromUserName
     * @param ToUserName
     * @return
     */
    public abstract String switchScancode_waitmsgEventMsg(String AgentID,String EventKey,
                                                          String ScanType, String ScanResult, String FromUserName,
                                                          String ToUserName);
}
