package utility.wechat.work.receive.core;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateMsg {
    /**
     * 创建简单文字消息
     *
     * @param content
     */
    public String createTextMsg(String content, String FromUserName,
                                String ToUserName) {
        String format = "<xml>\n" + "<ToUserName><![CDATA[" + FromUserName
                + "]]></ToUserName>\n" + "<FromUserName><![CDATA[" + ToUserName
                + "]]></FromUserName>\n" + "<CreateTime>"
                + Calendar.getInstance().getTime().getTime()
                + "</CreateTime>\n" + "<MsgType><![CDATA[text]]></MsgType>\n"
                + "<Content><![CDATA[" + content + "]]></Content>\n" + "</xml>";
        return format;
    }

    /**
     * 创建新闻消息
     *
     * @param content
     */
    public String createNewsMsg(List<Map<String, String>> content,
                                String FromUserName, String ToUserName) {
        int count = content.size();// 信息条数
        Iterator<Map<String, String>> it = content.iterator();
        String items = "";
        while (it.hasNext()) {
            Map<String, String> map = it.next();
            String Title = map.get("Title");// 表题
            String Description = map.get("Description");// 描述
            String PicUrl = map.get("PicUrl");// 图片url
            String Url = map.get("Url");// 链接地址
            items = items + "<item>" + "<Title><![CDATA[" + Title
                    + "]]></Title>" + " <Description><![CDATA[" + Description
                    + "]]></Description>" + " <PicUrl><![CDATA[" + PicUrl
                    + "]]></PicUrl>" + "<Url><![CDATA[" + Url + "]]></Url>"
                    + "</item>";
        }
        String format = "<xml>\n" + "<ToUserName><![CDATA[" + FromUserName
                + "]]></ToUserName>\n" + "<FromUserName><![CDATA[" + ToUserName
                + "]]></FromUserName>\n" + "<CreateTime>"
                + Calendar.getInstance().getTime().getTime()
                + "</CreateTime>\n" + "<MsgType><![CDATA[news]]></MsgType>\n"
                + "<ArticleCount>" + count + "</ArticleCount>\n" + "<Articles>"
                + items + "</Articles>" + "</xml>";
        return format;
    }

}
