package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_systemapp_formcols implements YosObject {

    @Override
    public String table_comment() {
        return "系统应用表单栏位设置表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("formcolid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new BigIntCol("formid", "表单ID"));
        list.add(new VarcharCol("columnname", "字段名称", 50));
        list.add(new VarcharCol("title", "字段标题", 50));
        list.add(new LongTextCol("script", "执行脚本"));
        list.add(new SmallIntCol("required", "是否必填", 0));
        list.add(new SmallIntCol("hidden", "是否隐藏", 0));
        list.add(new IntCol("span", "占用宽度", 1));
        list.add(new IntCol("sequence", "排序号", 1));
        list.add(new JsonCol("dataformat", "数据转换"));
        list.add(new SmallIntCol("readonly", "只读", 0));
        list.add(new TextCol("regex", "正则表达式"));

        list.add(new VarcharCol("type", "组件类型", "Input、Textarea 、InputNumber 、Select 、DialogSelect 、DatePicker 、Switch", 50, "textfield"));
        list.add(new VarcharCol("dialogname", "选择框名称", 50));
        list.add(new JsonCol("request", "请求体"));
//        list.add(new VarcharCol("select_labelfield", "选择器显示字段", 50, "label"));
//        list.add(new VarcharCol("select_valuefield", "选择器取值字段", 50, "value"));
        list.add(new JsonCol("select_fieldmapping", "选择器取值字段"));
        return list;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
