package utility.wechat.wechatpay.POJO;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import utility.tools.WebRequest;

import java.util.Iterator;

public class CreateOrderRequest extends Base {
    private String appid;//应用ID
    private String body;//商品描述
    private String mch_id;//商户号
    private String notify_url;//通知地址
    private String out_trade_no;//商户订单号
    private String spbill_create_ip;//终端IP
    private Integer total_fee;//总金额
    private String trade_type;//交易类型
    private String openid;


    public void setAppid(String appid) {
        this.appid = appid;
    }


    public void setBody(String body) {
        this.body = body;
    }


    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }


    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }


    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }


    public void setSpbill_create_ip(String spbill_create_ip) {
        this.spbill_create_ip = spbill_create_ip;
    }


    public void setTotal_fee(int total_fee) {
        this.total_fee = total_fee;
    }


    public void setTrade_type(String trade_type) {
        this.trade_type = trade_type;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public CreateOrderResponse getOrderResponse(String mch_key) {
        String requestxml = asXml(mch_key);
        String res = new WebRequest().doPost(requestxml, "https://api.mch.weixin.qq.com/pay/unifiedorder");
        return getCreateOrderResponse(res);
    }

    private String asXml(String mch_key) {
        DOMElement request = new DOMElement("xml");
        request.addElement("appid").addText(appid);//应用ID
        request.addElement("body").addText(body);//商品描述
        request.addElement("mch_id").addText(mch_id);//商户ID
        request.addElement("nonce_str").addText(createNonce_str(out_trade_no + spbill_create_ip));//随机字符串
        request.addElement("notify_url").addText(notify_url);//支付结果通知地址
        if (openid != null) {
            request.addElement("openid").addText(openid);//交易类型
        }
        request.addElement("out_trade_no").addText(out_trade_no);//商户订单号
        request.addElement("spbill_create_ip").addText(spbill_create_ip);//终端IP
        request.addElement("total_fee").addText(String.valueOf(total_fee));//总金额
        request.addElement("trade_type").addText(trade_type);//交易类型

        createSign(request, mch_key);
        return request.asXML();
    }

    private CreateOrderResponse getCreateOrderResponse(String response) {
        CreateOrderResponse orderResponse = new CreateOrderResponse();
        try {
            Document respones = DocumentHelper.parseText(response);
            Iterator<Element> it = respones.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element element = it.next();
                String key = element.getName();
                String text = element.getText();
                switch (key) {
                    case "return_code": {
                        orderResponse.setReturn_code(text);
                        break;
                    }
                    case "return_msg": {
                        orderResponse.setReturn_msg(text);
                        break;
                    }
                    case "appid": {
                        orderResponse.setAppid(text);
                        break;
                    }
                    case "mch_id": {
                        orderResponse.setMch_id(text);
                        break;
                    }
                    case "device_info": {
                        orderResponse.setDevice_info(text);
                        break;
                    }
                    case "nonce_str": {
                        orderResponse.setNonce_str(text);
                        break;
                    }
                    case "sign": {
                        orderResponse.setSign(text);
                        break;
                    }
                    case "result_code": {
                        orderResponse.setResult_code(text);
                        break;
                    }
                    case "err_code": {
                        orderResponse.setErr_code(text);
                        break;
                    }
                    case "err_code_des": {
                        orderResponse.setErr_code_des(text);
                        break;
                    }
                    case "trade_type": {
                        orderResponse.setTrade_type(text);
                        break;
                    }
                    case "prepay_id": {
                        orderResponse.setPrepay_id(text);
                        break;
                    }
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return orderResponse;
    }


}
