package utility.tools;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class locationtech {
    /**
     * 根据经纬度计算两个点之间的距离。单位千米
     *
     * @param lat1 位置1 经度
     * @param lon1 位置1 纬度
     * @param lat2 位置2 经度
     * @param lon2 位置2 纬度
     * @return
     */
    public double caculate(double lat1, double lon1, double lat2, double lon2) {
        SpatialContext geo = SpatialContext.GEO;
        Point point = new PointImpl(lat1, lon1, geo);
        Point point1 = new PointImpl(lat2, lon2, geo);
        return Math.round(geo.calcDistance(point, point1) * DistanceUtils.DEG_TO_KM, 2);
    }
}
