package utility.email;

import javax.activation.DataHandler;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import java.net.URL;

public class EmailContent extends MimeMultipart {
    public EmailContent() throws Exception {
        this.setSubType("mixed");
    }

    /**
     * 添加文字内容
     *
     * @param text
     * @throws Exception
     */
    public void addText(String text) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent(text, "text/html;charset=UTF-8");
        this.addBodyPart(mimeBodyPart);
    }

    /**
     * 添加文字内容
     *
     * @param blankspacecount 空格数
     * @param text            文字
     * @throws Exception
     */
    public void addText(int blankspacecount, String text) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < blankspacecount; i++) {
            stringBuffer.append("&nbsp;");
        }
        addText(stringBuffer.toString() + text);
    }

    /**
     * 添加一个文字超链接
     *
     * @param title 超链接标题
     * @param url   超链接地址
     * @throws Exception
     */
    public void addLink(String title, String url) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent("<a href='" + url + "'>" + title + "</a>", "text/html;charset=UTF-8");
        this.addBodyPart(mimeBodyPart);
    }

    /**
     * 添加图片连接
     *
     * @param url
     * @throws Exception
     */
    public void addImage(String url) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent("<img src='" + url + "'>", "text/html;charset=UTF-8");
        this.addBodyPart(mimeBodyPart);
    }


    /**
     * 添加空行
     *
     * @throws Exception
     */
    public void addBr() throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent("<br/>", "text/html;charset=UTF-8");
        this.addBodyPart(mimeBodyPart);
    }

    /**
     * 添加空行
     *
     * @throws Exception
     */
    public void addBr(int count) throws Exception {
        for (int i = 0; i < count; i++) {
            addBr();
        }
    }

    /**
     * 添加附件
     *
     * @param url
     * @throws Exception
     */
    public void addFile(String url) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        DataHandler dataHandler = new DataHandler(new URL(url));
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.setFileName(dataHandler.getName());
        this.addBodyPart(mimeBodyPart);
    }

}
