package service;

import common.ServiceController;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import utility.tools.MessageMonitoringStation;

import java.util.Calendar;

/**
 * 数据异常监控
 */
public class DataValidate extends ServiceController {

    @Override
    public void serviceRun() throws YosException {
        try {
            QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_datawarn", "title", "sqlstr", "datakey", "level");
            querySQL.setWhere("isused", 1);
            querySQL.setWhere("type", "error");
            querySQL.setOrderBy("sequence");
            Rows rows = querySQL.query();
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                String title = row.getString("title");
                int level = row.getInteger("level") == 0 ? 3 : row.getInteger("level");
                if (level == 3 && (Calendar.getInstance().get(Calendar.HOUR_OF_DAY) <= 8 || Calendar.getInstance().get(Calendar.HOUR_OF_DAY) >= 17)) {
                    //等级为一般的异常，只在早上8点至下午17点之间提醒
                    continue;
                }
                try {
                    Rows errdatas;
                    if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
                        errdatas = dbConnect.runSqlQuery(row.getString("sqlstr"));
                    } else if (datakey.equalsIgnoreCase("sqliteCache")) {
                        errdatas = SQLiteMemory.runSqlQuery(row.getString("sqlstr"));
                    } else {
                        errdatas = new DBConnect(datakey).runSqlQuery(row.getString("sqlstr"));
                    }
                    int errcount = errdatas.size();
                    if (errcount > 0) {
                        if (level == 1) {
                            MessageMonitoringStation.send("【紧急】[" + title + "],异常数 " + errcount);
                        } else if (level == 2) {
                            MessageMonitoringStation.send("【重要】[" + title + "],异常数 " + errcount);
                        } else if (level == 3) {
                            MessageMonitoringStation.send("【一般】[" + title + "],异常数 " + errcount);
                        }
                        MessageMonitoringStation.send("[" + title + "],异常数 " + errcount);
                    }
                } catch (Exception e) {
                    MessageMonitoringStation.send("[" + title + "]查询出错，请检查");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
