package restcontroller.sysmanage.develop.attachment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

public class Attachment extends Controller {
    public Attachment(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "媒体文件查询", apiversion = R.ID2024061710590401.v1.class)
    public String queryAttachment() throws YosException {
        QuerySQL attachmentQuerySQL = SQLFactory.createQuerySQL(this, "sys_attachment").setTableAlias("t1");
        attachmentQuerySQL.setPage(pageSize, pageNumber);
        if (!content.getStringValue("siteid").equals("")) {
            attachmentQuerySQL.setSiteid(content.getString("siteid"));
        }
        if (!content.getStringValue("ownertable").equals("")) {
            attachmentQuerySQL.setWhere("exists(select * from sys_attachment_links where sys_attachment_links.ownertable='" + content.getString("ownertable") + "'and t1.attachmentid=sys_attachment_links.attachmentid )");
        }
        if (!content.getStringValue("postfix").equals("")) {
            attachmentQuerySQL.setWhere("t1.postfix", content.getStringValue("postfix"));
        }
        if (content.getLongValue("ownerid") > 0) {
            attachmentQuerySQL.setWhere("exists(select * from sys_attachment_links where sys_attachment_links.ownerid=" + content.getLong("ownerid") + " and t1.attachmentid=sys_attachment_links.attachmentid )");
        }
        if (content.getLongValue("attachmentid") > 0) {
            if (content.getBooleanValue("getsub")) {
                Rows rows = beans.attachment.Attachment.get(this, content.getLong("attachmentid"));
                if (rows.isNotEmpty()) {
                    attachmentQuerySQL.setWhere("(parentid=" + content.getLong("attachmentid") + ")");
                }
            } else {
                attachmentQuerySQL.setWhere("attachmentid", content.getLong("attachmentid"));
            }
        } else {
            attachmentQuerySQL.setWhere("(ifnull(parentid,0)<=0 or exists(select * from sys_attachment t2 where t1.parentid=t2.attachmentid and t2.isfolder=1) )");
        }
        attachmentQuerySQL.setCondition("document", "serialnumber", "url", "createby");
        attachmentQuerySQL.setOrderBy("t1.attachmentid desc");
        Rows attachmentRows = attachmentQuerySQL.query();

        QuerySQL attachment_linksQuerySQL = SQLFactory.createQuerySQL(this, "sys_attachment_links").setTableAlias("t1");
        attachment_linksQuerySQL.addJoinTable(JOINTYPE.left, "sys_attachment_linkdatashow", "t2", "t1.ownertable=t2.ownertable");
        attachment_linksQuerySQL.addQueryFields("t1.attachmentid,t1.siteid,t1.jumpurl,t1.sequence,t1.changeby,t1.changedate,t1.linksid,t1.ownerid,t1.ownertable,t1.usetype,t1.createby,t1.createdate,t2.appname,t2.datafields");
        attachment_linksQuerySQL.setWhere("attachmentid", attachmentRows.toArrayList("attachmentid"));
        RowsMap attachment_linksRowsMap = attachment_linksQuerySQL.query().toRowsMap("attachmentid");

        for (Row attachmentRow : attachmentRows) {
            Rows attachment_linksRows = attachment_linksRowsMap.get(attachmentRow.getString("attachmentid"));
            for (Row attachment_linksRow : attachment_linksRows) {
                String ownertable = attachment_linksRow.getString("ownertable");
                long ownerid = attachment_linksRow.getLong("ownerid");
                if (dbConnect.runSqlQuery("select * from sys_object where table_name='" + ownertable + "'").isNotEmpty()) {
                    QuerySQL linkdataQuery = SQLFactory.createQuerySQL(this, ownertable);
                    linkdataQuery.setUniqueid(ownerid);
                    Rows linkdataRows = linkdataQuery.query();
                    if (linkdataRows.isNotEmpty()) {
                        attachment_linksRow.put("data", linkdataRows.get(0));
                    } else {
                        attachment_linksRow.put("data", new JSONObject());
                        attachment_linksRow.put("datastatus", "数据丢失");
                    }
                } else {
                    attachment_linksRow.put("data", new JSONObject());
                    attachment_linksRow.put("datastatus", "表丢失");
                }
            }

            attachmentRow.put("links", attachment_linksRows);
            long contentlength = attachmentRow.getLong("contentlength");
            if (contentlength == 0) {
                attachmentRow.put("contentlength", "");
            } else if (contentlength / (1024 * 1024) < 1) {
                attachmentRow.put("contentlength", contentlength / (1024) + "KB");
            } else if (contentlength / (1024 * 1024 * 1024) < 1) {
                attachmentRow.put("contentlength", contentlength / (1024 * 1024) + "MB");
            } else {
                attachmentRow.put("contentlength", contentlength / (1024 * 1024 * 1024) + "GB");
            }
            attachmentRow.put("isImage", isImage(attachmentRow.getString("postfix")));
            attachmentRow.put("isVideo", isVideo(attachmentRow.getString("postfix")));
        }
        return getSucReturnObject().setData(attachmentRows).toString();
    }

    private boolean isVideo(String filetype) {
        String[] videotypes = new String[]{"mp4", "mov", "m4v", "3gp", "mkv", "rm", "rmvb", "wmv", "mpg", "avi", "mpeg"};
        for (String videotype : videotypes) {
            if (filetype.equalsIgnoreCase(videotype)) {
                return true;
            }
        }
        return false;
    }

    private boolean isImage(String postfix) {
        String[] imagetypes = new String[]{"jpg", "gif", "png", "svg", "jpeg"};
        for (String videotype : imagetypes) {
            if (postfix.equalsIgnoreCase(videotype)) {
                return true;
            }
        }
        return false;
    }

    @API(title = "数据关联展示规则列表查询", apiversion = R.ID10008201.v1.class)
    public String querylinkdatashow() throws YosException {
        SQLFactory sqlFactory = new SQLFactory(this, "数据关联展示规则列表查询");
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        for (Row row : rows) {
            row.put("datafields", row.getJSONArray("datafields"));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据关联展示规则新增、修改", apiversion = R.ID10008301.v1.class)
    public String insertorupdatelinkdatashow() throws YosException {
        String ownertable = content.getString("ownertable");
        String appname = content.getString("appname");
        JSONArray datafields = content.getJSONArray("datafields");

        SQLFactory sqlFactory;
        if (dbConnect.runSqlQuery("select * from sys_attachment_linkdatashow where ownertable='" + ownertable + "'").isEmpty()) {
            sqlFactory = new SQLFactory(this, "数据关联展示规则新增");
            sqlFactory.addParameter("sys_attachment_linkdatashowid", createTableID("sys_attachment_linkdatashow"));
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        } else {
            sqlFactory = new SQLFactory(this, "数据关联展示规则修改");
            sqlFactory.addParameter("ownertable", ownertable);
            sqlFactory.addParameter("appname", appname);
            sqlFactory.addParameter("datafields", datafields.toJSONString());
        }
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        return getSucReturnObject().toString();
    }

    @API(title = "数据关联展示规则新增、修改", apiversion = R.ID10008401.v1.class)
    public String deletelinkdatashow() throws YosException {
        String ownertable = content.getString("ownertable");
        dbConnect.runSqlUpdate("delete from sys_attachment_linkdatashow where ownertable='" + ownertable + "'");
        return getSucReturnObject().toString();
    }

}
