package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-系统应用注册管理-表单管理")
public class appregistry_form extends Controller {

    public appregistry_form(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 应用表单查询
     *
     * @return
     */
    @API(title = "应用表单查询")
    public String query_appformlist() throws YosException {
        long systemappid = content.getLong("systemappid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_forms");
        querySQL.setWhere("systemappid", systemappid);
        Rows rows = querySQL.query();
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用表单新增修改
     *
     * @return
     */
    @API(title = "应用表单新增修改")
    public String insertormodify_appform() throws YosException {
        String form = content.getString("form");
        String formname = content.getString("formname");
        if (form.equals("") || !String.valueOf(form.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表单名称必须以英文字母开头").toString();
        }
        if (!form.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("表单名称必须为英文字母或英文数字组合").toString();
        }
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            long systemappid = 0L;

            Rows sys_systemappRows = dbConnect.runSqlQuery("select * from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用" + systemapp + "不存在").toString();
            }
            systemappid = sys_systemappRows.get(0).getLong("systemappid");
            Rows sys_systemapp_formsRows = dbConnect.runSqlQuery("select*from sys_systemapp_forms where systemappid=" + systemappid + " and `form`='" + form + "'");
            if (sys_systemapp_formsRows.isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_forms");
                insertSQL.setValue("systemappid", systemappid);
                insertSQL.setValue("form", form);
                insertSQL.setValue("formname", formname);
                insertSQL.insert();
            } else {
                long formid = sys_systemapp_formsRows.get(0).getLong("formid");
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_forms");
                updateSQL.setValue("form", form);
                updateSQL.setValue("formname", formname);
                updateSQL.setWhere("formid", formid);
                updateSQL.update();
            }
            return getSucReturnObject().toString();
        } else {
            long systemappid = content.getLong("systemappid");
            long formid = content.getLongValue("formid");//新增时传0
            if (formid <= 0 || dbConnect.runSqlQuery("select formid from sys_systemapp_forms where formid=" + formid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_forms where systemappid='" + systemappid + "' and `form`='" + form + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表单注册不可重复").toString();
                }
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_forms");
                insertSQL.setValue("systemappid", systemappid);
                insertSQL.setValue("form", form);
                insertSQL.setValue("formname", formname);
                insertSQL.insert();
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_forms where formid!='" + formid + "' and systemappid='" + systemappid + "' and `form`='" + form + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表单注册不可重复").toString();
                }
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_forms");
                updateSQL.setValue("form", form);
                updateSQL.setValue("formname", formname);
                updateSQL.setWhere("formid", formid);
                updateSQL.update();
            }
            return query_appformlist();
        }
    }

    /**
     * 应用表单删除
     *
     * @return
     */
    @API(title = "应用表单删除")
    public String delete_appform() throws YosException {
        long formid = content.getLong("formid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_formcols_site where formcolid in (select formcolid from sys_systemapp_formcols where formid=" + formid + ")");
        list.add("delete from sys_systemapp_forms where formid=" + formid);
        list.add("delete from sys_systemapp_formcols where formid=" + formid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 应用表单查询
     *
     * @return
     */
    @API(title = "应用表单栏位查询")
    public String query_appformcollist() throws YosException {
        long formid = content.getLong("formid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_formcols");
        querySQL.setWhere("formid", formid);
        querySQL.setOrderBy("sequence");
        Rows rows = querySQL.query();
        int rownum = 1;
        int spansum = 0;
        for (Row row : rows) {
            JSONObject dataformat = row.getJSONObject("dataformat");
            if (!dataformat.containsKey("type")) {
                dataformat.put("type", "");
            }
            if (!dataformat.containsKey("mapping")) {
                dataformat.put("mapping", new JSONArray());
            }
            if (!dataformat.containsKey("option_typename")) {
                dataformat.put("option_typename", "");
            }
            row.put("dataformat", dataformat);

            spansum = spansum + row.getInteger("span");
            if (spansum > 6) {
                spansum = row.getInteger("span");
                rownum = rownum + 1;
            }
            row.put("rownum", rownum);
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用表单查询
     *
     * @return
     */
    @API(title = "站点应用表单栏位查询")
    public String query_siteappformcollist() throws YosException {
        long formid = content.getLong("formid");
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_formcols");
        querySQL.setWhere("formid", formid);
        querySQL.setOrderBy("sequence");
        Rows rows = querySQL.query();

        JSONArray array = new JSONArray();

        Rows siteRows = dbConnect.runSqlQuery("select siteid,sitename from sys_site order by siteuid");
        RowsMap siteformcolRowsMap = dbConnect.runSqlQuery("select t1.siteid,t1.formcolid,t1.title,t1.hidden,t1.required,t1.span,t1.fielddatatype from sys_systemapp_formcols_site t1 inner join sys_systemapp_formcols t2 on t1.formcolid=t2.formcolid and t2.formid=" + formid).toRowsMap("siteid");
        for (Row siteRow : siteRows) {
            String siteid = siteRow.getString("siteid");
            String sitename = siteRow.getString("sitename");

            JSONObject object = new JSONObject();
            object.put("siteid", siteid);
            object.put("sitename", sitename);

            JSONArray sitecolarray = new JSONArray();
            RowsMap map = siteformcolRowsMap.get(siteid).toRowsMap("formcolid");
            for (Row colrow : rows) {
                JSONObject sitecolObject = new JSONObject();
                long formcolid = colrow.getLong("formcolid");
                sitecolObject.put("formcolid", formcolid);
                sitecolObject.put("title_default", colrow.getString("title"));
                sitecolObject.put("script", colrow.getString("script"));
                sitecolObject.put("required", colrow.getInteger("required"));
                sitecolObject.put("hidden", colrow.getInteger("hidden"));
                sitecolObject.put("span", colrow.getInteger("span"));

                if (map.containsKey(String.valueOf(formcolid))) {
                    Row siterow = map.get(String.valueOf(formcolid)).get(0);
                    sitecolObject.put("title", siterow.getString("title").equals("") ? colrow.getString("title") : siterow.getString("title"));
                    sitecolObject.put("required", siterow.getInteger("required") == 0 ? colrow.getInteger("required") : 1);
                    sitecolObject.put("hidden", siterow.getInteger("hidden") == 0 ? colrow.getInteger("hidden") : 1);
                    sitecolObject.put("span", siterow.getInteger("span") == 0 ? colrow.getInteger("span") : 1);
                    sitecolObject.put("fielddatatype", siterow.getString("fielddatatype"));
                    sitecolObject.put("customed", 1);
                } else {
                    sitecolObject.put("title", colrow.getString("title"));
                    sitecolObject.put("required", colrow.getInteger("required"));
                    sitecolObject.put("hidden", colrow.getInteger("hidden"));
                    sitecolObject.put("span", colrow.getInteger("span"));
                    sitecolObject.put("fielddatatype", "");
                    sitecolObject.put("customed", 0);
                }
                sitecolarray.add(sitecolObject);
            }
            object.put("list", sitecolarray);
            array.add(object);
        }
        return getSucReturnObject().setData(array).toString();
    }

    @API(title = "应用表单栏位新增修改")
    public String quickaddappformcol() throws YosException {
        long formid = content.getLong("formid");
        ArrayList<String> sqlist = new ArrayList<>();
        try {
            JSONArray contentArray = content.getJSONArray("content");
            for (Object o : contentArray) {
                JSONObject object = (JSONObject) o;
                String label = object.getString("label");
                int span = object.getIntValue("span", 1);
                String columnname = object.getString("value").substring(object.getString("value").lastIndexOf(".") + 1);

                Rows sys_systemapp_formcolsRows = dbConnect.runSqlQuery("select * from sys_systemapp_formcols where formid=" + formid + " and columnname='" + columnname + "'");
                if (sys_systemapp_formcolsRows.isEmpty()) {
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_formcols");
                    insertSQL.setValue("formid", formid);
                    insertSQL.setValue("columnname", columnname);
                    insertSQL.setValue("title", label);
                    insertSQL.setValue("script", "");
                    insertSQL.setValue("required", false);
                    insertSQL.setValue("hidden", false);
                    insertSQL.setValue("span", span);
                    insertSQL.setValue("dataformat", new JSONObject());
                    sqlist.add(insertSQL.getSQL());
                } else {
                    long formcolid = sys_systemapp_formcolsRows.get(0).getLong("formcolid");
                    UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_formcols");
                    updateSQL.setValue("columnname", columnname);
                    updateSQL.setValue("title", label);
                    updateSQL.setValue("script", "");
                    updateSQL.setValue("required", false);
                    updateSQL.setValue("hidden", false);
                    updateSQL.setValue("span", span);
                    updateSQL.setWhere("formcolid", formcolid);
                    sqlist.add(updateSQL.getSQL());
                }
            }
            if (!sqlist.isEmpty()) {
                dbConnect.runSqlUpdate(sqlist);
            }
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg("不是有效的jsonArray格式").toString();
        }
        return getSucReturnObject().toString();
    }

    /**
     * 应用表单栏位新增修改
     *
     * @return
     */
    @API(title = "应用表单栏位新增修改")
    public String insertormodify_appformcol() throws YosException {
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            String form = content.getString("form");
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int hidden = content.getIntValue("hidden");
            int required = content.getIntValue("required");
            String script = content.getStringValue("script", true);
            int span = content.getIntValue("span", 1);
            int sequence = content.getIntValue("sequence");
            int readonly = content.getIntValue("readonly");
            String regex = content.getStringValue("regex", true);
            JSONObject dataformatObject = new JSONObject();
            if (content.containsKey("dataformat")) {
                dataformatObject = content.getJSONObject("dataformat");
            }

            String type = content.getStringValue("type");
            JSONObject request_JSON = new JSONObject();
            if (content.containsKey("request")) {
                request_JSON = content.getJSONObject("request");
            }
//            String select_labelfield = content.getStringValue("select_labelfield");
//            String select_valuefield = content.getStringValue("select_valuefield");
            JSONArray select_fieldmapping = content.getJSONArray("select_fieldmapping");
            String dialogname = content.getStringValue("dialogname");


            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("系统应用" + systemapp + "不存在").toString();
            }
            long systemappid = sys_systemappRows.get(0).getLong("systemappid");

            Rows sys_systemapp_formsRows = dbConnect.runSqlQuery("select * from sys_systemapp_forms where systemappid='" + systemappid + "' and `form`='" + form + "' ");
            if (sys_systemapp_formsRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用表" + form + "不存在").toString();
            }
            long formid = sys_systemapp_formsRows.get(0).getLong("formid");

            Rows sys_systemapp_formcolsRows = dbConnect.runSqlQuery("select * from sys_systemapp_formcols where formid=" + formid + " and columnname='" + columnname + "'");

            if (sys_systemapp_formcolsRows.isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_formcols");
                insertSQL.setValue("formid", formid);
                insertSQL.setValue("columnname", columnname);
                insertSQL.setValue("title", title);
                insertSQL.setValue("script", script);
                insertSQL.setValue("required", required);
                insertSQL.setValue("hidden", hidden);
                insertSQL.setValue("span", span);
                insertSQL.setValue("dataformat", dataformatObject);
                insertSQL.setValue("type", type);
                insertSQL.setValue("request", request_JSON);
//                insertSQL.setValue("select_labelfield", select_labelfield);
//                insertSQL.setValue("select_valuefield", select_valuefield);
                insertSQL.setValue("select_fieldmapping", select_fieldmapping);
                insertSQL.setValue("dialogname", dialogname);
                insertSQL.setValue("readonly", readonly);
                insertSQL.setValue("regex", regex);
                if (sequence > 0) {
                    insertSQL.setValue("sequence", sequence);
                }
                insertSQL.insert();
            } else {
                long formcolid = sys_systemapp_formcolsRows.get(0).getLong("formcolid");

                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_formcols");
                updateSQL.setValue("columnname", columnname);
                updateSQL.setValue("title", title);
                updateSQL.setValue("script", script);
                updateSQL.setValue("required", required);
                updateSQL.setValue("hidden", hidden);
                updateSQL.setWhere("formcolid", formcolid);
                updateSQL.setValue("span", span);
                updateSQL.setValue("dataformat", dataformatObject);
                updateSQL.setValue("type", type);
                updateSQL.setValue("request", request_JSON);
//                updateSQL.setValue("select_labelfield", select_labelfield);
//                updateSQL.setValue("select_valuefield", select_valuefield);
                updateSQL.setValue("select_fieldmapping", select_fieldmapping);
                updateSQL.setValue("dialogname", dialogname);
                updateSQL.setValue("readonly", readonly);
                updateSQL.setValue("regex", regex);
                if (sequence > 0) {
                    updateSQL.setValue("sequence", sequence);
                }
                updateSQL.update();
            }
            return getSucReturnObject().toString();
        } else {
            long formid = content.getLong("formid");
            long formcolid = content.getLongValue("formcolid");//新增时传0
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int hidden = content.getIntValue("hidden");
            int required = content.getIntValue("required");
            String script = content.getStringValue("script", true);
            int span = content.getIntValue("span", 1);
            int readonly = content.getIntValue("readonly");
            String regex = content.getString("regex", true);

            String type = content.getStringValue("type");
            JSONObject request_JSON = new JSONObject();
            if (content.containsKey("request")) {
                request_JSON = content.getJSONObject("request");
            }
//            String select_labelfield = content.getStringValue("select_labelfield");
//            String select_valuefield = content.getStringValue("select_valuefield");
            JSONArray select_fieldmapping = content.getJSONArray("select_fieldmapping");
            String dialogname = content.getStringValue("dialogname");

            JSONObject dataformatObject = content.getJSONObject("dataformat");
            if (dataformatObject.getStringValue("type").equals("mapping")) {
                dataformatObject.put("option_typename", "");
            } else if (dataformatObject.getStringValue("type").equals("option")) {
                dataformatObject.put("mapping", new JSONArray());
            } else {
                dataformatObject.put("option_typename", "");
                dataformatObject.put("mapping", new JSONArray());
            }
            if (formcolid <= 0 || dbConnect.runSqlQuery("select formcolid from sys_systemapp_formcols where formcolid=" + formcolid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_formcols where formid='" + formid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表单栏位不可重复").toString();
                }
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_formcols");
                insertSQL.setValue("formid", formid);
                insertSQL.setValue("columnname", columnname);
                insertSQL.setValue("title", title);
                insertSQL.setValue("script", script);
                insertSQL.setValue("required", required);
                insertSQL.setValue("hidden", hidden);
                insertSQL.setValue("span", span);
                insertSQL.setValue("dataformat", dataformatObject);
                insertSQL.setValue("type", type);
                insertSQL.setValue("request", request_JSON);
//                insertSQL.setValue("select_labelfield", select_labelfield);
//                insertSQL.setValue("select_valuefield", select_valuefield);
                insertSQL.setValue("select_fieldmapping", select_fieldmapping);
                insertSQL.setValue("dialogname", dialogname);
                insertSQL.setValue("readonly", readonly);
                insertSQL.setValue("regex", regex);
                insertSQL.insert();
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_formcols where formcolid!='" + formcolid + "' and formid='" + formid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表单栏位不可重复").toString();
                }
                UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_systemapp_formcols");
                updateSQL.setValue("columnname", columnname);
                updateSQL.setValue("title", title);
                updateSQL.setValue("script", script);
                updateSQL.setValue("required", required);
                updateSQL.setValue("hidden", hidden);
                updateSQL.setWhere("formcolid", formcolid);
                updateSQL.setValue("span", span);
                updateSQL.setValue("dataformat", dataformatObject);
                updateSQL.setValue("type", type);
                updateSQL.setValue("request", request_JSON);
//                updateSQL.setValue("select_labelfield", select_labelfield);
//                updateSQL.setValue("select_valuefield", select_valuefield);
                updateSQL.setValue("select_fieldmapping", select_fieldmapping);
                updateSQL.setValue("dialogname", dialogname);
                updateSQL.setValue("readonly", readonly);
                updateSQL.setValue("regex", regex);
                updateSQL.update();
            }
            return query_appformcollist();
        }
    }

    /**
     * 应用表单栏位新增修改
     *
     * @return
     */
    @API(title = "站点应用表单栏位新增修改")
    public String modify_appformcol_site() throws YosException {
        long formcolid = content.getLong("formcolid");
        String siteid = content.getString("siteid");
        String title = content.getString("title");
        int hidden = content.getIntValue("hidden");
        int required = content.getIntValue("required");
        int span = content.getIntValue("span", 0);
        String fielddatatype = content.getStringValue("fielddatatype");

        Rows sys_systemapp_formcolsRows = dbConnect.runSqlQuery("select * from sys_systemapp_formcols where formcolid=" + formcolid);
        if (sys_systemapp_formcolsRows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到该表单栏位").toString();
        }

        String title_default = sys_systemapp_formcolsRows.get(0).getString("title");
        int hidden_default = sys_systemapp_formcolsRows.get(0).getInteger("hidden");
        int required_default = sys_systemapp_formcolsRows.get(0).getInteger("required");
        int span_default = sys_systemapp_formcolsRows.get(0).getInteger("span");

        if ((title.trim().equals("") || title.equals(title_default)) && (required == 0 || required == required_default) && (hidden == 0 || hidden == hidden_default) && fielddatatype.equals("")) {
            dbConnect.runSqlUpdate("delete from sys_systemapp_formcols_site where siteid='" + siteid + "' and formcolid=" + formcolid);
            return getSucReturnObject().toString();
        }

        title = title.equals(title_default) ? "" : title;
        hidden = hidden == hidden_default ? 0 : hidden;
        required = required == required_default ? 0 : required;
        span = span == 0 ? span_default : span;
        if (dbConnect.runSqlQuery("select *from sys_systemapp_formcols_site where siteid='" + siteid + "'and formcolid=" + formcolid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_formcols_site");
            insertSQL.setValue("siteid", siteid);
            insertSQL.setValue("formcolid", formcolid);
            insertSQL.setValue("title", title);
            insertSQL.setValue("required", required);
            insertSQL.setValue("hidden", hidden);
            insertSQL.setValue("span", span);
            insertSQL.setValue("fielddatatype", fielddatatype);
            insertSQL.insert();
        } else {
            dbConnect.runSqlUpdate("update sys_systemapp_formcols_site set title='" + title + "',hidden=" + hidden + ",required=" + required + ",span=" + span + ",fielddatatype='" + fielddatatype + "' where siteid='" + siteid + "' and formcolid=" + formcolid);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "应用表单栏位删除")
    public String delete_appformcol() throws YosException {
        long formcolid = content.getLong("formcolid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_formcols where formcolid=" + formcolid);
        list.add("delete from sys_systemapp_formcols_site where formcolid=" + formcolid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "应用表单选择", apiversion = R.ID2024062110525101.v1.class)
    public String queryform() throws YosException {
        QuerySQL formQuerySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_forms", "formid", "`form`", "formname").setTableAlias("t1");
        formQuerySQL.addJoinTable(JOINTYPE.inner, "sys_systemapp", "t2", "t1.systemappid = t2.systemappid", "systemappname");
        formQuerySQL.setCondition("t1.`form`", "t1.formname", "t1.formid", "t2.systemappname");
        formQuerySQL.setPage(pageSize, pageNumber);
        Rows formrows = formQuerySQL.query();

        QuerySQL formColQuerySQL = SQLFactory.createQuerySQL(this, "sys_systemapp_formcols", "formid", "columnname", "title", "type").setTableAlias("t1");
        formColQuerySQL.setWhere("formid", formrows.toArrayList("formid"));
        RowsMap formRowsMap = formColQuerySQL.query().toRowsMap("formid");
        for (Row formrow : formrows) {
            formrow.put("formcols", formRowsMap.get(formrow.getString("formid")));
        }
        return getSucReturnObject().setData(formrows).toString();
    }

    @API(title = "应用表单复制", apiversion = R.ID2024062110531001.v1.class)
    public String duplicateform() throws YosException {
        long systemappid = content.getLong("systemappid");
        long formid = content.getLong("formid");

        ArrayList<String> sqlList = new ArrayList<>();

        Rows formrows = dbConnect.runSqlQuery("select `form`,formname from sys_systemapp_forms where formid=" + formid);
        for (Row formrow : formrows) {
            long newformid = createTableID("sys_systemapp_forms");

            InsertSQL form_insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_forms");
            form_insertSQL.setValue("systemappid", systemappid);
            form_insertSQL.setValue("formid", newformid);
            form_insertSQL.setValue("`form`", formrow.getString("form"));
            form_insertSQL.setValue("formname", formrow.getString("formname"));
            sqlList.add(form_insertSQL.getSQL());

            Rows formcolrows = dbConnect.runSqlQuery("select * from sys_systemapp_formcols where formid=" + formid);
            for (Row formcolrow : formcolrows) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_systemapp_formcols");
                insertSQL.setValue("formid", newformid);
                insertSQL.setValue("formcolid", createTableID("sys_systemapp_formcols"));
                insertSQL.setValue("columnname", formcolrow.getString("columnname"));
                insertSQL.setValue("title", formcolrow.getString("title"));
                insertSQL.setValue("span", formcolrow.getInteger("span"));
                insertSQL.setValue("type", formcolrow.getString("type"));
                insertSQL.setValue("readonly", formcolrow.getBoolean("readonly"));
                insertSQL.setValue("hidden", formcolrow.getBoolean("hidden"));
                insertSQL.setValue("required", formcolrow.getBoolean("required"));
                insertSQL.setValue("dialogname", formcolrow.getInteger("dialogname"));
                insertSQL.setValue("select_labelfield", formcolrow.getString("select_labelfield"));
                insertSQL.setValue("select_valuefield", formcolrow.getString("select_valuefield"));
                insertSQL.setValue("sequence", formcolrow.getInteger("sequence"));
                insertSQL.setValue("script", formcolrow.getString("script"));
                insertSQL.setValue("regex", formcolrow.getString("regex"));
                insertSQL.setValue("dataformat", formcolrow.getJSONObject("dataformat"));
                insertSQL.setValue("request", formcolrow.getJSONObject("request"));
                insertSQL.setValue("select_fieldmapping", formcolrow.getString("select_fieldmapping"));
                sqlList.add(insertSQL.getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqlList);
        return getSucReturnObject().toString();
    }
}
