package objectregister;

import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_version implements YosObject {
    @Override
    public String table_comment() {
        return "系统版本";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("versionid", "系统版本ID");
    }

    @Override
    public void DataInit() throws YosException {
        if (new DBConnect().runSqlQuery("select * from sys_version").isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(new DBConnect(), "sys_version");
            insertSQL.setValue("version", "默认版本");
            insertSQL.setValue("isdefault", true);
            insertSQL.insert();
        }
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("version", "版本名称", 50));
        list.add(new SmallIntCol("isdefault", "授权所有应用", 0));
        return list;
    }
}
