/*
 * Decompiled with CFR 0.152.
 */
package utility.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ZipUtil {
    public static int BUFFER_SIZE = 2048;

    public static void main(String[] args) {
        try {
            String p = "/Users/shenjingwei/Downloads/css/101.9e1d9865.css";
            File file = new File(p);
            File parentfile = file.getParentFile();
            if (!parentfile.exists()) {
                parentfile.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipPath(String sourcePath, String zipFilePath) {
        boolean result = false;
        ZipArchiveEntry entry = null;
        ZipArchiveOutputStream zaos = null;
        InputStream is = null;
        try {
            File path = new File(sourcePath);
            if (path.exists()) {
                if (path.isDirectory()) {
                    File zipFile = new File(zipFilePath);
                    zaos = new ZipArchiveOutputStream(zipFile);
                    File[] fileList = path.listFiles();
                    for (int i = 0; i < fileList.length; ++i) {
                        File file = fileList[i];
                        if (file.isDirectory()) {
                            ZipUtil.zipPathFile(file.getAbsolutePath(), "", zaos);
                            continue;
                        }
                        entry = new ZipArchiveEntry(file, file.getName());
                        zaos.setUseZip64(Zip64Mode.AsNeeded);
                        zaos.putArchiveEntry((ArchiveEntry)entry);
                        is = new BufferedInputStream(new FileInputStream(file));
                        byte[] buffer = new byte[5120];
                        int len = -1;
                        while ((len = is.read(buffer)) != -1) {
                            zaos.write(buffer, 0, len);
                        }
                        is.close();
                        zaos.closeArchiveEntry();
                    }
                    result = true;
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zaos != null) {
                    zaos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    private static void zipPathFile(String sourcePath, String parentPath, ZipArchiveOutputStream zaos) throws Exception {
        File path = new File(sourcePath);
        ZipArchiveEntry entry = null;
        entry = StringUtils.isBlank((String)parentPath) ? new ZipArchiveEntry(path, path.getName()) : new ZipArchiveEntry(path, parentPath + File.separator + path.getName());
        zaos.setUseZip64(Zip64Mode.AsNeeded);
        zaos.putArchiveEntry((ArchiveEntry)entry);
        zaos.closeArchiveEntry();
        File[] fileList = path.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (file.isDirectory()) {
                if (StringUtils.isBlank((String)parentPath)) {
                    ZipUtil.zipPathFile(file.getAbsolutePath(), path.getName(), zaos);
                    continue;
                }
                ZipUtil.zipPathFile(file.getAbsolutePath(), parentPath + File.separator + path.getName(), zaos);
                continue;
            }
            entry = StringUtils.isBlank((String)parentPath) ? new ZipArchiveEntry(file, path.getName() + File.separator + file.getName()) : new ZipArchiveEntry(file, parentPath + File.separator + path.getName() + File.separator + file.getName());
            zaos.setUseZip64(Zip64Mode.AsNeeded);
            zaos.putArchiveEntry((ArchiveEntry)entry);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[5120];
            int len = -1;
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                zaos.write(buffer, 0, len);
            }
            ((InputStream)is).close();
            zaos.closeArchiveEntry();
        }
    }

    public static void zip(File[] files, String zipFilePath) {
        if (files != null && files.length > 0) {
            ZipArchiveOutputStream zaos = null;
            try {
                File zipFile = new File(zipFilePath);
                zaos = new ZipArchiveOutputStream(zipFile);
                zaos.setUseZip64(Zip64Mode.AsNeeded);
                for (File file : files) {
                    if (file == null) continue;
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file, file.getName());
                    zaos.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    try (InputStream is = null;){
                        is = new BufferedInputStream(new FileInputStream(file));
                        byte[] buffer = new byte[5120];
                        int len = -1;
                        while ((len = is.read(buffer)) != -1) {
                            zaos.write(buffer, 0, len);
                        }
                        zaos.closeArchiveEntry();
                    }
                }
                zaos.finish();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (zaos != null) {
                        zaos.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unZip(String filePath, String destDir) throws Exception {
        File zipFile = new File(filePath);
        if (StringUtils.isBlank((String)destDir)) {
            destDir = zipFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        ZipArchiveInputStream is = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            fileInputStream = new FileInputStream(zipFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream, BUFFER_SIZE);
            is = new ZipArchiveInputStream((InputStream)bufferedInputStream);
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                String filename = entry.getName();
                boolean isDirectory = entry.isDirectory();
                if (filename.startsWith("__MACOSX")) continue;
                fileNames.add(filename);
                File file = new File(destDir, filename);
                File parentfile = file.getParentFile();
                if (parentfile != null && !parentfile.exists()) {
                    parentfile.mkdirs();
                }
                if (isDirectory) {
                    if (file.exists()) continue;
                    file.mkdir();
                    continue;
                }
                OutputStream os = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    os = new BufferedOutputStream(fileOutputStream, BUFFER_SIZE);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    os.flush();
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly((InputStream)fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return fileNames;
    }
}

