package objectregister;

import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_optiontype implements YosObject {
    @Override
    public String table_comment() {
        return "系统选项分类表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("optiontypeid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        return new ArrayList<>();
    }


    @Override
    public void DataInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        if (SQLFactory.createQuerySQL(dbConnect, "sys_optiontype").setWhere("typename", "fielddatatype").query().isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_optiontype");
            insertSQL.setValue("typename", "fielddatatype");
            insertSQL.setValue("issql", false);
            insertSQL.setValue("issubvaluemag", false);
            insertSQL.setValue("issystem", true);
            insertSQL.setValue("remarks", "字段类型分类");
            insertSQL.insert();
        }
    }
}
