/*
 * Decompiled with CFR 0.152.
 */
package swing.controls;

import common.data.Row;
import common.data.Rows;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import swing.YUIParameter;

public class YComboBox
extends JComponent {
    private JLabel titleLable;
    private JComboBox<Object> valueComboBox;

    public YComboBox(String title) {
        this.titleLable = new JLabel(title.equals("") ? "" : title + ":", 4);
        this.titleLable.setPreferredSize(new Dimension(50, 25));
        this.titleLable.setOpaque(false);
        this.valueComboBox = new JComboBox();
        this.valueComboBox.setPreferredSize(new Dimension(150, 25));
        this.setMaximumSize(new Dimension(220, 38));
        this.setLayout(new FlowLayout());
        this.add(this.titleLable);
        this.add(this.valueComboBox);
        if (YUIParameter.isdebug.booleanValue()) {
            this.setBorder(BorderFactory.createLineBorder(YUIParameter.bordercolor));
        }
    }

    public YComboBox setTitle(String title) {
        this.titleLable.setText(title.equals("") ? "" : title + ":");
        return this;
    }

    public String getTitle() {
        return this.titleLable.getText();
    }

    public YComboBox setTitleFontColor(Color color) {
        this.titleLable.setForeground(color);
        return this;
    }

    public YComboBox setTitleFont(Font font) {
        this.titleLable.setFont(font);
        return this;
    }

    public YComboBox setTitleTip(String tip) {
        this.titleLable.setToolTipText(tip);
        return this;
    }

    public String getTitleTip() {
        return this.titleLable.getToolTipText();
    }

    public YComboBox setSelectedItem(Object item) {
        this.valueComboBox.setSelectedItem(item);
        return this;
    }

    public Object getSelectedItem() {
        return this.valueComboBox.getSelectedItem();
    }

    public YComboBox addItems(Object ... items) {
        for (Object item : items) {
            this.valueComboBox.addItem(item);
        }
        return this;
    }

    public YComboBox addItems(ArrayList<Object> items) {
        for (Object item : items) {
            this.valueComboBox.addItem(item);
        }
        return this;
    }

    public YComboBox addItems(Rows rows, String ... fieldnames) {
        for (Row row : rows) {
            this.valueComboBox.addItem(row.setToStringValue(fieldnames));
        }
        return this;
    }

    public void setListener(Container container, Class listener) {
        try {
            Constructor cla = listener.getDeclaredConstructor(Container.class);
            Object obj = cla.newInstance(container);
            this.valueComboBox.addActionListener((ActionListener)obj);
            this.valueComboBox.addItemListener((ItemListener)obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

