/*
 * Decompiled with CFR 0.152.
 */
package common.parameter;

import com.alibaba.fastjson.JSONObject;
import common.YosLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import utility.tools.Encryption;
import utility.tools.MessageMonitoringStation;

public class License
implements YosLogger {
    private String customer;
    private String licenseType;
    private int maxDBConCount = 50;
    private String macAddress;
    private Date expiresDate;
    private static JSONObject licenseDataObject = new JSONObject();
    private static int day = 0;
    private static License license = new License();
    static String publicKey_str = "MIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAT3/ly1i2dCCahHFdxx+v21eg0Y1gnhU2m0CCmvlG15pCTJG7r3BQPNG9wzY2g5JtzhvIZ58PNsuqtMkXYtZJYiCrP77scgFF9uedwc+dtKHvCQLMQhIuIN75q/WMpXpXvwl8Po21Ja+8Wu/gNMa2SEAGmXVR6yVOmM9lTrQOjBI=";
    public static String headkey = "V1c5elRHbGpaVzV6WlElM0QlM0Q=";

    public String getCustomer() {
        return this.customer;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public int getMaxDBConCount() {
        if (this.maxDBConCount <= 0 || this.maxDBConCount > 100) {
            return 50;
        }
        return this.maxDBConCount;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public long getVerifyDays() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(license.getExpiresDate());
        LocalDate enddate = LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return ChronoUnit.DAYS.between(LocalDate.now(), enddate);
    }

    private void setCustomer(String customer) {
        this.customer = customer;
        logger.info((Object)("\u6388\u6743\u5bf9\u8c61:" + customer));
    }

    private void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
        logger.info((Object)("\u8bc1\u4e66\u7c7b\u578b:" + licenseType));
    }

    private void setMaxDBConCount(int maxDBConCount) {
        this.maxDBConCount = maxDBConCount;
        logger.info((Object)("\u6570\u636e\u5e93\u6700\u5927\u8fde\u63a5\u6570:" + maxDBConCount));
    }

    private void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
        logger.info((Object)("\u7269\u7406\u5730\u5740:" + macAddress));
    }

    private void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
        logger.info((Object)("\u6388\u6743\u622a\u6b62\u65e5\u671f:" + new SimpleDateFormat("yyyy-MM-dd").format(expiresDate)));
    }

    public static License get() {
        block12: {
            if (day != (day = Calendar.getInstance().get(5)) && System.getProperty("catalina.home") != null) {
                logger.info((Object)"===========\u6388\u6743\u8bb8\u53ef\u8bc1\u4e66\u6821\u9a8c===========");
                try {
                    int bytesRead;
                    FileInputStream inputStream = new FileInputStream(System.getProperty("catalina.home") + "/webapps/yos.license");
                    byte[] buffer = new byte[1024];
                    StringBuilder license_str = new StringBuilder();
                    while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                        license_str.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                    }
                    ((InputStream)inputStream).close();
                    if (License.verifyLicense(license_str.toString())) {
                        license.setCustomer(Encryption.Decode_Base64(licenseDataObject.getString("customer"), "utf-8"));
                        license.setLicenseType(licenseDataObject.getString("licenseType"));
                        license.setMaxDBConCount(licenseDataObject.getIntValue("maxDBConCount"));
                        license.setMacAddress(licenseDataObject.getString("macAddress"));
                        if (!licenseDataObject.getStringValue("macAddress").equals("")) {
                            byte[] macAddress = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
                            StringBuilder sb1 = new StringBuilder();
                            for (int i = 0; i < macAddress.length; ++i) {
                                sb1.append(String.format("%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
                            }
                            if (!licenseDataObject.getStringValue("macAddress").replace(":", "").replace("-", "").equalsIgnoreCase(sb1.toString().replace("-", ""))) {
                                logger.error((Object)("===========MAC\u5730\u5740" + sb1 + "\u65e0\u6548\uff01==========="));
                                System.exit(0);
                            }
                        }
                        Date expiresDate = new SimpleDateFormat("yyyyMMdd").parse(licenseDataObject.getString("expiresDate"));
                        license.setExpiresDate(expiresDate);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(expiresDate);
                        calendar.add(5, 1);
                        if (Calendar.getInstance().getTime().before(calendar.getTime())) {
                            logger.info((Object)"===========\u6388\u6743\u8bc1\u4e66\u9a8c\u8bc1\u901a\u8fc7\uff01===========");
                            try {
                                if (license.getVerifyDays() < 15L) {
                                    MessageMonitoringStation.send("\u300a" + license.getCustomer() + "\u300b\u6388\u6743\u8bc1\u4e66\u5373\u5c06\u4e8e" + new SimpleDateFormat("yyyy-MM-dd").format(license.getExpiresDate()) + "\u65e5\u5230\u671f\uff01");
                                }
                                break block12;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block12;
                        }
                        logger.error((Object)"===========\u6388\u6743\u8bc1\u4e66\u5df2\u8fc7\u671f\uff01===========");
                        System.exit(0);
                        break block12;
                    }
                    logger.error((Object)"===========\u6388\u6743\u8bc1\u4e66\u65e0\u6548\uff01===========");
                    System.exit(0);
                }
                catch (Exception e) {
                    logger.error((Object)"===========\u6388\u6743\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff01===========");
                    System.exit(0);
                    e.printStackTrace();
                }
            }
        }
        return license;
    }

    private static boolean verifyLicense(String licenseData) throws Exception {
        licenseData = new String(License.decodeHex(licenseData), StandardCharsets.UTF_8);
        String data = licenseData.substring(0, licenseData.indexOf(headkey));
        data = new String(License.decodeHex(data), StandardCharsets.UTF_8);
        try {
            licenseDataObject = JSONObject.parseObject((String)data);
        }
        catch (Exception e) {
            return false;
        }
        String signature = licenseData.substring(licenseData.indexOf(headkey) + headkey.length());
        byte[] publicKey_byte = License.decodeHex(publicKey_str);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKey_byte);
        PublicKey publicKey = KeyFactory.getInstance("DSA").generatePublic(publicKeySpec);
        Signature verification = Signature.getInstance("DSA");
        verification.initVerify(publicKey);
        verification.update(data.getBytes());
        return verification.verify(License.decodeHex(signature));
    }

    public static byte[] decodeHex(String hexString) {
        return Base64.getDecoder().decode(hexString.getBytes(StandardCharsets.UTF_8));
    }
}

