/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.api.common;

import com.actionsoft.bpms.api.common.HMacMD5;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class ApiUtils {
    public static final String ACCESS_KEY = "access_key";
    public static final String FORMAT = "format";
    public static final String CMD = "cmd";
    public static final String TIMESTAMP = "timestamp";
    public static final String VERSION = "v";
    public static final String SIG = "sig";
    public static final String SIG_METHOD = "sig_method";
    public static final String SESSION_ID = "sessionId";
    private static String ALGORITHMHMAC_SHA256 = "HmacSHA256";
    public static final String CHARSET_UTF8 = "UTF-8";

    private ApiUtils() {
    }

    public static boolean isEmpty(String value) {
        if (value == null) {
            return true;
        }
        if ("".equals(value)) {
            return false;
        }
        int strLen = value.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !ApiUtils.isEmpty(value);
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!ApiUtils.isEmpty(unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String toUnderlineStyle(String name) {
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    newName.append("_");
                }
                newName.append(Character.toLowerCase(c));
                continue;
            }
            newName.append(c);
        }
        return newName.toString();
    }

    public static String convertString(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, offset, length, CHARSET_UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] convertBytes(String data) {
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes(CHARSET_UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildQuery(Map<String, String> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!ApiUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            try {
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return query.toString();
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String makeSig(Map<String, String> params, String secret, Collection<String> ignoreSign) {
        byte[] hash;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        for (Object key : keys) {
            String value = params.get(key);
            if (ignoreSign != null && ignoreSign.contains(key) || !ApiUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        if (ALGORITHMHMAC_SHA256.equals(params.get(SIG_METHOD))) {
            hash = ApiUtils.encryptSHA256(query.toString(), secret);
            return ApiUtils.byte2hex(hash);
        }
        hash = ApiUtils.encryptHMAC(query.toString(), secret);
        return ApiUtils.byte2hex(hash);
    }

    public static byte[] encryptHMAC(String data, String secret) {
        try {
            return HMacMD5.getHmacMd5Bytes(ApiUtils.convertBytes(secret), ApiUtils.convertBytes(data));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptSHA256(String data, String secret) {
        try {
            Mac sha256_HMAC = Mac.getInstance(ALGORITHMHMAC_SHA256);
            SecretKeySpec secret_key = new SecretKeySpec(ApiUtils.convertBytes(secret), ALGORITHMHMAC_SHA256);
            sha256_HMAC.init(secret_key);
            return sha256_HMAC.doFinal(ApiUtils.convertBytes(data));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes(CHARSET_UTF8));
        }
        catch (GeneralSecurityException gse) {
            String msg = ApiUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString(CHARSET_UTF8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static String getResponseCharset(String ctype) {
        String charset = CHARSET_UTF8;
        if (!ApiUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || ApiUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = ApiUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return ApiUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = ApiUtils.getStreamAsString(es, charset);
        if (ApiUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            conn = connHttps;
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript");
        conn.setRequestProperty("User-Agent", "aws-apiclient");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

