package utility.tools;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import utility.hardware.Memory;
import utility.tools.WebRequest;

import java.net.InetAddress;

public class MessageMonitoringStation {
    private static boolean init = false;

    public static void send(String msg) {
        try {
            if (!init) {
                Parameter.create(new BaseClass(), "MessageMonitoringStation_Users", "@all", "消息监控台_监控消息发送对象,成员ID列表（消息接收，多个接收用|’分隔，支持1000个）。特殊情况：指定为@all，则向关注该企业应用的全部成员发");
                Parameter.create(new BaseClass(), "MessageMonitoringStation_Url", "http://124.70.211.186/Porject_Mag/rest/index", "消息监控台_监控消息发送地址");
                Parameter.create(new BaseClass(), "MessageMonitoringStation_switch", "true", "消息监控台_开关");
                Parameter.create(new BaseClass(), "system_rest_requesturl", "", "系统rest接口访问地址");
                Parameter.create(new BaseClass(), "hostname", InetAddress.getLocalHost().getHostName(), "服务器名称");
                init = true;
            }
            String MessageMonitoringStation_Users = Parameter.get("MessageMonitoringStation_Users");
            String MessageMonitoringStation_Url = Parameter.get("MessageMonitoringStation_Url");
            String MessageMonitoringStation_switch = Parameter.get("MessageMonitoringStation_switch");
            String system_rest_requesturl = Parameter.get("system_rest_requesturl");
            String hostname = Parameter.get("hostname");
            if (hostname.equals(InetAddress.getLocalHost().getHostName()) && MessageMonitoringStation_switch.equalsIgnoreCase("true") && !"".equals(MessageMonitoringStation_Users) && !"".equals(MessageMonitoringStation_Url)) {
                WebRequest webRequest = new WebRequest();
                JSONObject object = new JSONObject();
                object.put("id", "10000001");
                JSONObject contentObject = new JSONObject();
                contentObject.put("sendto", MessageMonitoringStation_Users);
                contentObject.put("msg", msg);
                contentObject.put("system_hostname", hostname);
                contentObject.put("system_projectname", Parameter.get("system_projectname"));
                if (!system_rest_requesturl.equals("")) {
                    contentObject.put("system_rest_requesturl", system_rest_requesturl);
                }
                object.put("content", contentObject);
                webRequest.doPost(object.toString(), MessageMonitoringStation_Url);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void heartBeat() {
        try {
            String MessageMonitoringStation_Url = Parameter.get("MessageMonitoringStation_Url");
            String MessageMonitoringStation_switch = Parameter.get("MessageMonitoringStation_switch");
            String system_rest_requesturl = Parameter.get("system_rest_requesturl");
            String hostname = Parameter.get("hostname");
            if (hostname.equals(InetAddress.getLocalHost().getHostName()) && MessageMonitoringStation_switch.equalsIgnoreCase("true") && !"".equals(MessageMonitoringStation_Url) && !"".equals(system_rest_requesturl)) {
                WebRequest webRequest = new WebRequest();
                JSONObject object = new JSONObject();
                object.put("id", "10000002");
                JSONObject contentObject = new JSONObject();
                contentObject.put("system_hostname", InetAddress.getLocalHost().getHostName());
                contentObject.put("system_projectname", Parameter.get("system_projectname"));
                contentObject.put("system_rest_requesturl", system_rest_requesturl);
                object.put("content", contentObject);
                object.put("memory", JSONObject.toJSON(Memory.get()));
                webRequest.doPost(object.toString(), MessageMonitoringStation_Url);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
