package restcontroller.system.attachment.huawei;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.obs.services.model.HttpMethodEnum;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;
import restcontroller.system.attachment.Attachment;
import utility.huawei.obs.BucketFile;
import utility.huawei.obs.mpc.MediaMetaData;
import utility.huawei.obs.mpc.MpcFactory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

@API(title = "附件管理")
public class OBS extends Controller {

    public OBS(JSONObject content) throws YosException {
        super(content);
    }

    public static HashMap<String, HashMap<String, String>> obsfilemap = new HashMap<>();


    @API(title = "华为云上传获取obs上传文件名称", apiversion = R.ID10019701.v1.class)
    public String getFileName() {
        JSONObject object = new JSONObject();
        try {
            String filename = content.getString("filename");
            String filetype = content.getString("filetype");
            String parentid = content.getString("parentid");

            HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
            if (content.containsKey("HttpMethod")) {
                if ("post".equalsIgnoreCase(content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.POST;
                } else if ("get".equalsIgnoreCase(content.getString("HttpMethod"))) {
                    HttpMethod = HttpMethodEnum.GET;
                }
            }
            String serialnumber = createMD5FileName() + "." + filetype;

            BucketFile bucketFile = new BucketFile(siteid);

            String uploadurl = bucketFile.getUploadUrl(filetype, serialnumber, HttpMethod);
            bucketFile.close();

            object.put("serialfilename", serialnumber);
            object.put("uploadurl", uploadurl);
            object.put("filename", filename);
            object.put("filetype", filetype);
            object.put("parentid", parentid);

            HashMap<String, String> map = new HashMap<>();
            map.put("filename", filename);
            map.put("filetype", filetype);
            map.put("parentid", parentid);

            obsfilemap.put(serialnumber, map);
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg(e.getMessage()).toString();
        }
        return getSucReturnObject().setData(object).toString();
    }


    @API(title = "华为云上传批量获取obs上传文件名称", apiversion = R.ID10019801.v1.class)
    public String getFileNames() throws YosException {
        JSONArray returnarray = new JSONArray();

        JSONArray filesArray = content.getJSONArray("files");
        for (int i = 0; i < filesArray.size(); i++) {
            try {
                JSONObject fileobject = filesArray.getJSONObject(i);
                String filename = fileobject.getString("filename");
                String filetype = fileobject.getString("filetype");
                String parentid = fileobject.getString("parentid");
                HttpMethodEnum HttpMethod = HttpMethodEnum.PUT;
                if (content.containsKey("HttpMethod")) {
                    if ("post".equalsIgnoreCase(content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.POST;
                    } else if ("get".equalsIgnoreCase(content.getString("HttpMethod"))) {
                        HttpMethod = HttpMethodEnum.GET;
                    }
                }
                String serialnumber = createMD5FileName() + "." + filetype;
                BucketFile bucketFile = new BucketFile(siteid);
                String url = bucketFile.getUploadUrl(filetype, serialnumber, HttpMethod);
                bucketFile.close();
                JSONObject object = new JSONObject();
                object.put("serialfilename", serialnumber);
                object.put("uploadurl", url);
                object.put("filename", filename);
                object.put("filetype", filetype);
                object.put("parentid", parentid);


                returnarray.add(object);

                HashMap<String, String> map = new HashMap<>();
                map.put("filename", filename);
                map.put("filetype", filetype);
                map.put("parentid", parentid);

                obsfilemap.put(serialnumber, map);
            } catch (Exception e) {
                return getErrReturnObject().setErrMsg(e.getMessage()).toString();
            }
        }
        return getSucReturnObject().setData(returnarray).toString();
    }


    @API(title = "华为云上传成功反馈", apiversion = R.ID10019901.v1.class)
    public String uploadSuccess() throws YosException {
        String serialfilename = content.getString("serialfilename");
        if (!obsfilemap.containsKey(serialfilename)) {
            return getErrReturnObject().setErrMsg("找不到对应的云存储文件").toString();
        }
        String filename = obsfilemap.get(serialfilename).get("filename");
        String filetype = obsfilemap.get(serialfilename).get("filetype");
        String parentid = obsfilemap.get(serialfilename).get("parentid");//父级文件夹id

        filename = filename.replace("'", "");

        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        try {
            ArrayList<String> SQlist = new ArrayList<>();

            BucketFile bucketFile = new BucketFile(siteid);
            if (!bucketFile.doesObjectExist(serialfilename)) {
                return getErrReturnObject().setErrMsg("找不到对应的云存储文件").toString();
            }
            /**
             * 视频转码
             */
            String mpctaskid = "null";
            String thumbnail_serialfilename = createMD5FileName() + ".jpg";
            boolean thumbnail_succsed = false;
            if (isVideo(filetype)) {
                MpcFactory mpcFactory = new MpcFactory();
                MediaMetaData data = mpcFactory.getMetaData(siteid, serialfilename);
                if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                    if (filetype.equalsIgnoreCase("mp4")) {
                        if (data != null) {
                            long bitrate = data.getBitrate();
                            long size = data.getSize();
                            if (bitrate / 1024 > 5000 || size / (1024 * 1024) > 500) {
                                mpctaskid = mpcFactory.createTranscodingTask(siteid, serialfilename);
                            }
                        }
                    } else if (filetype.equalsIgnoreCase("mov")) {
                        mpctaskid = mpcFactory.createTranscodingTask(siteid, serialfilename);
                    }
                }
                if (Parameter.get("attachment_huawei_obs_mpc_createthumbnails").equalsIgnoreCase("true")) {
                    thumbnail_succsed = mpcFactory.createThumbnailsTask(siteid, serialfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                }
            }

            /**
             * 本地信息插入
             */
            long attachmentid = createTableID("sys_attachment");
            attachmentidsarray.add(attachmentid);
            {
                SQLFactory sqlFactory = new SQLFactory(this, "附件信息插入");
                sqlFactory.addParameter("parentid", (parentid.equals("") || parentid.equals("0")) ? "null" : parentid);
                sqlFactory.addParameter("attachmentid", attachmentid);
                sqlFactory.addParameter("siteid", siteid);
                sqlFactory.addParameter("createby", username);
                sqlFactory.addParameter("type", "sourcefile");
                sqlFactory.addParameter("postfix", filetype);
                sqlFactory.addParameter("serialnumber", serialfilename);
                sqlFactory.addParameter("document", filename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(serialfilename));
                sqlFactory.addParameter("mpctaskid", mpctaskid);
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            if (thumbnail_succsed) {
                /**
                 * 生成视频文件封面图
                 */
                SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                sqlFactory.addParameter("parentid", attachmentid);
                sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                sqlFactory.addParameter("siteid", siteid);
                sqlFactory.addParameter("createby", username);
                sqlFactory.addParameter("type", "cover");
                sqlFactory.addParameter("postfix", "jpg");
                sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                sqlFactory.addParameter("document", thumbnail_serialfilename);
                sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
                sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                SQlist.add(sqlFactory.getSQL());
            }
            if (isImage(filetype)) {
                {
                    //生成缩略图附件信息
                    SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("createby", username);
                    sqlFactory.addParameter("type", "thumbnail");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "s_" + serialfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getMinImageUrl(serialfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + serialfilename).getContentLength());
                    SQlist.add(sqlFactory.getSQL());
                }
                {
                    /**
                     * 生成压缩图附件信息
                     */
                    SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("createby", username);
                    sqlFactory.addParameter("type", "compressed");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", "c_" + serialfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(serialfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + serialfilename).getContentLength());
                    SQlist.add(sqlFactory.getSQL());
                }
            }
            bucketFile.close();

            dbConnect.runSqlUpdate(SQlist);
            obsfilemap.remove(serialfilename);
            resultObject.put("code", 1);
            resultObject.put("msg", "成功");

            JSONObject object = new JSONObject();
            object.put("attachmentids", attachmentidsarray);
            resultObject.put("data", object);

            if (!"".equals(content.getStringValue("ownertable")) && content.getLongValue("ownerid") > 0 && !"".equals(content.getString("usetype"))) {
                /**
                 * 如果包含此3个字段，则默认创建数据绑定
                 */
                content.put("attachmentids", attachmentidsarray);
                Attachment attachment = new Attachment(content);
                attachment.createFileLink();
                resultObject.put("attinfos", attachment.queryFileLink());
            }
        } catch (Exception exception) {
            exception.printStackTrace();
            resultObject.put("code", 0);
            resultObject.put("msg", exception.getMessage());
        }
        return resultObject.toString();
    }

    @API(title = "华为云批量上传成功反馈", apiversion = R.ID10020001.v1.class)
    public String uploadSuccesses() throws YosException {
        JSONArray obsfilenamesArray = content.getJSONArray("serialfilenames");

        Iterator it = obsfilenamesArray.iterator();

        ArrayList<String> SQLlist = new ArrayList<>();

        JSONArray attachmentidsarray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        while (it.hasNext()) {
            String obsfilename = (String) it.next();
            if (!obsfilemap.containsKey(obsfilename)) {
                continue;
            }
            String filename = obsfilemap.get(obsfilename).get("filename");
            String filetype = obsfilemap.get(obsfilename).get("filetype");
            String parentid = obsfilemap.get(obsfilename).get("parentid");//父级文件夹id

            filename = filename.replace("'", "");
            try {

                BucketFile bucketFile = new BucketFile(siteid);
                if (!bucketFile.doesObjectExist(obsfilename)) {
                    continue;
                }

                /**
                 * 视频转码
                 */
                String mpctaskid = "null";
                String thumbnail_serialfilename = createMD5FileName() + ".jgp";
                boolean thumbnail_succsed = false;
                if (isVideo(filetype)) {
                    MpcFactory mpcFactoryV2 = new MpcFactory();
                    MediaMetaData data = mpcFactoryV2.getMetaData(siteid, obsfilename);
                    if (Parameter.get("attachment_huawei_obs_mpc").equalsIgnoreCase("true")) {
                        if (filetype.equalsIgnoreCase("mp4")) {
                            if (data != null) {
                                long bitrate = data.getBitrate();
                                long size = data.getSize();
                                if (bitrate / 1024 > 5000 || size / (1024 * 1024) > 500) {
                                    mpctaskid = mpcFactoryV2.createTranscodingTask(siteid, obsfilename);
                                }
                            }
                        } else if (filetype.equalsIgnoreCase("mov")) {
                            mpctaskid = mpcFactoryV2.createTranscodingTask(siteid, obsfilename);
                        }
                    }
                    thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(siteid, obsfilename, thumbnail_serialfilename, data.getWidth(), data.getHeight(), 1);
                }
                /**
                 * 本地信息插入
                 */
                long attachmentid = createTableID("sys_attachment");

                {
                    SQLFactory sqlFactory = new SQLFactory(this, "附件信息插入");
                    sqlFactory.addParameter("parentid", (parentid.equals("") || parentid.equals("0")) ? "null" : parentid);
                    sqlFactory.addParameter("attachmentid", attachmentid);
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("createby", username);
                    sqlFactory.addParameter("type", "sourcefile");
                    sqlFactory.addParameter("postfix", filetype);
                    sqlFactory.addParameter("serialnumber", obsfilename);
                    sqlFactory.addParameter("document", filename);
                    sqlFactory.addParameter("url", bucketFile.getFileUrl(obsfilename));
                    sqlFactory.addParameter("mpctaskid", mpctaskid);
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(obsfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                if (isVideo(filetype) && thumbnail_succsed) {
                    /**
                     * 生成视频文件封面图
                     */
                    SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                    sqlFactory.addParameter("parentid", attachmentid);
                    sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                    sqlFactory.addParameter("siteid", siteid);
                    sqlFactory.addParameter("createby", username);
                    sqlFactory.addParameter("type", "cover");
                    sqlFactory.addParameter("postfix", "jpg");
                    sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
                    sqlFactory.addParameter("document", thumbnail_serialfilename);
                    sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
                    sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());
                    SQLlist.add(sqlFactory.getSQL());
                }
                if (isImage(filetype)) {
                    {
                        //生成缩略图附件信息
                        SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                        sqlFactory.addParameter("parentid", attachmentid);
                        sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                        sqlFactory.addParameter("siteid", siteid);
                        sqlFactory.addParameter("createby", username);
                        sqlFactory.addParameter("type", "thumbnail");
                        sqlFactory.addParameter("postfix", filetype);
                        sqlFactory.addParameter("serialnumber", "s_" + obsfilename);
                        sqlFactory.addParameter("document", filename);
                        sqlFactory.addParameter("url", bucketFile.getMinImageUrl(obsfilename));
                        sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("s_" + obsfilename).getContentLength());
                        SQLlist.add(sqlFactory.getSQL());
                    }
                    {
                        /**
                         * 生成压缩图附件信息
                         */
                        SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
                        sqlFactory.addParameter("parentid", attachmentid);
                        sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
                        sqlFactory.addParameter("siteid", siteid);
                        sqlFactory.addParameter("createby", username);
                        sqlFactory.addParameter("type", "compressed");
                        sqlFactory.addParameter("postfix", filetype);
                        sqlFactory.addParameter("serialnumber", "c_" + obsfilename);
                        sqlFactory.addParameter("document", filename);
                        sqlFactory.addParameter("url", bucketFile.getCompressImageUrl(obsfilename));
                        sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata("c_" + obsfilename).getContentLength());
                        SQLlist.add(sqlFactory.getSQL());
                    }
                }
                obsfilemap.remove(obsfilename);
                bucketFile.close();
                attachmentidsarray.add(attachmentid);
            } catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        dbConnect.runSqlUpdate(SQLlist);
        JSONObject object = new JSONObject();
        object.put("attachmentids", attachmentidsarray);
        resultObject.put("data", object);

        int filecount = obsfilenamesArray.size();
        if (filecount == SQLlist.size()) {
            resultObject.put("code", 1);
            resultObject.put("msg", "成功上传" + filecount + "个文件");
        } else if (filecount > SQLlist.size() && SQLlist.size() > 0) {
            resultObject.put("code", 1);
            resultObject.put("msg", "成功上传" + SQLlist.size() + "个文件,失败" + (filecount - SQLlist.size() + "个"));
        } else if (SQLlist.size() == 0) {
            resultObject.put("code", 0);
            resultObject.put("msg", "上传失败");
        }
        if (!"".equals(content.getString("ownertable")) && content.getLongValue("ownerid") > 0 && !"".equals(content.getString("usetype"))) {
            /**
             * 如果包含此3个字段，则默认创建数据绑定
             */
            content.put("attachmentids", attachmentidsarray);
            Attachment attachment = new Attachment(content);
            try {
                attachment.createFileLink();
            } catch (Exception e) {
                e.printStackTrace();
            }
            resultObject.put("attinfos", attachment.queryFileLink());
        }
        return resultObject.toString();
    }

    /**
     * 获取压缩文件路径
     *
     * @return
     */
    @API(title = "获取华为云文件夹下载路径", apiversion = R.ID10020101.v1.class)
    public String createAndGetPackFileUrl() throws YosException {
        String url = "";
        long folderid = content.getLong("attachmentid");//文件夹附件ID
        Rows folderrows = dbConnect.runSqlQuery("select * from sys_attachment where siteid='" + siteid + "' and isfolder=1 and attachmentid='" + folderid + "'");
        if (folderrows.isNotEmpty()) {
            String foldername = folderrows.get(0).getString("document");
            String packfilepath = "cacheFiles/" + Calendar.getInstance().getTimeInMillis() + "/" + foldername + ".zip";//压缩文件存放路径
            /**
             * 获取所有子附件id
             */
            SQLFactory sqlFactory = new SQLFactory(this, "文件夹内附件信息查询");
            sqlFactory.addParameter("attachmentid", folderid);
            sqlFactory.addParameter("siteid", siteid);
            Rows subrows = dbConnect.runSqlQuery(sqlFactory.getSQL());

            JSONArray filesArray = new JSONArray();
            HashMap<String, String> filenamemap = new HashMap<>();
            for (Row subrow : subrows) {
                String document = subrow.getString("document");
                String serialnumber = subrow.getString("serialnumber");
                String attachmentid = subrow.getString("attachmentid");
                String parentid = subrow.getString("parentid");
                boolean isfolder = subrow.getBoolean("isfolder");
                if (Long.parseLong(parentid) == folderid || !filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, document);
                } else if (filenamemap.containsKey(parentid)) {
                    filenamemap.put(attachmentid, filenamemap.get(parentid) + "/" + document);
                }
                if (!isfolder) {
                    JSONObject fileObject = new JSONObject();
                    fileObject.put("filepath", serialnumber);
                    fileObject.put("packpath", filenamemap.get(attachmentid));
                    filesArray.add(fileObject);
                }
            }
            url = new BucketFile(siteid).getPackFileUrl(packfilepath, filesArray);
        }
        return getSucReturnObject().addKeyValue("url", url).toString();
    }


    private boolean isImage(String filetype) {
        String[] imagetypes = new String[]{"JPG", "JPEG", "PNG"};
        for (String imagetype : imagetypes) {
            if (filetype.equalsIgnoreCase(imagetype)) {
                return true;
            }
        }
        return false;
    }

    private boolean isVideo(String filetype) {
        String[] videotypes = new String[]{"mp4", "mov", "m4v", "3gp", "mkv", "rm", "rmvb", "wmv", "mpg", "avi", "mpeg"};
        for (String videotype : videotypes) {
            if (filetype.equalsIgnoreCase(videotype)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 为指定的视频附件生成一个视频截图
     *
     * @return
     * @throws YosException
     */
    @API(title = "为指定的视频附件生成一个视频封面截图", apiversion = R.ID10020201.v1.class)
    public String createthumbnail() throws YosException {
        long attachmentid = content.getLong("attachmentid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_attachment where siteid='" + siteid + "' and attachmentid=" + attachmentid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到id为" + attachmentid + "的视频附件信息").toString();
        }
        String serialnumber = rows.get(0).getString("serialnumber");
        BucketFile bucketFile = new BucketFile(siteid);
        if (!bucketFile.doesObjectExist(serialnumber)) {
            return getErrReturnObject().setErrMsg("OBS中找不到对应的视频文件").toString();
        }

        String thumbnail_serialfilename = createMD5FileName() + ".jpg";
        MpcFactory mpcFactoryV2 = new MpcFactory();
        MediaMetaData mediaMetaData = mpcFactoryV2.getMetaData(siteid, serialnumber);

        boolean thumbnail_succsed = mpcFactoryV2.createThumbnailsTask(siteid, serialnumber, thumbnail_serialfilename, mediaMetaData.getWidth(), mediaMetaData.getHeight(), 1);
        if (thumbnail_succsed) {
            /**
             * 生成视频文件封面图
             */
            SQLFactory sqlFactory = new SQLFactory(this, "子附件信息插入");
            sqlFactory.addParameter("parentid", attachmentid);
            sqlFactory.addParameter("attachmentid", createTableID("sys_attachment"));
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("createby", username);
            sqlFactory.addParameter("type", "cover");
            sqlFactory.addParameter("postfix", "jpg");
            sqlFactory.addParameter("serialnumber", thumbnail_serialfilename);
            sqlFactory.addParameter("document", thumbnail_serialfilename);
            sqlFactory.addParameter("url", bucketFile.getFileUrl(thumbnail_serialfilename));
            sqlFactory.addParameter("contentlength", bucketFile.getObjectMetadata(thumbnail_serialfilename).getContentLength());

            dbConnect.runSqlUpdate(sqlFactory.getSQL());
            return getSucReturnObject().setData(getAttachmentUrl(attachmentid).getRow(0)).toString();
        } else {
            return getErrReturnObject().toString();
        }
    }


}
