package restcontroller.sysmanage.develop.datafunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import restcontroller.R;

import java.util.Iterator;

public class datafunction extends Controller {
    public datafunction(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统函数注册查询", apiversion = R.ID10009101.v1.class)
    public String queryFunctionList() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.functionname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.type like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.sqlstr like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("type") && !"".equals(whereObject.getString("type"))) {
                where.append(" and(");
                where.append("t1.type ='").append(whereObject.getString("type")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("isused") && !"".equals(whereObject.getString("isused"))) {
                where.append(" and(");
                where.append("t1.isused ='").append(whereObject.getString("isused")).append("' ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "函数列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统函数注册", apiversion = R.ID10009201.v1.class)
    public String insertormodifyFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        String functionname = content.getString("functionname");
        String type = content.getString("type");
        String datakey = content.getString("datakey");
        boolean queryforpage = content.getBooleanValue("queryforpage");
        String sqlstr = content.getString("sqlstr", true);
        Object params = JSON.toJSON(getSQLParams(sqlstr));

        String remarks = content.getString("remarks");
        if (sys_datafunctionid <= 0 || dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_datafunction");
            insertSQL.setValue("sys_datafunctionid", createTableID("sys_datafunction"));
            insertSQL.setValue("functionname", functionname);
            insertSQL.setValue("type", type);
            insertSQL.setValue("queryforpage", queryforpage);
            insertSQL.setValue("sqlstr", sqlstr);
            insertSQL.setValue("remarks", remarks);
            insertSQL.setValue("params", params);
            insertSQL.setValue("datakey", datakey);
            insertSQL.setDateValue("createdate");
            insertSQL.insert();
        } else {
            UpdateSQL rowUpdate = SQLFactory.createUpdateSQL(this, "sys_datafunction");
            rowUpdate.setValue("sqlstr", sqlstr);
            rowUpdate.setValue("remarks", remarks);
            rowUpdate.setValue("queryforpage", queryforpage);
            rowUpdate.setValue("params", params);
            rowUpdate.setValue("datakey", datakey);
            rowUpdate.setWhere("sys_datafunctionid", sys_datafunctionid);
            rowUpdate.update();
        }
        return getSucReturnObject().toString();
    }

    @API(title = "系统函数删除", apiversion = R.ID10009301.v1.class)
    public String deleteFunction() throws YosException {
        long sys_datafunctionid = content.getLong("sys_datafunctionid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("系统函数不存在").toString();
        } else if (rows.get(0).getBoolean("isused")) {
            return getErrReturnObject().setErrMsg("系统函数已被使用").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_datafunction where sys_datafunctionid=" + sys_datafunctionid);
        return getSucReturnObject().toString();
    }

    @API(title = "函数执行", apiversion = R.ID10009401.v1.class)
    public String execute() throws YosException {
        String functionname = content.getString("functionname");
        Rows rows = dbConnect.runSqlQuery("select * from sys_datafunction where functionname='" + functionname + "'");
        if (rows.isEmpty()) {
            JSONArray array = new JSONArray();
            array.add(new JSONObject());
            return getSucReturnObject().setData(array).toString();
        }
        if (!rows.get(0).getBoolean("isused")) {
            dbConnect.runSqlUpdate("update sys_datafunction set isused=1 where functionname='" + functionname + "'");
        }
        String type = rows.get(0).getString("type");
        String sql = rows.get(0).getString("sqlstr");
        String datakey = rows.get(0).getString("datakey");

        if (content.containsKey("parameter")) {
            JSONObject parameterObject = content.getJSONObject("parameter");
            Iterator<String> it = parameterObject.keySet().iterator();
            while (it.hasNext()) {
                String parameter = it.next();
                String value = String.valueOf(parameterObject.get(parameter));
                String sqlkey = "$" + parameter + "$";
                if (value == null || "null".equalsIgnoreCase(value)) {
                    sql = sql.replace(sqlkey, "NULL");
                } else {
                    sql = sql.replace(sqlkey, "'" + value + "'");
                }
            }
        }
        sql = sql.replaceAll("(?i):sys_enterpriseid", "'" + sys_enterpriseid + "'");
        sql = sql.replaceAll("(?i):userid", "'" + userid + "'");
        sql = sql.replaceAll("(?i):hrid", "'" + hrid + "'");
        sql = sql.replaceAll("(?i):departmentid", "'" + departmentid + "'");
        sql = sql.replaceAll("(?i):siteid", "'" + siteid + "'");

        if (datakey.equals("") || datakey.equalsIgnoreCase("default")) {
            if (type.equals("query")) {
                Rows datarows;
                if (rows.get(0).getBoolean("queryforpage")) {
                    SQLFactory sqlFactory = new SQLFactory("sql:" + sql, pageSize, pageNumber, "");
                    datarows = dbConnect.runSqlQuery(sqlFactory.getSQL());
                } else {
                    datarows = dbConnect.runSqlQuery(sql);
                }
                return getSucReturnObject().setData(datarows).toString();
            } else if (type.equals("update")) {
                int rowcount = dbConnect.runSqlUpdate(sql);
                return getSucReturnObject().setData(rowcount).toString();
            }
        } else if (datakey.equalsIgnoreCase("sqliteCache")) {
            if (type.equals("query")) {
                Rows datarows = SQLiteMemory.runSqlQuery(sql);
                return getSucReturnObject().setData(datarows).toString();
            } else if (type.equals("update")) {
                int rowcount = SQLiteMemory.runSqlUpdate(sql);
                return getSucReturnObject().setData(rowcount).toString();
            }
        } else {
            if (type.equals("query")) {
                Rows datarows;
                if (rows.get(0).getBoolean("queryforpage")) {
                    SQLFactory sqlFactory = new SQLFactory("sql:" + sql, pageSize, pageNumber, "");
                    datarows = new DBConnect(datakey).runSqlQuery(sqlFactory.getSQL());
                } else {
                    datarows = new DBConnect(datakey).runSqlQuery(sql);
                }
                return getSucReturnObject().setData(datarows).toString();
            } else if (type.equals("update")) {
                int rowcount = new DBConnect(datakey).runSqlUpdate(sql);
                return getSucReturnObject().setData(rowcount).toString();
            }
        }
        return getErrReturnObject().setErrMsg("没有可执行的函数").toString();
    }
}
