/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import common.parameter.properties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;

public class DBConnectPool {
    public static HashMap<String, Properties> propertiesMap = new HashMap();
    public static final HashMap<String, LinkedList<Connection>> POOLS_MAP = new HashMap();
    private static int day = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnect(String datakey) {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            Connection connection = null;
            if (POOLS_MAP.containsKey(datakey) && POOLS_MAP.get(datakey).size() > 0) {
                connection = POOLS_MAP.get(datakey).remove(0);
            }
            try {
                if (connection == null || connection.isClosed()) {
                    connection = this.buildConnect(datakey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int n = day;
            day = Calendar.getInstance().get(5);
            if (n != day) {
                this.clean();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return connection;
        }
    }

    private Properties getDataSource(String datakey) throws YosException {
        Properties prop = new Properties();
        switch (datakey) {
            case "default": {
                return properties.getYosProperties();
            }
        }
        DBConnect dbConnect = new DBConnect();
        String sql = "select driver,username,password,url from sys_datasource where datakey='" + datakey + "'";
        Rows rows = dbConnect.runSqlQuery(sql);
        if (rows.isEmpty()) {
            return null;
        }
        prop.setProperty("system.db.driver", rows.get(0).getString("driver"));
        prop.setProperty("system.db.username", rows.get(0).getString("username"));
        prop.setProperty("system.db.password", rows.get(0).getString("password"));
        prop.setProperty("system.db.url", rows.get(0).getString("url"));
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection buildConnect(String datakey) throws YosException {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            Properties prop;
            Connection conn = null;
            if (!propertiesMap.containsKey(datakey) && (prop = this.getDataSource(datakey)) != null && !prop.isEmpty()) {
                propertiesMap.put(datakey, prop);
            }
            Properties p = propertiesMap.get(datakey);
            try {
                Class.forName(p.getProperty("system.db.driver"));
                conn = DriverManager.getConnection(p.getProperty("system.db.url"), p.getProperty("system.db.username"), p.getProperty("system.db.password"));
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new YosException("\u521b\u5efa" + datakey + "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
            }
            return conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String datakey, Connection conn) {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            boolean isclose = true;
            try {
                isclose = conn.isClosed();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                System.err.println(datakey + "\u8fde\u63a5\u5173\u95ed\u5931\u8d25" + this.getDateTime_Str() + e1.getMessage());
            }
            if (!isclose) {
                if (!POOLS_MAP.containsKey(datakey)) {
                    LinkedList list = new LinkedList();
                    POOLS_MAP.put(datakey, list);
                }
                if (POOLS_MAP.get(datakey).size() <= 75) {
                    POOLS_MAP.get(datakey).add(conn);
                } else {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        System.err.println(datakey + "\u8fde\u63a5\u5173\u95ed\u5931\u8d25" + this.getDateTime_Str() + e.getMessage());
                    }
                    finally {
                        conn = null;
                    }
                }
            } else {
                conn = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Class<DBConnectPool> clazz = DBConnectPool.class;
        synchronized (DBConnectPool.class) {
            Set<String> set = POOLS_MAP.keySet();
            for (String datakey : set) {
                while (POOLS_MAP.get(datakey).size() > 5) {
                    try {
                        Connection connection = POOLS_MAP.get(datakey).remove(0);
                        if (connection == null || connection.isClosed()) continue;
                        connection.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getDateTime_Str() {
        return BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime());
    }
}

