/*
 * Decompiled with CFR 0.152.
 */
package common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.SQLProcess;
import common.data.db.DBConnect;
import common.data.db.SQLLog;
import common.parameter.parameter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import utility.tools.GetPinYin;

public class BaseClass {
    public DBConnect dbConnect = new DBConnect();
    public Date sysdate = BaseClass.getDateTime();
    public static SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static HashMap<String, Long> tableidmap = new HashMap();
    private static HashMap<String, String> uniquecolumnnamemap = new HashMap();
    private static ArrayList<String> tableuniquecolumnnameList = new ArrayList();
    private static HashMap<String, ArrayList<String>> TableColumnNamesMaps = new HashMap();
    public static HashMap<String, HashMap<String, String>> ColumnTypeMap = new HashMap();
    private static HashMap<String, String> column_titleMaps = new HashMap();
    private static HashMap<String, Boolean> siteTableMap = new HashMap();
    private static HashMap<Long, ArrayList<Long>> imdialog_usermap = new HashMap();

    public ArrayList<SQLLog> getSQLLog() {
        ArrayList<SQLLog> list = new ArrayList<SQLLog>(this.dbConnect.getSqlLogList());
        this.dbConnect.clearSqlLogList();
        return list;
    }

    public static String getWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 1);
        calendar.set(5, calendar.get(5) + 1);
        return dateFormat.format(calendar.getTime());
    }

    public static String getWeekLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 7);
        calendar.set(5, calendar.get(5) + 1);
        return dateFormat.format(calendar.getTime());
    }

    public static String getMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return dateFormat.format(calendar.getTime());
    }

    public static String getMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        return dateFormat.format(calendar.getTime());
    }

    public static String getDate_Str() {
        Calendar calendar = Calendar.getInstance();
        return dateFormat.format(calendar.getTime());
    }

    public static String getDate_Str(int margin) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, margin);
        return dateFormat.format(calendar.getTime());
    }

    public static String getDate_Str(Date date) {
        return dateFormat.format(date.getTime());
    }

    public static String getDate_Str(Long imeinmillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(imeinmillis);
        return dateFormat.format(calendar.getTime());
    }

    public static Date getDateTime() {
        return Calendar.getInstance().getTime();
    }

    public static Date getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getDateTime_Str() {
        Calendar calendar = Calendar.getInstance();
        return dateTimeFormat.format(calendar.getTime());
    }

    public static String getDateTime_Str(Date date) {
        return dateTimeFormat.format(date.getTime());
    }

    public static String getDateTime_Str(Long imeinmillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(imeinmillis);
        return dateTimeFormat.format(calendar.getTime());
    }

    public String nullToStr(String str) {
        if (null == str || "null".equalsIgnoreCase(str)) {
            return "";
        }
        return str;
    }

    public boolean isJSONObject(String jsonStr) {
        try {
            Object object = JSON.parse((String)jsonStr);
            return object instanceof JSONObject;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isJSONArray(String jsonStr) {
        try {
            Object object = JSON.parse((String)jsonStr);
            return object instanceof JSONArray;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long createTableID(String table_name) throws YosException {
        return this.createTableID(table_name, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] createTableID(String table_name, int count) throws YosException {
        Class<Controller> clazz = Controller.class;
        synchronized (Controller.class) {
            table_name = table_name.toLowerCase();
            String fieldname = this.getuniquecolumnname(table_name);
            if (!tableidmap.containsKey(table_name)) {
                Rows tablemaxidrows = new DBConnect().runSqlQuery("select ifnull(max(" + fieldname + "),0) as " + fieldname + " from " + table_name);
                long maxtableid = tablemaxidrows.get(0).getLong(fieldname);
                Rows objectmaxidrows = new DBConnect().runSqlQuery("select ifnull(uniquecolumnmaxid,1)as uniquecolumnmaxid from sys_object where table_name='" + table_name + "'");
                long maxobjectid = maxtableid == 0L ? 0L : objectmaxidrows.get(0).getLong("uniquecolumnmaxid");
                tableidmap.put(table_name, Math.max(maxtableid, maxobjectid));
            }
            tableidmap.put(table_name, tableidmap.get(table_name) + (long)count);
            this.dbConnect.runSqlUpdate("update sys_object set uniquecolumnmaxid=" + tableidmap.get(table_name) + " where table_name='" + table_name + "'");
            long firstid = tableidmap.get(table_name) - (long)count + 1L;
            long[] ids = new long[count];
            for (int index = 0; index < count; ++index) {
                ++firstid;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ids;
        }
    }

    public void tableidmapClean(String table_name) {
        if (tableidmap.containsKey(table_name)) {
            tableidmap.remove(table_name);
        }
    }

    public String getuniquecolumnname(String table_name) throws YosException {
        if (!uniquecolumnnamemap.containsKey(table_name = table_name.toLowerCase())) {
            SQLFactory sqlFactory = new SQLFactory("\u8868ID\u5b57\u6bb5\u67e5\u8be2");
            sqlFactory.addParameter("table_name", table_name);
            Rows rows = new DBConnect().runSqlQuery(sqlFactory);
            for (Row row : rows) {
                uniquecolumnnamemap.put(row.getString("table_name").toLowerCase(), row.getString("uniquecolumnname").toLowerCase());
            }
        }
        return uniquecolumnnamemap.get(table_name);
    }

    public static boolean isTableUniqueColumnName(String key) {
        try {
            if (tableuniquecolumnnameList.isEmpty()) {
                tableuniquecolumnnameList = new DBConnect().runSqlQuery("select LOWER(uniquecolumnname)as uniquecolumnname from sys_object where ifnull(uniquecolumnname,'')!=''").toArrayList("uniquecolumnname");
                tableuniquecolumnnameList.add("ownerid");
                tableuniquecolumnnameList.add("sourceid");
            }
            return tableuniquecolumnnameList.contains(key.toLowerCase());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getdataversioncolumnname(String table_name) {
        return table_name + "_v";
    }

    public Row getUser(long userid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select  * from sys_users where userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    public RowsMap getUser(long[] userids) throws YosException {
        StringBuilder where = new StringBuilder("''");
        for (long userid : userids) {
            where.append(",'").append(userid).append("'");
        }
        return this.dbConnect.runSqlQuery("select  * from sys_users where userid in(" + where + ")").toRowsMap("userid");
    }

    public boolean isTableExists(String table_name) throws YosException {
        return this.dbConnect.runSqlQuery("select *from sys_object where table_name='" + table_name + "'").isNotEmpty();
    }

    public boolean isTable_ColumnExists(String table_name, String column_name) throws YosException {
        return this.dbConnect.runSqlQuery("select *from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'").isNotEmpty();
    }

    public RowsMap getTableColumns(String tablename) throws YosException {
        tablename = tablename.toLowerCase();
        Rows rows = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + tablename + "'");
        return rows.toRowsMap("column_name");
    }

    public ArrayList<String> getTableColumnNames(String tablename) throws YosException {
        if (!TableColumnNamesMaps.containsKey(tablename)) {
            TableColumnNamesMaps.put(tablename, this.dbConnect.runSqlQuery("select column_name from sys_objectcols where table_name='" + tablename + "'").toArrayList("column_name"));
        }
        return TableColumnNamesMaps.get(tablename);
    }

    public void cleanTableColumnNamesMaps(String tablename) {
        TableColumnNamesMaps.remove(tablename);
    }

    public String getColumnType(String table_name, String column_name) throws YosException {
        Rows rows;
        if (!ColumnTypeMap.containsKey(table_name)) {
            HashMap map = new HashMap();
            ColumnTypeMap.put(table_name, map);
        }
        if (!ColumnTypeMap.get(table_name).containsKey(column_name) && (rows = this.dbConnect.runSqlQuery("select column_type from sys_objectcols where table_name='" + table_name + "' and column_name='" + column_name + "'")).isNotEmpty()) {
            ColumnTypeMap.get(table_name).put(column_name, rows.get(0).getString("column_type").toLowerCase());
        }
        return ColumnTypeMap.get(table_name).getOrDefault(column_name, "varchar");
    }

    public String getTableColumnTitle(String tablename, String column_name) throws YosException {
        Rows rows;
        String key = tablename + "&" + column_name;
        if (!column_titleMaps.containsKey(key) && (rows = this.dbConnect.runSqlQuery("select column_title from sys_objectcols where table_name='" + tablename + "' and column_name='" + column_name + "'")).isNotEmpty()) {
            column_titleMaps.put(key, rows.get(0).getString("column_title"));
        }
        return column_titleMaps.getOrDefault(key, "\u672a\u77e5");
    }

    public void cleanTableColumnTitle(String tablename, String column_name) {
        String key = tablename + "&" + column_name;
        column_titleMaps.remove(key);
    }

    public boolean isSiteTable(String tablename) throws YosException {
        if (siteTableMap.containsKey(tablename)) {
            return siteTableMap.get(tablename);
        }
        boolean issiteid = this.getTableColumns(tablename).containsKey("siteid");
        siteTableMap.put(tablename, issiteid);
        return issiteid;
    }

    public String getTableName(String tablename) throws YosException {
        tablename = tablename.toLowerCase();
        Rows rows = this.dbConnect.runSqlQuery("select table_comment from sys_object where table_name='" + tablename + "'");
        return rows.isEmpty() ? "" : rows.get(0).getString("table_comment");
    }

    public Date getLoginDate(long usersiteid) {
        return parameter.loginDate.getOrDefault(usersiteid, BaseClass.getDateTime());
    }

    public HashMap<String, String> getOptionType(String typename) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select t2.value,t2.remarks from sys_optiontype t1 inner join sys_optiontypemx t2 on t1.optiontypeid = t2.optiontypeid where t1.typename='" + typename + "'");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Row row : rows) {
            map.put(row.getString("value"), row.getString("remarks"));
        }
        return map;
    }

    public void loguserout(long userid) throws YosException {
        ArrayList<String> usersiteids = this.dbConnect.runSqlQuery("select usersiteid from sys_usersite where userid=" + userid).toArrayList("usersiteid");
        for (String id : usersiteids) {
            long usersiteid = Long.parseLong(id);
            if (!parameter.usersiteIdList.containsKey(usersiteid)) continue;
            String token = parameter.usersiteIdList.get(usersiteid).getString("token");
            parameter.tokenlist.remove(token);
            parameter.tokenendtimemillis.remove(token);
            parameter.tokenSessionidlist.remove(token);
            SQLProcess.cleanPool(token);
            QuerySQL.cleanDataLimitRowsMapPool(token);
        }
        this.dbConnect.runSqlUpdate("update sys_usersite set accesstoken=null,systemclient=null where userid='" + userid + "'");
    }

    public void logroleout(long roleid, Long excludeuserid) throws YosException {
        ArrayList<String> useridlist = this.dbConnect.runSqlQuery("select userid from sys_userrole where roleid=" + roleid).toArrayList("userid");
        for (String id : useridlist) {
            if (id.equals(String.valueOf(excludeuserid))) continue;
            this.loguserout(Long.parseLong(id));
        }
    }

    public String makeFillCode(int length, long num) {
        String code = "";
        String num_str = String.valueOf(num);
        code = length - num_str.length() > 0 ? String.format("%0" + length + "d", Integer.valueOf(num_str)) : num_str;
        return code;
    }

    public String makeFillCode(int length, int num) {
        return this.makeFillCode(length, (long)num);
    }

    public Row getHr(long userid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select  * from sys_hr where siteid='" + siteid + "' and userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    public Row getDepartment(long userid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select  t2.* from sys_hr t1 inner join sys_department t2 on t1.siteid=t2.siteid and t1.departmentid=t2.departmentid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    public Row getEnterpriseByUserid(long userid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select  t2.* from sys_enterprise_hr t1 inner join sys_enterprise t2 on t1.siteid=t2.siteid and t1.sys_enterpriseid=t2.sys_enterpriseid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    public Row getEnterpriseHr(long userid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select t1.*,t2.accountno from sys_enterprise_hr t1 inner join sys_users t2 on t2.userid = t1.userid where t1.siteid='" + siteid + "' and t1.userid=" + userid);
        return rows.isEmpty() ? new Row() : rows.get(0);
    }

    public Rows getEnterpriseHrs(long sys_enterpriseid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select t1.*,t2.accountno from sys_enterprise_hr t1 inner join sys_users t2 on t2.userid = t1.userid where t1.siteid='" + siteid + "' and t1.sys_enterpriseid=" + sys_enterpriseid + " order by t1.isleader desc");
        return rows;
    }

    public ArrayList<Long> getImDialogUserIds(long timdialogid, String siteid) throws YosException {
        if (!imdialog_usermap.containsKey(timdialogid)) {
            Rows rows = this.dbConnect.runSqlQuery("select userid from timdialogusers where siteid='" + siteid + "' and timdialogid='" + timdialogid + "' and fisremove=0");
            ArrayList<Long> list = new ArrayList<Long>();
            for (Row row : rows) {
                list.add(row.getLong("userid"));
            }
            imdialog_usermap.put(timdialogid, list);
        }
        return imdialog_usermap.get(timdialogid);
    }

    public long getUserSiteId(long userid, String siteid) throws YosException {
        Rows rows = this.dbConnect.runSqlQuery("select usersiteid from sys_usersite where siteid='" + siteid + "' and userid=" + userid);
        if (rows.isNotEmpty()) {
            return rows.get(0).getLong("usersiteid");
        }
        return 0L;
    }

    public <T> T[] array_Invert(T[] t) {
        int length = t.length;
        Object[] os = new Object[length];
        for (int i = 0; i < length; ++i) {
            os[i] = t[i];
        }
        for (Object o : os) {
            t[--length] = o;
        }
        return t;
    }

    public String createMD5FileName() {
        Date date = new Date();
        String date_str = new SimpleDateFormat("yyyyMMdd").format(date);
        long time = date.getTime();
        int random = Math.abs(new Random().nextInt() % 1000);
        String var3 = null;
        try {
            var3 = MessageDigest.getInstance("MD5").digest(String.valueOf(random).getBytes()).toString().replaceAll("[^a-z^A-Z^0-9]", "");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return date_str + time + var3;
    }

    public String getPinYin(String chinese, boolean isfirstchar, HanyuPinyinCaseType hanyuPinyinCaseType) {
        return GetPinYin.Get(chinese, isfirstchar, hanyuPinyinCaseType);
    }

    public boolean idCard_validate(String idcardno) {
        int[] PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        int[] POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        if (idcardno == null || idcardno.length() != 15 && idcardno.length() != 18) {
            return false;
        }
        char[] cs = idcardno.toUpperCase().toCharArray();
        int power = 0;
        for (int i = 0; i < cs.length && (i != cs.length - 1 || cs[i] != 'X'); ++i) {
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i >= cs.length - 1) continue;
            power += (cs[i] - 48) * POWER_LIST[i];
        }
        if (idcardno.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createBillCode(String siteid, String coderuletype) throws YosException {
        Class<BaseClass> clazz = BaseClass.class;
        synchronized (BaseClass.class) {
            String billcode;
            SQLFactory sitecoderulesquerySQl = new SQLFactory("\u7ad9\u70b9\u7f16\u7801\u89c4\u5219\u67e5\u8be2");
            sitecoderulesquerySQl.addParameter("siteid", siteid);
            sitecoderulesquerySQl.addParameter("coderuletype", coderuletype);
            Rows sitecoderules = this.dbConnect.runSqlQuery(sitecoderulesquerySQl.getSQL());
            if (sitecoderules.isEmpty()) {
                SQLFactory sitecoderulequerySQl = new SQLFactory("\u7f16\u7801\u89c4\u5219\u67e5\u8be2");
                sitecoderulequerySQl.addParameter("coderuletype", coderuletype);
                Rows coderule2 = this.dbConnect.runSqlQuery(sitecoderulequerySQl.getSQL());
                if (coderule2.size() != 1) {
                    throw new YosException("\u7f16\u7801\u89c4\u5219\u67e5\u8be2\u9519\u8bef\uff01");
                }
                SQLFactory sitecoderulesinsertSQl = new SQLFactory("\u7ad9\u70b9\u7f16\u7801\u89c4\u5219\u63d2\u5165");
                sitecoderulesinsertSQl.addParameter("siteid", siteid);
                sitecoderulesinsertSQl.addParameter("sys_coderuleid", coderule2.get(0).getLong("sys_coderuleid"));
                sitecoderulesinsertSQl.addParameter("sys_coderulesid", this.createTableID("sys_coderules"));
                sitecoderulesinsertSQl.addParameter("fixed", coderule2.get(0).getString("fixed"));
                sitecoderulesinsertSQl.addParameter("numlength", coderule2.get(0).getInteger("numlength"));
                sitecoderulesinsertSQl.addParameter("numincludetime", coderule2.get(0).getInteger("numincludetime"));
                sitecoderulesinsertSQl.addParameter("timeformat", coderule2.get(0).getString("timeformat"));
                this.dbConnect.runSqlUpdate(sitecoderulesinsertSQl.getSQL());
                sitecoderules = this.dbConnect.runSqlQuery(sitecoderulesquerySQl.getSQL());
            }
            if (sitecoderules.size() != 1) {
                throw new YosException("\u7f16\u7801\u89c4\u5219\u67e5\u8be2\u9519\u8bef\uff01");
            }
            long sys_coderulesid = sitecoderules.get(0).getLong("sys_coderulesid");
            String fixed = sitecoderules.get(0).getString("fixed");
            boolean fixedwithsiteid = sitecoderules.get(0).getBoolean("fixedwithsiteid");
            if (fixedwithsiteid) {
                fixed = fixed.equals("") ? siteid : siteid + "-" + fixed;
            }
            int numlength = sitecoderules.get(0).getInteger("numlength");
            boolean numincludetime = sitecoderules.get(0).getBoolean("numincludetime");
            if (numincludetime) {
                long serialnum;
                long sys_coderules_timeserialnumid;
                String timeformat = sitecoderules.get(0).getString("timeformat");
                String timestr = new SimpleDateFormat(timeformat).format(Calendar.getInstance().getTime());
                Rows timeserialnumsRows = this.dbConnect.runSqlQuery("select sys_coderules_timeserialnumid,serialnum from sys_coderules_timeserialnum where siteid='" + siteid + "' and sys_coderulesid='" + sys_coderulesid + "' and timestr='" + timestr + "'");
                if (timeserialnumsRows.isEmpty()) {
                    sys_coderules_timeserialnumid = this.createTableID("sys_coderules_timeserialnum");
                    SQLFactory sitecoderulestimeinsertSQl = new SQLFactory("\u7ad9\u70b9\u7f16\u7801\u89c4\u5219\u65f6\u95f4\u5e8f\u53f7\u8868\u63d2\u5165");
                    sitecoderulestimeinsertSQl.addParameter("siteid", siteid);
                    sitecoderulestimeinsertSQl.addParameter("sys_coderulesid", sys_coderulesid);
                    sitecoderulestimeinsertSQl.addParameter("sys_coderules_timeserialnumid", sys_coderules_timeserialnumid);
                    sitecoderulestimeinsertSQl.addParameter("timestr", timestr);
                    this.dbConnect.runSqlUpdate(sitecoderulestimeinsertSQl.getSQL());
                    serialnum = 0L;
                } else {
                    sys_coderules_timeserialnumid = timeserialnumsRows.get(0).getLong("sys_coderules_timeserialnumid");
                    serialnum = timeserialnumsRows.get(0).getLong("serialnum");
                }
                billcode = fixed + timestr + this.makeFillCode(numlength - timestr.length(), ++serialnum);
                this.dbConnect.runSqlUpdate("update sys_coderules_timeserialnum set serialnum=" + serialnum + " where sys_coderules_timeserialnumid=" + sys_coderules_timeserialnumid);
            } else {
                long serialnum = sitecoderules.get(0).getLong("serialnum");
                billcode = fixed + this.makeFillCode(numlength, ++serialnum);
                this.dbConnect.runSqlUpdate("update sys_coderules set serialnum=" + serialnum + " where sys_coderulesid=" + sys_coderulesid);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return billcode;
        }
    }

    public ArrayList<String> getSQLParams(String sql) {
        ArrayList<String> paramsList = new ArrayList<String>();
        StringBuilder param = new StringBuilder();
        boolean paramstart = false;
        for (char b : sql.toCharArray()) {
            if (b == '$' && !paramstart) {
                paramstart = true;
                continue;
            }
            if (b != '$' && paramstart) {
                param.append(b);
                continue;
            }
            if (b != '$' || !paramstart) continue;
            paramstart = false;
            paramsList.add(param.toString());
            param = new StringBuilder();
        }
        return paramsList;
    }

    public static enum FieldType {
        Varchar,
        Decimal,
        Int,
        BigInt,
        Smallint,
        Datetime,
        Date,
        Text,
        LongText,
        JSON;

    }

    public static enum JOINTYPE {
        inner,
        left,
        right;

    }
}

