/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import beans.parameter.Parameter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.YosException;
import common.data.Rows;
import common.data.db.DBConnect;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class EasyExcelFactory {
    private String filename;
    public static String filetype = "xlsx";

    public EasyExcelFactory(String filename) {
        this.filename = filename + Calendar.getInstance().getTimeInMillis();
    }

    public void write(String sheetname, Rows datarows) throws YosException {
        this.write(sheetname, datarows, new HashMap<String, String>());
    }

    public void write(String sheetname, Rows datarows, HashMap<String, String> titlemap) throws YosException {
        ArrayList titlelist = new ArrayList();
        for (String fieldname : datarows.getFieldList()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(titlemap.getOrDefault(fieldname, fieldname));
            titlelist.add(list);
        }
        String filepath = Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
        ArrayList<ArrayList<Object>> datalist = datarows.toListList();
        try (ExcelWriter excelWriter = EasyExcel.write((String)filepath).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetname).registerWriteHandler((WriteHandler)this.getStyle())).head(titlelist)).build();
            ArrayList<ArrayList<Object>> datalist_cache = new ArrayList<ArrayList<Object>>();
            int count = 1;
            for (ArrayList<Object> objects : datalist) {
                if (count <= 5000) {
                    datalist_cache.add(objects);
                }
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                ++count;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String sheetname, JSONArray exportFieldsArray, JSONArray dataArrays) throws YosException {
        ArrayList titlelist = new ArrayList();
        ArrayList<String> fieldlist = new ArrayList<String>();
        for (int i = 0; i < exportFieldsArray.size(); ++i) {
            JSONObject exportFieldObjet = exportFieldsArray.getJSONObject(i);
            ArrayList<String> list = new ArrayList<String>();
            list.add(exportFieldObjet.getStringValue("fieldlabel"));
            titlelist.add(list);
            fieldlist.add(exportFieldObjet.getStringValue("fieldname"));
        }
        String filepath = Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
        try (ExcelWriter excelWriter = EasyExcel.write((String)filepath).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetname).registerWriteHandler((WriteHandler)this.getStyle())).head(titlelist)).build();
            ArrayList datalist_cache = new ArrayList();
            int count = 1;
            for (Object dataObject : dataArrays) {
                ArrayList<Object> datarow = new ArrayList<Object>();
                for (String fieldname : fieldlist) {
                    datarow.add(((JSONObject)dataObject).getOrDefault(fieldname, ""));
                }
                datalist_cache.add(datarow);
                if (count == 5000) {
                    count = 0;
                    excelWriter.write(datalist_cache, writeSheet);
                    datalist_cache.clear();
                }
                ++count;
            }
            if (!datalist_cache.isEmpty()) {
                excelWriter.write(datalist_cache, writeSheet);
                datalist_cache.clear();
            }
        }
        finally {
            dataArrays.clear();
        }
    }

    private HorizontalCellStyleStrategy getStyle() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex()));
        headWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public String getFilename() {
        return this.filename + "." + filetype;
    }

    public String getFilepath() throws YosException {
        return Parameter.get("system_excelexport_path") + this.filename + "." + filetype;
    }

    public File getFile() throws YosException {
        return new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
    }

    public void deletefile() throws YosException {
        File file = new File(Parameter.get("system_excelexport_path") + this.filename + "." + filetype);
        file.delete();
    }

    public static void main(String[] args) throws YosException {
        Rows rows = new DBConnect().runSqlQuery("select * from sys_users");
        JSONArray titleArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("fieldlabel", (Object)"\u624b\u673a\u53f7");
        object.put("fieldname", (Object)"phonenumber");
        titleArray.add((Object)object);
        object = new JSONObject();
        object.put("fieldlabel", (Object)"\u7528\u6237id");
        object.put("fieldname", (Object)"userid");
        titleArray.add((Object)object);
        object = new JSONObject();
        object.put("fieldlabel", (Object)"\u7528\u6237\u72b6\u6001");
        object.put("fieldname", (Object)"status");
        titleArray.add((Object)object);
        object = new JSONObject();
        object.put("fieldlabel", (Object)"\u7528\u6237\u540d\u79f0");
        object.put("fieldname", (Object)"name");
        titleArray.add((Object)object);
        EasyExcelFactory easyExcelFactory = new EasyExcelFactory("asdsad");
        easyExcelFactory.write("aa", titleArray, rows.toJsonArray());
    }
}

