/**
 *
 */
package common.data.db;

import com.sun.management.OperatingSystemMXBean;
import common.BaseClass;
import common.YosException;
import common.YosLogger;
import common.data.Rows;
import common.parameter.License;
import common.parameter.properties;
import utility.tools.Math;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.*;
import java.util.*;

/**
 * @author SJW
 *
 */
public class DBConnectPool implements YosLogger {
    public static HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
    /**
     * 数据库连接池
     */
    public static final HashMap<String, LinkedList<YosConnection>> POOLS_MAP = new HashMap<String, LinkedList<YosConnection>>();

    public static HashMap<String, LinkedList<String>> useingConnectionkeyMap = new HashMap<>();

    public YosConnection getConnect(String datakey) {
        synchronized (DBConnectPool.class) {
            YosConnection yosconnection = null;
            if (POOLS_MAP.containsKey(datakey) && (POOLS_MAP.get(datakey).size()) > 0) {
                yosconnection = POOLS_MAP.get(datakey).remove(0);
            } else if (!POOLS_MAP.containsKey(datakey)) {
                POOLS_MAP.put(datakey, new LinkedList<>());
                useingConnectionkeyMap.put(datakey, new LinkedList<>());
            }
            try {
                if (yosconnection == null || yosconnection.getConnection() == null || yosconnection.getConnection().isClosed()) {
                    yosconnection = buildConnect(datakey);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            useingConnectionkeyMap.get(datakey).add(yosconnection.getConkey());
            return yosconnection;
        }
    }


    private YosConnection buildConnect(String datakey) throws YosException {
        synchronized (DBConnectPool.class) {
            YosConnection yosConnection;
            if (!propertiesMap.containsKey(datakey)) {
                Properties prop = getDataSource(datakey);
                if (prop != null && !prop.isEmpty()) {
                    propertiesMap.put(datakey, prop);
                }
            }
            Properties p = propertiesMap.get(datakey);
            try {
                Class.forName(p.getProperty("system.db.driver"));
                Connection conn = DriverManager.getConnection(p.getProperty("system.db.url"), p.getProperty("system.db.username"),
                        p.getProperty("system.db.password"));
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
                yosConnection = new YosConnection(datakey, conn);
            } catch (SQLException e) {
                e.printStackTrace();
                restartMySqlService(datakey, e);
                throw new YosException("创建" + datakey + "数据库连接失败！");
            } catch (ClassNotFoundException e) {
                throw new YosException("创建" + datakey + "数据库连接失败！找不到驱动" + p.getProperty("system.db.driver"));
            }
            return yosConnection;
        }
    }

    public static Boolean isstarting = false;

    public static void restartMySqlService(String datakey, SQLException e) {
        synchronized (DBConnectPool.class) {
            if (!isstarting && datakey.equals("default") && e.getSQLState().equals("08S01")) {
                isstarting = true;
                try {
                    OperatingSystemMXBean system = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
                    if (system.getName().contains("Windows")) {
                        // 根据你的操作系统和MySQL安装情况修改下面的命令
                        ProcessBuilder processBuilder = new ProcessBuilder("net", "start", properties.getYosProperties().getProperty("system.db.servicename", "mysql80"));
                        processBuilder.redirectErrorStream(true);
                        Process process = processBuilder.start();
                        process.waitFor();
                        logger.info("MySQL service restarted.");
                        Thread.sleep(2000);
                    }
                } catch (IOException | InterruptedException e2) {
                    e2.printStackTrace();
                }
                isstarting = false;
            }
        }
    }

    public void close(YosConnection yosConnection) {
        synchronized (DBConnectPool.class) {
            try {
                if (yosConnection.isneedclose()) {
                    yosConnection.close();
                } else if (!yosConnection.isClosed()) {
                    POOLS_MAP.get(yosConnection.datakey).add(yosConnection);
                }
            } catch (SQLException e) {
                e.printStackTrace();
                System.err.println(yosConnection.datakey + "连接关闭失败" + getDateTime_Str() + e.getMessage());
            } finally {
                useingConnectionkeyMap.get(yosConnection.datakey).remove(yosConnection.getConkey());
            }
        }
    }

    public static ArrayList<Long> connectionIDList = new ArrayList<>();

    public class YosConnection {
        private Connection connection;
        private Long createtime;
        private String datakey;
        private String conkey;
        private Long conid;

        private YosConnection(String datakey, Connection connection) {
            this.createtime = Calendar.getInstance().getTimeInMillis();
            this.datakey = datakey;
            this.connection = connection;
            this.conkey = this.datakey + "-" + createtime + "-" + Math.random(5);

            try {
                PreparedStatement statement = this.connection.prepareStatement("SELECT CONNECTION_ID() as conid;");
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    this.conid = resultSet.getLong("conid");
                    connectionIDList.add(this.conid);
                }
                resultSet.close();
                statement.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Connection getConnection() {
            return connection;
        }

        public String getDatakey() {
            return datakey;
        }

        public String getConkey() {
            return conkey;
        }

        public boolean isneedclose() {
            if ((Calendar.getInstance().getTimeInMillis() - this.createtime) > (3600 * 1000) || (POOLS_MAP.get(this.datakey).size() + useingConnectionkeyMap.get(this.datakey).size()) > License.get().getMaxDBConCount()) {
                return true;
            }
            try {
                if (!getConnection().isValid(1000)) {
                    return true;
                }
            } catch (Exception e) {
                return true;
            }
            return false;
        }

        private void close() throws SQLException {
            if (!this.isClosed()) {
                this.connection.close();
            }
            connectionIDList.remove(this.conid);
        }

        public boolean isClosed() throws SQLException {
            return this.connection.isClosed();
        }
    }

    /**
     * 获取数据源
     * @param datakey
     * @return
     */
    private Properties getDataSource(String datakey) throws YosException {
        Properties prop = new Properties();
        switch (datakey) {
            case "default": {
                return properties.getYosProperties();
            }
            default: {
                DBConnect dbConnect = new DBConnect();
                String sql = "select driver,username,password,url from sys_datasource where datakey='" + datakey + "'";
                Rows rows = dbConnect.runSqlQuery(sql);
                if (!rows.isEmpty()) {
                    prop.setProperty("system.db.driver", rows.get(0).getString("driver"));
                    prop.setProperty("system.db.username", rows.get(0).getString("username"));
                    prop.setProperty("system.db.password", rows.get(0).getString("password"));
                    prop.setProperty("system.db.url", rows.get(0).getString("url"));
                } else {
                    return null;
                }
                break;
            }
        }
        return prop;
    }

    public String getDateTime_Str() {
        return BaseClass.dateTimeFormat.format(Calendar.getInstance().getTime());
    }
}
