/*
 * Decompiled with CFR 0.152.
 */
package utility.huawei.obs;

import beans.parameter.Parameter;
import com.huaweicloud.sdk.ces.v1.CesClient;
import com.huaweicloud.sdk.ces.v1.model.Datapoint;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataRequest;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataResponse;
import com.huaweicloud.sdk.ces.v1.region.CesRegion;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import common.BaseClass;
import common.YosException;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BucketCESManage
extends BaseClass {
    protected String bucketname;
    protected CesClient cesClient;
    protected ArrayList<String> sqllist1;
    protected ArrayList<String> sqllist2;
    protected long fromtime;
    protected long totime;
    protected String yeaterday;
    protected String siteid;

    public BucketCESManage(String siteid) throws YosException {
        this.siteid = siteid;
        this.bucketname = this.getBucketname();
        AbstractCredentials auth = ((BasicCredentials)new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak"))).withSk(Parameter.get("attachment_huawei_obs_sk"));
        this.cesClient = (CesClient)CesClient.newBuilder().withCredential((ICredential)auth).withRegion(CesRegion.valueOf((String)Parameter.get("attachment_huawei_obs_location"))).build();
        this.sqllist1 = new ArrayList();
        this.sqllist2 = new ArrayList();
    }

    private String getBucketname() {
        try {
            Rows rows = ((QuerySQL)SQLFactory.createQuerySQL(this.dbConnect, "sys_site", "bucketname").setWhere("siteid", this.siteid)).query();
            if (rows.isNotEmpty()) {
                this.bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }

    public void getData() throws YosException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.yeaterday = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        Rows rows = ((QuerySQL)((QuerySQL)SQLFactory.createQuerySQL(this.dbConnect, "sys_obsdatalog", "sys_obsdatalogid").setWhere("siteid", this.siteid)).setWhere("createdate", this.yeaterday)).query();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.fromtime = calendar.getTimeInMillis();
        calendar.add(5, 1);
        this.totime = calendar.getTimeInMillis();
        if (rows.size() < 6) {
            this.getDownload_traffic();
            if (!this.sqllist1.isEmpty()) {
                this.dbConnect.runSqlUpdate(this.sqllist1);
            }
            this.getUpload_traffic();
            if (!this.sqllist2.isEmpty()) {
                this.dbConnect.runSqlUpdate(this.sqllist2);
            }
        }
    }

    private void getDownload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("download_traffic");
        request.withDim0("bucket_name," + this.bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue((String)"sum"));
        request.withPeriod(Integer.valueOf(14400));
        request.withFrom(Long.valueOf(this.fromtime));
        request.withTo(Long.valueOf(this.totime));
        try {
            ShowMetricDataResponse response = this.cesClient.showMetricData(request);
            List list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double downloadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();
                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_obsdatalog");
                    insertSQL.setSiteid(this.siteid).setUniqueid(this.createTableID("sys_obsdatalog"));
                    insertSQL.setValue("bucketname", this.bucketname);
                    insertSQL.setValue("timestamp", time);
                    insertSQL.setValue("createdate", createdate);
                    insertSQL.setValue("createtime", createtime);
                    insertSQL.setWhere("not exists(select * from sys_obsdatalog where siteid = '" + this.siteid + "' and timestamp = '" + time + "')");
                    UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this.dbConnect, "sys_obsdatalog");
                    updateSQL.setValue("downloadbytes", downloadbytes);
                    ((UpdateSQL)updateSQL.setWhere("siteid", this.siteid)).setWhere("timestamp", time);
                    this.sqllist1.add(insertSQL.getSQL());
                    this.sqllist1.add(updateSQL.getSQL());
                }
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }

    private void getUpload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("upload_traffic");
        request.withDim0("bucket_name," + this.bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue((String)"sum"));
        request.withPeriod(Integer.valueOf(14400));
        request.withFrom(Long.valueOf(this.fromtime));
        request.withTo(Long.valueOf(this.totime));
        try {
            ShowMetricDataResponse response = this.cesClient.showMetricData(request);
            List list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double uploadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();
                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_obsdatalog");
                    insertSQL.setSiteid(this.siteid).setUniqueid(this.createTableID("sys_obsdatalog"));
                    insertSQL.setValue("bucketname", this.bucketname);
                    insertSQL.setValue("timestamp", time);
                    insertSQL.setValue("createdate", createdate);
                    insertSQL.setValue("createtime", createtime);
                    insertSQL.setWhere("not exists(select * from sys_obsdatalog where siteid = '" + this.siteid + "' and timestamp = '" + time + "')");
                    UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this.dbConnect, "sys_obsdatalog");
                    updateSQL.setValue("uploadbytes", uploadbytes);
                    ((UpdateSQL)updateSQL.setWhere("siteid", this.siteid)).setWhere("timestamp", time);
                    this.sqllist2.add(insertSQL.getSQL());
                    this.sqllist2.add(updateSQL.getSQL());
                }
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }
}

