/*
 * Decompiled with CFR 0.152.
 */
package common.mq;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.mq.MQDatas;
import common.mq.MQMessage;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.RemoveInfo;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class ClientMQTT {
    public static HashMap<Long, MqttClient> connectionMap = new HashMap();
    private static HashMap<String, String> connectClientIDMap = new HashMap();
    private static HashMap<String, Long> connectClientIDMQIDMap = new HashMap();
    public static HashMap<String, Integer> onlineClientid = new HashMap();
    private static String clientid = "WAServer";

    public static void subscribe(long sys_mqid, ArrayList<String> topicList, int qos) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                for (String topics : topicList) {
                    connectionMap.get(sys_mqid).subscribe(topics, qos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void subscribe(long sys_mqid, String topics, int qos) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(topics);
        ClientMQTT.subscribe(sys_mqid, list, qos);
    }

    public static void unsubscribe(long sys_mqid, String topic) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                connectionMap.get(sys_mqid).unsubscribe(topic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void publish(long w_function_queueid) {
        try {
            Rows rows = new DBConnect().runSqlQuery("select t1.topic,t1.params,t1.msgid,t2.serialnumber,t2.isfeedback from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.w_function_queueid=" + w_function_queueid);
            for (Row row : rows) {
                String topic = row.getString("topic");
                JSONObject params = row.getJSONObject("params");
                String msgid = row.getString("msgid");
                String serialnumber = row.getString("serialnumber");
                boolean isfeedback = row.getBoolean("isfeedback");
                MQDatas.MQData mqData = new MQDatas().createMQData(Calendar.getInstance().getTimeInMillis());
                mqData.setMsgid(msgid);
                for (String key : params.keySet()) {
                    mqData.put(key, params.get(key));
                }
                if (!ClientMQTT.publish(serialnumber, topic, mqData)) continue;
                if (isfeedback) {
                    new DBConnect().runSqlUpdate("update w_function_queue set issend=1,sendcount=sendcount+1,lastsendtime=now() where w_function_queueid=" + w_function_queueid);
                    continue;
                }
                new DBConnect().runSqlUpdate("update w_function_queue set issend=1,sendcount=1,isreceive=1,receivetime='" + mqData.getTs() + "',lastsendtime=now() where w_function_queueid=" + w_function_queueid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean publish(String clientid, String topic, MQDatas.MQData mqData) throws Exception {
        return ClientMQTT.publish(clientid, topic, mqData, 1, false);
    }

    public static boolean publish(String clientid, String topic, MQDatas.MQData mqData, int qos, boolean retain) {
        try {
            long sys_mqid = ClientMQTT.getConnectClientMQID(clientid);
            if (connectionMap.containsKey(sys_mqid) && connectClientIDMap.containsValue(clientid) && sys_mqid > 0L) {
                MqttMessage mqttMessage = new MqttMessage();
                mqttMessage.setQos(qos);
                mqttMessage.setRetained(retain);
                byte[] msg = ClientMQTT.msgConvert(topic, mqData);
                mqttMessage.setPayload(msg);
                connectionMap.get(sys_mqid).publish(topic, mqttMessage);
                if (Parameter.get("system_topic_log").equalsIgnoreCase("true")) {
                    BaseClass baseClass = new BaseClass();
                    InsertSQL rowInsert = SQLFactory.createInsertSQL(baseClass.dbConnect, "w_device_topics_log");
                    rowInsert.setValue("w_device_topics_logid", baseClass.createTableID("w_device_topics_log"));
                    rowInsert.setValue("topic", topic);
                    rowInsert.setValue("content", new String(msg, StandardCharsets.UTF_8));
                    rowInsert.setDateValue("createdate");
                    rowInsert.insert();
                    baseClass.dbConnect.runSqlUpdate("delete t1 from w_device_topics_log t1 \nleft join (select w_device_topics_logid from w_device_topics_log where topic='" + topic + "' order by w_device_topics_logid desc limit 10) t2 on t1.w_device_topics_logid=t2.w_device_topics_logid\nwhere t1.topic='" + topic + "' and t2.w_device_topics_logid is null");
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static byte[] msgConvert(String topic, MQDatas.MQData mqData) {
        try {
            Rows w_deviceRows = new DBConnect().runSqlQuery("select t3.issystem,t3.jarpath from w_device_topics t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid inner join sys_msgprotocol t3 on t2.sys_msgprotocolid=t3.sys_msgprotocolid and t3.protocoltype='mqtt' where t2.isused=1 and t1.topic='" + topic + "'");
            Iterator iterator = w_deviceRows.iterator();
            if (iterator.hasNext()) {
                Row w_deviceRow = (Row)iterator.next();
                boolean issystem = w_deviceRow.getBoolean("issystem");
                if (issystem) {
                    JSONObject object = new JSONObject();
                    object.put("ts", (Object)mqData.getTs());
                    object.put("msgid", (Object)mqData.getMsgid());
                    object.put("d", JSONObject.toJSON((Object)mqData));
                    return object.toJSONString().getBytes(StandardCharsets.UTF_8);
                }
                String jarpath = w_deviceRow.getString("jarpath");
                jarpath = System.getProperty("os.name").contains("Windows") ? "file:/" + jarpath : "file://" + jarpath;
                Class<?> MsgProtocol = Class.forName("MsgProtocol", true, new URLClassLoader(new URL[]{new URL(jarpath)}, ClientMQTT.class.getClassLoader()));
                Object instance = MsgProtocol.newInstance();
                Method method = MsgProtocol.getDeclaredMethod("publish", String.class, MQDatas.MQData.class);
                return (byte[])method.invoke(instance, topic, mqData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSONObject.toJSONString((Object)mqData).getBytes(StandardCharsets.UTF_8);
    }

    public static void MQinit() {
        try {
            DBConnect dbConnect = new DBConnect();
            Rows sys_mqRows = dbConnect.runSqlQuery("select jmxaddress,password,username,address,sys_mqid from sys_mq");
            for (Row sys_mqRow : sys_mqRows) {
                try {
                    String address = sys_mqRow.getString("address");
                    String jmxaddress = sys_mqRow.getString("jmxaddress");
                    String username = sys_mqRow.getString("username");
                    String password = sys_mqRow.getString("password");
                    long sys_mqid = sys_mqRow.getLong("sys_mqid");
                    MqttClient mqttClient = new MqttClient(address, clientid, (MqttClientPersistence)new MemoryPersistence());
                    mqttClient.setCallback((MqttCallback)new MQMessage(sys_mqid));
                    MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                    mqttConnectOptions.setCleanSession(true);
                    mqttConnectOptions.setKeepAliveInterval(10);
                    mqttConnectOptions.setConnectionTimeout(15);
                    mqttConnectOptions.setUserName(username);
                    mqttConnectOptions.setPassword(password.toCharArray());
                    mqttClient.connect(mqttConnectOptions);
                    mqttClient.subscribe("wateraffairs/+/+/data", 1);
                    mqttClient.subscribe("wateraffairs/+/+/rec", 1);
                    connectionMap.put(sys_mqid, mqttClient);
                    Thread.sleep(1000L);
                    ClientMQTT.JmxService(sys_mqid, username, password, jmxaddress);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void JmxService(final Long sys_mqid, final String userName, final String password, final String brokerURL) {
        new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(userName, password, brokerURL);
                    Connection connection = factory.createConnection();
                    connection.setClientID(clientid + "\u8fde\u63a5" + sys_mqid + "\u76d1\u63a7:" + Calendar.getInstance().getTimeInMillis());
                    connection.start();
                    Session session = connection.createSession(false, 1);
                    ActiveMQTopic test = AdvisorySupport.getConnectionAdvisoryTopic();
                    MessageConsumer consumer = session.createConsumer((Destination)test);
                    consumer.setMessageListener(new MessageListener(){

                        public void onMessage(Message message2) {
                            if (message2 instanceof ActiveMQMessage) {
                                ActiveMQMessage msg = (ActiveMQMessage)message2;
                                if (msg.getDataStructure() instanceof ConnectionInfo) {
                                    final ConnectionInfo info = (ConnectionInfo)msg.getDataStructure();
                                    System.out.println(BaseClass.getDateTime_Str() + "\u8bbe\u5907\u4e0a\u7ebf serialnumber:" + info.getClientId());
                                    connectClientIDMap.put(info.getConnectionId().getValue(), info.getClientId());
                                    connectClientIDMQIDMap.put(info.getClientId(), sys_mqid);
                                    try {
                                        onlineClientid.put(info.getClientId(), onlineClientid.getOrDefault(info.getClientId(), 0) + 1);
                                        if (onlineClientid.getOrDefault(info.getClientId(), 0) == 1) {
                                            new DBConnect().runSqlUpdate("update w_device set status='\u5728\u7ebf',lastconnecttime=now() where serialnumber='" + info.getClientId() + "'");
                                            new Thread(){

                                                @Override
                                                public void run() {
                                                    super.run();
                                                    try {
                                                        Thread.sleep(1000L);
                                                        Rows rows = new DBConnect().runSqlQuery("select w_function_queueid from w_function_queue t1 inner join w_device t2 on t1.siteid=t2.siteid and t1.w_deviceid=t2.w_deviceid where t1.invalid=0 and t1.isreceive=0 and t2.serialnumber='" + info.getClientId() + "'");
                                                        for (Row row : rows) {
                                                            ClientMQTT.publish(row.getLong("w_function_queueid"));
                                                            Thread.sleep(100L);
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }.start();
                                            MQMessage.deviceMsgStatusInit(info.getClientId());
                                        }
                                    }
                                    catch (YosException e) {
                                        e.printStackTrace();
                                    }
                                } else if (msg.getDataStructure() instanceof RemoveInfo) {
                                    RemoveInfo info = (RemoveInfo)msg.getDataStructure();
                                    try {
                                        if (connectClientIDMap.containsKey(info.getObjectId().toString())) {
                                            String serialnumber = (String)connectClientIDMap.get(info.getObjectId().toString());
                                            System.out.println(BaseClass.getDateTime_Str() + "\u8bbe\u5907\u79bb\u7ebf serialnumber:" + serialnumber);
                                            onlineClientid.put(serialnumber, onlineClientid.getOrDefault(serialnumber, 0) - 1);
                                            if (onlineClientid.get(serialnumber) <= 0) {
                                                onlineClientid.remove(serialnumber);
                                                connectClientIDMQIDMap.remove(serialnumber);
                                                ArrayList<String> sqlist = new ArrayList<String>();
                                                sqlist.add("update w_device set status='\u79bb\u7ebf',lastconnecttime=now() where serialnumber='" + serialnumber + "'");
                                                sqlist.add("update w_function_queue t1 inner join w_device t2 on t1.w_deviceid=t2.w_deviceid set t1.invalid=1 where t1.isreceive=0 and t1.invalid=0 and t1.sendcount>=2 and t2.serialnumber='" + serialnumber + "'");
                                                new DBConnect().runSqlUpdate(sqlist);
                                                MQMessage.deviceMsgStatusInit(serialnumber);
                                            }
                                        }
                                    }
                                    catch (YosException e) {
                                        e.printStackTrace();
                                    }
                                    connectClientIDMap.remove(info.getObjectId().toString());
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static void disconnect(long sys_mqid) {
        try {
            if (connectionMap.containsKey(sys_mqid)) {
                connectionMap.get(sys_mqid).disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Collection<String> connectClientIDMap() {
        return connectClientIDMap.values();
    }

    public static long getConnectClientMQID(String clientid) {
        return connectClientIDMQIDMap.getOrDefault(clientid, 0L);
    }
}

