package utility.nuonuo;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import nuonuo.open.sdk.NNOpenSDK;
import utility.nuonuo.pojo.BlueInvoiceMsg;
import utility.nuonuo.pojo.InvoiceDetailMsg;
import utility.nuonuo.pojo.RedInvoiceMsg;

import java.util.List;
import java.util.UUID;

public class OpenApi extends BaseClass {

    private boolean isused(String siteid) throws YosException {
        String bank_bbc_used = Parameter.get(siteid, "nuonuo_invoice_used");
        return bank_bbc_used.equals("1");
    }

    /**
     * 发票查询
     *
     * @param serialNo
     */
    public JSONObject queryInvoiceResult(String siteid, String serialNo) throws YosException {

        JSONObject contentObject = new JSONObject();
        contentObject.put("isOfferInvoiceDetail", "1");
        JSONArray serialNosArray = new JSONArray();
        serialNosArray.add(serialNo);
        contentObject.put("serialNos", serialNosArray);
        JSONObject resultObject = requestApi(siteid, "nuonuo.ElectronInvoice.queryInvoiceResult", contentObject.toString());
        System.out.println("发票查询结果：" + resultObject);
        if (resultObject.getString("code").equalsIgnoreCase("E0000")) {
            JSONArray resultJsonArray = resultObject.getJSONArray("result");
            for (Object o : resultJsonArray) {
                JSONObject resultJsonObject = (JSONObject) o;
                String status = resultJsonObject.getString("status");
                if (status.equals("2")) {
                    String pdfUrl = resultJsonObject.getString("pdfUrl");
                    String paperPdfUrl = resultJsonObject.getString("paperPdfUrl");
                    String invoiceCode = resultObject.getString("invoiceCode");
                    String invoiceNo = resultObject.getString("invoiceNo");
                    System.out.println("发票地址" + pdfUrl);
                    System.out.println("?纸质发票地址?" + paperPdfUrl);
                    System.out.println(invoiceCode);
                    System.out.println(invoiceNo);
                }
            }
        }
        return resultObject;
    }

    /**
     * 创建蓝字发票
     */
    public void createBlueInvoice(String siteid, BlueInvoiceMsg blueInvoiceMsg) throws YosException {
        JSONObject orderObject = new JSONObject();

        orderObject.put("buyerName", blueInvoiceMsg.getBuyerName());
        orderObject.put("buyerTaxNum", blueInvoiceMsg.getBuyerTaxNum());
        orderObject.put("buyerTel", blueInvoiceMsg.getBuyerTel());
        orderObject.put("buyerAddress", blueInvoiceMsg.getBuyerAddress());
        orderObject.put("buyerAccount", blueInvoiceMsg.getBuyerAccount());

        orderObject.put("salerTaxNum", Parameter.get(siteid, "nuonuo_invoice_taxnum"));
        orderObject.put("salerTel", Parameter.get(siteid, "nuonuo_invoice_salertel"));
        orderObject.put("salerAddress", Parameter.get(siteid, "nuonuo_invoice_saleraddress"));
        orderObject.put("salerAccount", Parameter.get(siteid, "nuonuo_invoice_saleraccount"));

        orderObject.put("orderNo", blueInvoiceMsg.getOrderNo());
        orderObject.put("invoiceDate", getDateTime_Str());
        orderObject.put("remark", blueInvoiceMsg.getRemark());
        orderObject.put("invoiceType", "1");
        orderObject.put("invoiceLine", blueInvoiceMsg.getInvoiceLine());
        orderObject.put("checker", blueInvoiceMsg.getChecker());
        orderObject.put("payee", blueInvoiceMsg.getPayee());
        orderObject.put("clerk", blueInvoiceMsg.getClerk());


        orderObject.put("pushMode", "-1");
        orderObject.put("buyerPhone", "");
        orderObject.put("email", "");
        //orderObject.put("listFlag", "0");
        //orderObject.put("listName", "");
        JSONArray invoiceDetailArray = new JSONArray();
        List<InvoiceDetailMsg> invoiceDetailMsgList = blueInvoiceMsg.getBlueInvoiceDetailMsgList();
        /**
         * ?????????
         **/
        for (InvoiceDetailMsg invoiceDetailMsg : invoiceDetailMsgList) {
            JSONObject invoiceDetailObject = new JSONObject();
            invoiceDetailObject.put("goodsName", invoiceDetailMsg.getGoodsName());//??????????invoiceLineProperty =1???????????????У?????в????????????????б???????????У??????????????????????
            invoiceDetailObject.put("withTaxFlag", "1");//???????????0:?????,1:???
            invoiceDetailObject.put("price", invoiceDetailMsg.getPrice());//???????????(price)??????????(num)?????????(price)????????????(ta xIncludedAmount)??????????(taxEx cludedAmount)?????(tax)?????????
            invoiceDetailObject.put("num", invoiceDetailMsg.getNum());//????????????????????????
            invoiceDetailObject.put("unit", invoiceDetailMsg.getUnit());//??λ
            invoiceDetailObject.put("specType", invoiceDetailMsg.getSpecType());//??????
            invoiceDetailObject.put("taxRate", invoiceDetailMsg.getTaxRate());//??????????嵥????????null?????
            //invoiceDetailObject.put("goodsCode", "12312312312");//??????????????????????????? ??д??
            //invoiceDetailObject.put("selfCode", "");//???б????????
            //invoiceDetailObject.put("tax", "");//???[????????] * [???] = [???]????????????? 0.06??????????????????????????κ????????????? ???????????????????м???????? ????????????????鶼????
            //invoiceDetailObject.put("taxExcludedAmount", "");//???????????????????????????????κ????????????????? ??????????????м????????????? ???????????鶼????
            //invoiceDetailObject.put("taxIncludedAmount", "");//??????[????????] + [???] = [??????]??????????????????????????κ????????????????????? ??????????м?????????????????? ??????鶼????
            //invoiceDetailObject.put("invoiceLineProperty", "");//??????????0,??????;1,?????;2,???????
            //invoiceDetailObject.put("favouredPolicyFlag", "");//???????????0,?????;1,???
            //invoiceDetailObject.put("favouredPolicyName", "");//???????????????????????,??favouredPolicyFlag?1??????????
            //invoiceDetailObject.put("deduction", "");//???????????????д??????????д?? ???????0???????β??????????????????????0.00??????? ?????0.00
            //invoiceDetailObject.put("zeroRateFlag", "");//???????????,???????;1,???;2,?????;3,?????????1??????????0%?????? ??????????????????? ??????????贫??1?? 2??????????0%??????? ?????????"?????" ??????????? ????2?? 3??????????0%?????????? ???????? ??????????贫??3??
            invoiceDetailArray.add(invoiceDetailObject);
        }
        orderObject.put("invoiceDetail", invoiceDetailArray);

        JSONObject contentObject = new JSONObject();
        contentObject.put("order", orderObject);
        JSONObject result = requestApi(siteid, "nuonuo.ElectronInvoice.requestBillingNew", contentObject.toString());
        if (result.containsKey("code") && result.getString("code").equalsIgnoreCase("E0000")) {
            String invoiceSerialNum = result.getJSONObject("result").getString("invoiceSerialNum");
            System.out.println(invoiceSerialNum);
        }
        if (result.containsKey("describe")) {
            String describe = result.getString("describe");
            System.out.println(describe);
        }
    }

    /**
     * ??????????
     */
    public void createRedInvoice(String siteid, RedInvoiceMsg redInvoiceMsg) throws YosException {
        JSONObject orderObject = new JSONObject();
        /**
         * ???????
         */
        orderObject.put("buyerName", redInvoiceMsg.getBuyerName());//????????
        orderObject.put("buyerTaxNum", redInvoiceMsg.getBuyerTaxNum());//???????????????????????
        orderObject.put("buyerTel", redInvoiceMsg.getBuyerTel());//?????绰
        orderObject.put("buyerAddress", redInvoiceMsg.getBuyerAddress());//???????
        orderObject.put("buyerAccount", redInvoiceMsg.getBuyerAccount());//?????????????????е??
        /**
         * ???????
         */
        orderObject.put("salerTaxNum", Parameter.get(siteid, "nuonuo_invoice_taxnum"));//?????????????价???????????????salerTaxNum??????????userTax??д339901999999142??
        orderObject.put("salerTel", Parameter.get(siteid, "nuonuo_invoice_salertel"));//?????绰
        orderObject.put("salerAddress", Parameter.get(siteid, "nuonuo_invoice_saleraddress"));//???????
        orderObject.put("salerAccount", Parameter.get(siteid, "nuonuo_invoice_saleraccount"));//????????????????е??
        /**
         * ???????
         */
        orderObject.put("orderNo", redInvoiceMsg.getOrderNo());//?????????????Ψ???
        orderObject.put("invoiceDate", getDateTime_Str());//???????
        orderObject.put("invoiceType", "2");//????????1:???;2:???
        orderObject.put("invoiceLine", redInvoiceMsg.getInvoiceLine());//???????p,??????(???)(???);c,??????(??);s,??÷??;e,??????(???);f,??????(???);r,??????(???);b,???? ??????÷??;j,???????????????
        orderObject.put("invoiceCode", redInvoiceMsg.getBlueinvoiceCode());//??????д????????????????????? 10λ??12 λ?? 11λ????????? 0??
        orderObject.put("invoiceNum", redInvoiceMsg.getBlueinvoiceNum());//??????д?????????????????????????8λ????0??
        if (redInvoiceMsg.getInvoiceLine().equals("s") || redInvoiceMsg.getInvoiceLine().equals("b")) {
            orderObject.put("billInfoNo", redInvoiceMsg.getBillInfoNo());//???????????.??????????????????????????????????????????÷?????????ZZZZZZZZZZZZZZZZ?????????? ?С?Z????????????????÷?????????????16λ????????
            orderObject.put("remark", "?????????????÷?????????" + redInvoiceMsg.getBillInfoNo());//???????????????????????????????:XXXXXXXXX????:YYYYYYYY??????????С?X????????????Y???????????????????????????????????????????????????????
        }
        orderObject.put("checker", redInvoiceMsg.getChecker());//??????
        orderObject.put("payee", redInvoiceMsg.getPayee());//?????
        orderObject.put("clerk", redInvoiceMsg.getClerk());//????
        /**
         * ???????
         */
        orderObject.put("pushMode", "-1");//????????-1,??????;0,????;1,?????????;2,???????
        orderObject.put("buyerPhone", "");//?????????pushMode?1??2????????????
        orderObject.put("email", "");//????????pushMode?0??2????????????
        //orderObject.put("listFlag", "0");//?嵥????????嵥:0???嵥:1?????:0
        //orderObject.put("listName", "");//?嵥?????????????????????????listFlag?1?????????????????????? ??????

        JSONArray invoiceDetailArray = new JSONArray();
        List<InvoiceDetailMsg> invoiceDetailMsgList = redInvoiceMsg.getInvoiceDetailMsgList();
        /**
         ?????????
         **/
        for (InvoiceDetailMsg invoiceDetailMsg : invoiceDetailMsgList) {
            JSONObject invoiceDetailObject = new JSONObject();
            invoiceDetailObject.put("goodsName", invoiceDetailMsg.getGoodsName());//??????????invoiceLineProperty =1???????????????У?????в????????????????б???????????У??????????????????????
            invoiceDetailObject.put("withTaxFlag", "1");//???????????0:?????,1:???
            invoiceDetailObject.put("price", invoiceDetailMsg.getPrice());//???????????(price)??????????(num)?????????(price)????????????(ta xIncludedAmount)??????????(taxEx cludedAmount)?????(tax)?????????
            invoiceDetailObject.put("num", invoiceDetailMsg.getNum());//????????????????????????
            invoiceDetailObject.put("unit", invoiceDetailMsg.getUnit());//??λ
            invoiceDetailObject.put("specType", invoiceDetailMsg.getSpecType());//??????
            invoiceDetailObject.put("taxRate", invoiceDetailMsg.getTaxRate());//??????????嵥????????null?????

            //invoiceDetailObject.put("goodsCode", "12312312312");//??????????????????????????? ??д??
            //invoiceDetailObject.put("selfCode", "");//???б????????
            //invoiceDetailObject.put("tax", "");//???[????????] * [???] = [???]????????????? 0.06??????????????????????????κ????????????? ???????????????????м???????? ????????????????鶼????
            //invoiceDetailObject.put("taxExcludedAmount", "");//???????????????????????????????κ????????????????? ??????????????м????????????? ???????????鶼????
            //invoiceDetailObject.put("taxIncludedAmount", "");//??????[????????] + [???] = [??????]??????????????????????????κ????????????????????? ??????????м?????????????????? ??????鶼????
            //invoiceDetailObject.put("invoiceLineProperty", "");//??????????0,??????;1,?????;2,???????
            //invoiceDetailObject.put("favouredPolicyFlag", "");//???????????0,?????;1,???
            //invoiceDetailObject.put("favouredPolicyName", "");//???????????????????????,??favouredPolicyFlag?1??????????
            //invoiceDetailObject.put("deduction", "");//???????????????д??????????д?? ???????0???????β??????????????????????0.00??????? ?????0.00
            //invoiceDetailObject.put("zeroRateFlag", "");//???????????,???????;1,???;2,?????;3,?????????1??????????0%?????? ??????????????????? ??????????贫??1?? 2??????????0%??????? ?????????"?????" ??????????? ????2?? 3??????????0%?????????? ???????? ??????????贫??3??
            invoiceDetailArray.add(invoiceDetailObject);
        }
        orderObject.put("invoiceDetail", invoiceDetailArray);

        JSONObject contentObject = new JSONObject();
        contentObject.put("order", orderObject);
        JSONObject result = requestApi(siteid, "nuonuo.ElectronInvoice.requestBillingNew", contentObject.toString());
        if (result.containsKey("code") && result.getString("code").equalsIgnoreCase("E0000")) {
            String invoiceSerialNum = result.getJSONObject("result").getString("invoiceSerialNum");
            System.out.println(invoiceSerialNum);
        }
        if (result.containsKey("describe")) {
            String describe = result.getString("describe");
            System.out.println(describe);
        }
    }

    /**
     * ???????
     *
     * @param method  ?????
     * @param content ????????
     * @return ????????
     */
    private JSONObject requestApi(String siteid, String method, String content) throws YosException {
        String appKey = Parameter.get(siteid, "nuonuo_invoice_appkey");
        String taxnum = Parameter.get(siteid, "nuonuo_invoice_taxnum");
        String appSecret = Parameter.get(siteid, "nuonuo_invoice_appsecret");
        String token = Parameter.get(siteid, "nuonuo_invoice_token");

        String url = "https://sdk.nuonuo.com/open/v1/services";
        String senid = UUID.randomUUID().toString().replace("-", ""); // Ψ??????????????????32λ?????
        // ??????
        NNOpenSDK sdk = NNOpenSDK.getIntance();
        String json = sdk.sendPostSyncRequest(url, senid, appKey, appSecret, token, taxnum, method, content);
        // ??????????
        return JSONObject.parseObject(json);
    }
}
