/*
 * Decompiled with CFR 0.152.
 */
package utility.huawei.obs.mpc;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.mpc.v1.MpcClient;
import com.huaweicloud.sdk.mpc.v1.model.AnimatedGraphicsOutputParam;
import com.huaweicloud.sdk.mpc.v1.model.CreateAnimatedGraphicsTaskReq;
import com.huaweicloud.sdk.mpc.v1.model.CreateAnimatedGraphicsTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.CreateAnimatedGraphicsTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.CreateExtractTaskReq;
import com.huaweicloud.sdk.mpc.v1.model.CreateExtractTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.CreateExtractTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.CreateThumbReq;
import com.huaweicloud.sdk.mpc.v1.model.CreateThumbnailsTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.CreateThumbnailsTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.CreateTranscodingReq;
import com.huaweicloud.sdk.mpc.v1.model.CreateTranscodingTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.CreateTranscodingTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.ListAnimatedGraphicsTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.ListAnimatedGraphicsTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.ListTranscodingTaskRequest;
import com.huaweicloud.sdk.mpc.v1.model.ListTranscodingTaskResponse;
import com.huaweicloud.sdk.mpc.v1.model.ObsObjInfo;
import com.huaweicloud.sdk.mpc.v1.model.ThumbnailPara;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import java.util.ArrayList;
import java.util.Collections;
import utility.huawei.obs.mpc.MediaMetaData;
import utility.huawei.obs.mpc.MpcFile;

public class MpcFactory
extends BaseClass {
    private HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig().withIgnoreSSLVerification(true).withTimeout(3);
    private static BasicCredentials auth;
    private static MpcClient mpcClient;

    private String getBucketname(String siteid) {
        String bucketname = null;
        try {
            Rows rows = this.dbConnect.runSqlQuery("select bucketname from sys_site where siteid='" + siteid + "'");
            if (rows.isNotEmpty()) {
                bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bucketname;
    }

    public MpcFactory() throws YosException {
        auth = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak"))).withSk(Parameter.get("attachment_huawei_obs_sk"))).withProjectId(Parameter.get("attachment_huawei_obs_projectid"));
        mpcClient = (MpcClient)MpcClient.newBuilder().withHttpConfig(this.httpConfig).withCredential((ICredential)auth).withEndpoint(Parameter.get("attachment_huawei_mpc_endpoint")).build();
    }

    public String createTranscodingTask(String siteid, String filename) throws YosException {
        String bucketname = this.getBucketname(siteid);
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename);
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename + "-hls/");
        ArrayList<Integer> transTempIds = new ArrayList<Integer>();
        transTempIds.add(Integer.parseInt(Parameter.get("attachment_huawei_obs_mpc_transtemplateid")));
        CreateTranscodingTaskRequest createTranscodingTaskRequest = new CreateTranscodingTaskRequest().withBody(new CreateTranscodingReq().withInput(input).withOutput(output).withTransTemplateId(transTempIds).withOutputFilenames(Collections.singletonList(filename)));
        CreateTranscodingTaskResponse response = mpcClient.createTranscodingTask(createTranscodingTaskRequest);
        String taskId = "";
        JSONObject resultObject = (JSONObject)JSON.toJSON((Object)response);
        if (resultObject.containsKey("requestStatus") && "SUCCESS".equalsIgnoreCase(resultObject.getString("requestStatus"))) {
            taskId = resultObject.getString("taskId");
        }
        return taskId;
    }

    public MpcFile queryTranscodingTask(String taskId) throws YosException {
        ListTranscodingTaskRequest req = new ListTranscodingTaskRequest().withTaskId(Collections.singletonList(Long.parseLong(taskId)));
        ListTranscodingTaskResponse listTranscodingTaskResponse = mpcClient.listTranscodingTask(req);
        JSONObject resultObject = (JSONObject)JSON.toJSON((Object)listTranscodingTaskResponse);
        if (resultObject.containsKey("taskArray")) {
            JSONArray taskArray = resultObject.getJSONArray("taskArray");
            for (Object o : taskArray) {
                JSONObject object = (JSONObject)o;
                if (!taskId.equalsIgnoreCase(object.getString("taskId"))) continue;
                MpcFile mpcFile = new MpcFile();
                mpcFile.setTask_id(taskId);
                if (object.getJSONArray("outputFileName").isEmpty()) {
                    return null;
                }
                mpcFile.setOutput_file_name(object.getJSONArray("outputFileName").getString(0));
                JSONObject outputObject = object.getJSONObject("output");
                mpcFile.setBucket(outputObject.getString("bucket"));
                mpcFile.setLocation(outputObject.getString("location"));
                mpcFile.setObject(outputObject.getString("object"));
                return mpcFile;
            }
        }
        return null;
    }

    public MediaMetaData getMetaData(String siteid, String filename) throws YosException {
        String bucketname = this.getBucketname(siteid);
        MediaMetaData mediaMetaData = new MediaMetaData();
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename);
        CreateExtractTaskRequest req = new CreateExtractTaskRequest().withBody(new CreateExtractTaskReq().withInput(input).withSync(Integer.valueOf(1)));
        try {
            CreateExtractTaskResponse rsp = mpcClient.createExtractTask(req);
            JSONObject resultObject = (JSONObject)JSON.toJSON((Object)rsp);
            if ("SUCCEED".equalsIgnoreCase(resultObject.getString("status"))) {
                JSONObject metadataObject = resultObject.getJSONObject("metadata");
                mediaMetaData.setStatus(true);
                mediaMetaData.setDuration(metadataObject.getIntValue("duration"));
                mediaMetaData.setSize(metadataObject.getLongValue("size"));
                mediaMetaData.setFormat(metadataObject.getString("format"));
                if (metadataObject.containsKey("video")) {
                    JSONArray videoArray = metadataObject.getJSONArray("video");
                    for (JSONObject videoObjcet : videoArray) {
                        mediaMetaData.setCodec(videoObjcet.getString("codec"));
                        mediaMetaData.setFrameRate(videoObjcet.getIntValue("frameRate"));
                        mediaMetaData.setWidth(videoObjcet.getIntValue("width"));
                        mediaMetaData.setHeight(videoObjcet.getIntValue("height"));
                        mediaMetaData.setBitrate(videoObjcet.getLongValue("bitrate"));
                    }
                }
            } else {
                mediaMetaData.setStatus(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaMetaData;
    }

    public boolean createThumbnailsTask(String siteid, String filename, String thumbnailfilename, int width, int height, int dot) throws YosException {
        String bucketname = this.getBucketname(siteid);
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject(filename);
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject("/");
        CreateThumbnailsTaskRequest req = new CreateThumbnailsTaskRequest().withBody(new CreateThumbReq().withInput(input).withOutput(output).withThumbnailPara(new ThumbnailPara().withType(ThumbnailPara.TypeEnum.DOTS).withOutputFilename(thumbnailfilename).withDots(Collections.singletonList(dot)).withWidth(Integer.valueOf(width)).withHeight(Integer.valueOf(height))).withSync(Integer.valueOf(1)).withOriginalDir(Integer.valueOf(1)));
        CreateThumbnailsTaskResponse rsp = mpcClient.createThumbnailsTask(req);
        JSONObject resultObject = (JSONObject)JSON.toJSON((Object)rsp);
        return "FINISHED".equalsIgnoreCase(resultObject.getStringValue("status"));
    }

    public String createAnimatedGraphicsTask(String siteid, String filename, int width, int height) throws YosException {
        String bucketname = this.getBucketname(siteid);
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject(filename);
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject("/");
        CreateAnimatedGraphicsTaskRequest req = new CreateAnimatedGraphicsTaskRequest().withBody(new CreateAnimatedGraphicsTaskReq().withInput(input).withOutput(output).withOutputParam(new AnimatedGraphicsOutputParam().withFormat(AnimatedGraphicsOutputParam.FormatEnum.GIF).withFrameRate(Integer.valueOf(15)).withStart(Integer.valueOf(0)).withEnd(Integer.valueOf(3000)).withWidth(Integer.valueOf(width)).withHeight(Integer.valueOf(height))));
        CreateAnimatedGraphicsTaskResponse rsp = mpcClient.createAnimatedGraphicsTask(req);
        JSONObject resultObject = (JSONObject)JSON.toJSON((Object)rsp);
        if (resultObject.containsKey("taskId")) {
            return resultObject.getString("taskId");
        }
        return "";
    }

    public String queryAnimatedGraphicsTask(String taskId) throws YosException {
        if (taskId.equalsIgnoreCase("")) {
            return "";
        }
        ListAnimatedGraphicsTaskRequest req = new ListAnimatedGraphicsTaskRequest().withTaskId(Collections.singletonList(taskId));
        ListAnimatedGraphicsTaskResponse rsp = mpcClient.listAnimatedGraphicsTask(req);
        JSONObject resultObject = (JSONObject)JSON.toJSON((Object)rsp);
        if (resultObject.containsKey("tasks") && !resultObject.getJSONArray("tasks").isEmpty()) {
            JSONArray tasksArray = resultObject.getJSONArray("tasks");
            for (Object o : tasksArray) {
                JSONObject taskobject = (JSONObject)o;
                if (!taskobject.getString("status").equalsIgnoreCase("SUCCEED")) continue;
                return taskobject.getJSONObject("output").getString("fileName");
            }
        }
        return "";
    }
}

