/*
 * Decompiled with CFR 0.152.
 */
package utility.huawei.obs;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.fs.DropFolderRequest;
import common.YosException;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import utility.huawei.obs.Bucket;
import utility.huawei.obs.mpc.MediaMetaData;
import utility.huawei.obs.mpc.MpcFactory;
import utility.tools.WebRequest;

public class BucketFile
extends Bucket {
    public BucketFile(String siteid) throws YosException {
        super(siteid);
    }

    public void upload(String filename, InputStream inputStream, boolean iscreateMinImage) {
        this.obsClient.putObject(this.bucketname, filename, inputStream);
        if (iscreateMinImage) {
            this.getMinImageUrl(filename);
            this.getCompressImageUrl(filename);
        }
    }

    public void upload(String filename, File file) {
        this.obsClient.putObject(this.bucketname, filename, file);
    }

    public void deleteFile(String objectname) {
        this.obsClient.deleteObject(this.bucketname, objectname);
    }

    public void deleteFolder(String foldername) {
        DropFolderRequest dropFolderRequest = new DropFolderRequest(this.bucketname, foldername);
        this.obsClient.dropFolder(dropFolderRequest);
    }

    public boolean doesObjectExist(String objectname) {
        return this.obsClient.doesObjectExist(this.bucketname, objectname);
    }

    public String getFileUrl(String filename) {
        TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, 3600L);
        request.setBucketName(this.bucketname);
        request.setObjectKey(filename);
        TemporarySignatureResponse response = this.obsClient.createTemporarySignature(request);
        String url = response.getSignedUrl();
        return url.substring(0, url.indexOf("?"));
    }

    public String getMinImageUrl(String filename) {
        String filename_short = "s_" + filename;
        if (!this.obsClient.doesObjectExist(this.bucketname, filename_short)) {
            TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, 3600L);
            request.setBucketName(this.bucketname);
            request.setObjectKey(filename);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("x-image-process", "image/resize,m_lfit,h_150");
            try {
                queryParams.put("x-image-save-object", ServiceUtils.toBase64((byte[])filename_short.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            request.setQueryParams(queryParams);
            TemporarySignatureResponse response = this.obsClient.createTemporarySignature(request);
            new WebRequest().doGet_simple(response.getSignedUrl());
        }
        return this.getFileUrl(filename_short);
    }

    public String getCompressImageUrl(String filename) {
        String filename_short = "c_" + filename;
        if (!this.obsClient.doesObjectExist(this.bucketname, filename_short)) {
            TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, 3600L);
            request.setBucketName(this.bucketname);
            request.setObjectKey(filename);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            try {
                MpcFactory mpcFactory = new MpcFactory();
                MediaMetaData data = mpcFactory.getMetaData(this.siteid, filename);
                if (data.getWidth() > 5000 || data.getHeight() > 5000) {
                    queryParams.put("x-image-process", "image/resize,p_30");
                } else {
                    queryParams.put("x-image-process", "image/resize,p_50");
                }
                queryParams.put("x-image-save-object", ServiceUtils.toBase64((byte[])filename_short.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            request.setQueryParams(queryParams);
            TemporarySignatureResponse response = this.obsClient.createTemporarySignature(request);
            new WebRequest().doGet_simple(response.getSignedUrl());
        }
        return this.getFileUrl(filename_short);
    }

    public ObjectMetadata getObjectMetadata(String objectname) {
        return this.obsClient.getObjectMetadata(this.bucketname, objectname);
    }

    public InputStream getObjectInputStream(String objectname) {
        ObsObject obsObject = this.obsClient.getObject(this.bucketname, objectname);
        return obsObject.getObjectContent();
    }

    public void close() {
        if (this.obsClient != null) {
            try {
                this.obsClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getUploadUrl(String filetype, String objectname, HttpMethodEnum type) {
        long expireSeconds = 3600L;
        HashMap<String, String> headers = new HashMap<String, String>();
        String contentType = "application/octet-stream";
        if (type.equals((Object)HttpMethodEnum.POST)) {
            contentType = "multipart/form-data";
        }
        if ("pdf".equalsIgnoreCase(filetype)) {
            contentType = "application/pdf";
        } else if ("svg".equalsIgnoreCase(filetype)) {
            contentType = "image/svg+xml";
        }
        headers.put("Content-Type", contentType);
        TemporarySignatureRequest request = new TemporarySignatureRequest(type, expireSeconds);
        request.setBucketName(this.bucketname);
        request.setObjectKey(objectname);
        request.setHeaders(headers);
        TemporarySignatureResponse response = this.obsClient.createTemporarySignature(request);
        return response.getSignedUrl();
    }

    public String getPackFileUrl(String packpath, JSONArray filesArray) throws YosException {
        JSONObject requestObject = new JSONObject();
        JSONObject parameterObject = new JSONObject();
        parameterObject.put("endPoint", (Object)Parameter.get("attachment_huawei_obs_endpoint"));
        parameterObject.put("ak", (Object)Parameter.get("attachment_huawei_obs_ak"));
        parameterObject.put("sk", (Object)Parameter.get("attachment_huawei_obs_sk"));
        parameterObject.put("bucketName", (Object)this.bucketname);
        requestObject.put("parameter", (Object)parameterObject);
        requestObject.put("packfilepath", (Object)packpath);
        requestObject.put("files", (Object)filesArray);
        WebRequest webRequest = new WebRequest();
        webRequest.doPost(requestObject.toJSONString(), "https://2a1c33bfc16c45d2a6f6889a70ffc66f.apig.cn-east-2.huaweicloudapis.com/obsfilepacking");
        if (this.doesObjectExist(packpath)) {
            return this.getFileUrl(packpath);
        }
        return null;
    }
}

