package utility.wechat.work.stopusing;

import common.YosException;
import utility.wechat.work.GetAccessToken;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class CreateMenu {

    /**
     * 创建Menu
     *
     * @param @return
     * @param @throws IOException 设定文件
     * @return int 返回类型
     * @throws
     * @Title: createMenu
     * @Description: 创建Menu
     */
    public static String createMenu(String systemclient, String menu, String appid) {
        try {
            // 此处改为自己想要的结构体，替换即可
            String access_token = GetAccessToken.get(systemclient);
            String action = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?access_token="
                    + access_token + "&agentid=" + appid;
            URL url = new URL(action);
            HttpURLConnection http = (HttpURLConnection) url.openConnection();
            http.setRequestMethod("POST");
            http.setRequestProperty("Content-Type",
                    "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
            System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒
            http.connect();
            OutputStream os = http.getOutputStream();
            os.write(menu.getBytes(StandardCharsets.UTF_8));// 传入参数
            os.flush();
            os.close();

            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, StandardCharsets.UTF_8);
            return "返回信息" + message;
        } catch (IOException | YosException e) {
            e.printStackTrace();
        }
        return "createMenu 失败";
    }

    /**
     * 删除当前Menu
     *
     * @param @return 设定文件
     * @return String 返回类型
     * @throws
     * @Title: deleteMenu
     * @Description: 删除当前Menu
     */
    public static String deleteMenu(String systemclient) {

        try {
            String access_token = GetAccessToken.get(systemclient);
            String action = "https://api.weixin.qq.com/cgi-bin/menu/delete? access_token="
                    + access_token;
            URL url = new URL(action);
            HttpURLConnection http = (HttpURLConnection) url.openConnection();

            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type",
                    "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
            System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒
            http.connect();
            OutputStream os = http.getOutputStream();
            os.flush();
            os.close();

            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, StandardCharsets.UTF_8);
            return "deleteMenu返回信息:" + message;
        } catch (IOException | YosException e) {
            e.printStackTrace();
        }
        return "deleteMenu 失败";
    }
}
