package utility.wechat.wechatpay.nativepay;

import com.alibaba.fastjson.JSONObject;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.AutoUpdateCertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.glassfish.grizzly.http.util.Base64Utils;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;

public class NativePay extends BaseClass {

    private String appid;
    private String mch_id;
    private String mch_key;

    private String mchSerialNo = ""; // 商户证书序列号
    private String apiV3Key = ""; // api密钥
    private String privateKey = ""; // api密钥
    private String notify_url = "";//支付结果通知地址

    private CloseableHttpClient httpClient;
    private AutoUpdateCertificatesVerifier verifier;

    private NativePay() {
    }

    /**
     * 构造函数，创建扫码支付订单必须调用该构造函数
     *
     * @param systemclient 微信支付端名称
     * @throws YosException
     */
    public NativePay(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
    }

    /**
     * 二维码扫码下单
     *
     * @param out_trade_no 本地订单号
     * @return 二维码地址
     */
    public String createPayOrder(String out_trade_no) throws YosException {
        int order_amount = 0;
        Rows sys_payorderRows = dbConnect.runSqlQuery("select amount from sys_payorder where out_trade_no='" + out_trade_no + "'");
        if (sys_payorderRows.isNotEmpty()) {
            order_amount = new Double(sys_payorderRows.get(0).getDouble("amount") * 100).intValue();
        }
        String codeurl = "";
        try {
            HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/native");

            JSONObject reqdata = new JSONObject();
            reqdata.put("time_expire", "2023-04-27T18:30:00+08:00");
            JSONObject amount = new JSONObject();
            {
                amount.put("total", order_amount);
                amount.put("currency", "CNY");
            }
            reqdata.put("amount", amount);
            reqdata.put("mchid", mch_id);
            reqdata.put("description", "系统授权");//description
            reqdata.put("notify_url", notify_url);//通知地址
            reqdata.put("out_trade_no", out_trade_no);//商户订单号
            reqdata.put("appid", appid);
            reqdata.put("attach", "美大YOS");//附加数据,自定义数据说明

            StringEntity entity = new StringEntity(reqdata.toString(), "utf-8");
            entity.setContentType("application/json");
            httpPost.setEntity(entity);
            httpPost.setHeader("Accept", "application/json");

            //完成签名并执行请求
            CloseableHttpResponse response = httpClient.execute(httpPost);

            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) { //处理成功
                    System.out.println("success,return body = " + EntityUtils.toString(response.getEntity()));
                    codeurl = EntityUtils.toString(response.getEntity());
                    return codeurl;
                } else if (statusCode == 204) { //处理成功，无返回Body
                    System.out.println("success");
                } else {
                    System.out.println("failed,resp code = " + statusCode + ",return body = " + EntityUtils.toString(response.getEntity()));
                    throw new IOException("request failed");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                response.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return codeurl;
    }


    /**
     * 订单查询
     *
     * @param out_trade_no 本地订单号
     * @return
     */
    public void queryOrder(String out_trade_no) {
        try {
            HttpGet httpPost = new HttpGet("https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/" + out_trade_no + "?mchid=" + mch_id);
            httpPost.setHeader("Accept", "application/json");
            //完成签名并执行请求
            CloseableHttpResponse response = httpClient.execute(httpPost);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) { //处理成功
                    System.out.println("success,return body = " + EntityUtils.toString(response.getEntity()));

                    JSONObject returnobject = JSONObject.parseObject(EntityUtils.toString(response.getEntity()));
                    updatePayOrder(returnobject);
                } else if (statusCode == 204) { //处理成功，无返回Body
                    System.out.println("success");
                } else {
                    System.out.println("failed,resp code = " + statusCode + ",return body = " + EntityUtils.toString(response.getEntity()));
                    throw new IOException("request failed");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                response.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 更新本地数据库的订单信息
     */
    private boolean updatePayOrder(JSONObject wechatOrder) throws YosException {
        String trade_state = wechatOrder.getString("trade_state");
        String out_trade_no = wechatOrder.getString("out_trade_no");
        Rows sys_payorderRows = dbConnect.runSqlQuery("select * from sys_payorder where orderno='" + out_trade_no + "'");
        for (Row sys_payorderRow : sys_payorderRows) {
            ArrayList<String> sqllist = new ArrayList<>();
            sqllist.add("update sys_payorder set wechatpayorder='" + wechatOrder + "' where orderno='" + out_trade_no + "'");
            if ("SUCCESS".equalsIgnoreCase(trade_state)) {
                sqllist.add("update sys_payorder set ispaid=1,paytime=" + wechatOrder.getString("success_time") + " where orderno='" + out_trade_no + "'");
            }
            dbConnect.runSqlUpdate(sqllist);
        }
        return true;
    }

    /**
     * 更新本地数据库的订单信息
     */
    public static boolean updatePayOrder_CallBack(JSONObject returnobject) throws YosException {
        NativePay nativepay = new NativePay();
        if ("支付成功".equals(returnobject.getString("summary"))) {
            JSONObject resource = returnobject.getJSONObject("resource");

            String associated_data = resource.getString("associated_data");
            String nonce = resource.getString("nonce");
            String ciphertext = resource.getString("ciphertext");

            String data = nativepay.decryptResponseBody(nativepay.apiV3Key, associated_data, nonce, ciphertext);

            JSONObject wechatOrder = JSONObject.parseObject(data);
            return nativepay.updatePayOrder(wechatOrder);
        }
        return false;
    }

    private String decryptResponseBody(String apiV3Key, String associatedData, String nonce, String ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");

            SecretKeySpec key = new SecretKeySpec(apiV3Key.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(StandardCharsets.UTF_8));

            cipher.init(Cipher.DECRYPT_MODE, key, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));

            byte[] bytes;
            try {
                bytes = cipher.doFinal(Base64Utils.decode(ciphertext));
            } catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
            return new String(bytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /**
     * 创建订单前先调用此方法，
     */
    public void setup() {
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey(
                new ByteArrayInputStream(privateKey.getBytes(StandardCharsets.UTF_8)));
        //使用自动更新的签名验证器，不需要传入证书
        PrivateKeySigner privateKeySigner = new PrivateKeySigner(mchSerialNo, merchantPrivateKey);
        WechatPay2Credentials wechatPay2Credentials = new WechatPay2Credentials(mch_id, privateKeySigner);
        verifier = new AutoUpdateCertificatesVerifier(wechatPay2Credentials, apiV3Key.getBytes(StandardCharsets.UTF_8));
        WechatPay2Validator wechatPay2Validator = new WechatPay2Validator(verifier);
        httpClient = WechatPayHttpClientBuilder.create().withMerchant(mch_id, mchSerialNo, merchantPrivateKey).withValidator(wechatPay2Validator).build();
    }

    /**
     * 订单创建成功后调用此方法
     *
     * @throws IOException
     */
    public void after() throws IOException {
        httpClient.close();
    }
}
