package utility.wechat.wechatpay.POJO;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import utility.tools.WebRequest;

import java.util.Iterator;

public class QueryOrderRequest extends Base {
    private String appid;
    private String mch_id;
    private String nonce_str;
    private String out_trade_no;

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }

    public WechatOrder getOrder(String mch_key) {
        String requestxml = asXml(mch_key);
        String res = new WebRequest().doPost(requestxml,  "https://api.mch.weixin.qq.com/pay/orderquery");
        return getWechatOrder(res);
    }


    private String asXml(String mch_key) {
        DOMElement request = new DOMElement("xml");
        request.addElement("appid").addText(appid);//应用ID
        request.addElement("mch_id").addText(mch_id);//商户ID
        request.addElement("nonce_str").addText(createNonce_str(mch_id + out_trade_no));//随机字符串
        request.addElement("out_trade_no").addText(out_trade_no);//商户订单号
        createSign(request,mch_key);
        return request.asXML();
    }

    public WechatOrder getWechatOrder(String response) {
        WechatOrder orderResponse = new WechatOrder();
        try {
            Document respones = DocumentHelper.parseText(response);
            orderResponse.setXml(respones.asXML());
            Iterator<Element> it = respones.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element element = it.next();
                String key = element.getName();
                String text = element.getText();
                switch (key) {
                    case "return_code": {
                        orderResponse.setReturn_code(text);
                        break;
                    }
                    case "return_msg": {
                        orderResponse.setReturn_msg(text);
                        break;
                    }
                    case "appid": {
                        orderResponse.setAppid(text);
                        break;
                    }
                    case "mch_id": {
                        orderResponse.setMch_id(text);
                        break;
                    }
                    case "nonce_str": {
                        orderResponse.setNonce_str(text);
                        break;
                    }
                    case "sign": {
                        orderResponse.setSign(text);
                        break;
                    }
                    case "result_code": {
                        orderResponse.setResult_code(text);
                        break;
                    }
                    case "err_code": {
                        orderResponse.setErr_code(text);
                        break;
                    }
                    case "err_code_des": {
                        orderResponse.setErr_code_des(text);
                        break;
                    }
                    case "device_info": {
                        orderResponse.setDevice_info(text);
                        break;
                    }
                    case "openid": {
                        orderResponse.setOpenid(text);
                        break;
                    }
//                    case "is_subscribe": {
//                        orderResponse.setIs_subscribe(text);
//                        break;
//                    }
                    case "trade_type": {
                        orderResponse.setTrade_type(text);
                        break;
                    }
                    case "trade_state": {
                        orderResponse.setTrade_state(text);
                        break;
                    }
                    case "bank_type": {
                        orderResponse.setBank_type(text);
                        break;
                    }
                    case "total_fee": {
                        orderResponse.setTotal_fee(Integer.parseInt(text));
                        break;
                    }
                    case "fee_type":
                    case "cash_fee_type": {
                        orderResponse.setFee_type(text);
                        break;
                    }
                    case "cash_fee": {
                        orderResponse.setCash_fee(Integer.parseInt(text));
                        break;
                    }
                    case "settlement_total_fee": {
                        orderResponse.setSettlement_total_fee(Integer.parseInt(text));
                        break;
                    }
//                    case "coupon_fee": {
//                        orderResponse.setCoupon_fee(Integer.parseInt(text));
//                        break;
//                    }
//                    case "coupon_count": {
//                        orderResponse.setCoupon_count(Integer.parseInt(text));
//                        break;
//                    }
//                    case "coupon_id_$n": {
//                        orderResponse.setCoupon_id_$n(text);
//                        break;
//                    }
//                    case "coupon_type_$n": {
//                        orderResponse.setCoupon_type_$n(text);
//                        break;
//                    }
//                    case "coupon_fee_$n": {
//                        orderResponse.setCoupon_fee_$n(Integer.parseInt(text));
//                        break;
//                    }
                    case "transaction_id": {
                        orderResponse.setTransaction_id(text);
                        break;
                    }
                    case "out_trade_no": {
                        orderResponse.setOut_trade_no(text);
                        break;
                    }
                    case "attach": {
                        orderResponse.setAttach(text);
                        break;
                    }
                    case "time_end": {
                        orderResponse.setTime_end(text);
                        break;
                    }
                    case "trade_state_desc": {
                        orderResponse.setTrade_state_desc(text);
                        break;
                    }
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return orderResponse;
    }
}
