package utility.bankdocking.boc;

import beans.parameter.Parameter;
import common.BaseClass;
import common.YosException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import utility.bankdocking.boc.domain.TradeInfoResponseDetail;
import utility.bankdocking.boc.tool.ElementResolve;
import utility.bankdocking.boc.tool.PostXml;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BOC extends BaseClass {
    /**
     * @param begnum 本次查询的交易起始位置
     * @return
     * @throws Exception
     */
    public List<TradeInfoResponseDetail> query(String siteid, int begnum) throws YosException {
        String bank_abc_used = Parameter.get(siteid, "bank_abc_used");
        if (!bank_abc_used.equals("1")) {
            return new ArrayList<>();
        }
        String reqdata = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                "<bocb2e version=\"110\"  locale=\"zh_CN\">" +
                "<head>" +
                "<termid>" + Parameter.get(siteid, "bank_boc_termid") + "</termid>" +//企业前置机编号，E开头+前置机IP地址（各段补零，无小数点12位）
                "<trnid>" + Parameter.get(siteid, "bank_boc_trnid") + "</trnid>" +//客户端产生的报文编号
                "<custid>" + Parameter.get(siteid, "bank_boc_custid") + "</custid>" +//企业在中行网银系统的客户编码
                "<cusopr>" + Parameter.get(siteid, "bank_boc_cusopr") + "</cusopr>" +//企业操作员代码
                "<trncod>b2e0035</trncod>" +//交易代码,固定
                //"<token>ZD10yJZcyb03aBYtDNd56ok</token>" +//交易验证标识，签到时生成、签退时注销，可不传
                "</head>" +
                "<trans>" +
                "<trn-b2e0035-rq>" +
                "<b2e0035-rq>" +
                "<ibknum>" + Parameter.get(siteid, "bank_boc_ibknum") + "</ibknum>" +//查询账号的联行号
                "<actacn>" + Parameter.get(siteid, "bank_boc_actacn") + "</actacn>" +//查询账户的账号
                "<type>2001</type>" +//查询类型；2001：当日查询；2002：历史查询；2005：T+1查询日夜间批量交易
                "<datescope>" +//日期范围
                "<from>" + getDate_Str() + "</from>" +//开始日期
                "<to>" + getDate_Str() + "</to>" +//截止日期
                "</datescope>" +
                "<amountscope>" +//查询金额范围
                "<from></from>" +//金额下限
                "<to></to>" +//金额上限
                "</amountscope>" +
                "<begnum>" + begnum + "</begnum>" +//本次查询的交易起始位置
                "<recnum>50</recnum>" +//查询记录数，最大50
                "<direction>1</direction>" +//来往账标志
                "</b2e0035-rq>" +
                "</trn-b2e0035-rq>" +
                "</trans>" +
                "</bocb2e>";
        String body = PostXml.postXML(Parameter.get(siteid, "bank_boc_url"), reqdata);
        SAXReader saxreader = new SAXReader();
        List<TradeInfoResponseDetail> list = new ArrayList<TradeInfoResponseDetail>();
        try {
            Document document = saxreader.read(new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
            Element trnb2e0035rs = document.getRootElement().element("trans").element("trn-b2e0035-rs");
            String rspcod = trnb2e0035rs.element("status").elementText("rspcod");//B001成功；B002成功，未完；B003交易数为0
            if (rspcod.equals("B001")) {
                list.addAll(ElementResolve.elementResolve(trnb2e0035rs));
            } else if (rspcod.equals("B002")) {
                list.addAll(ElementResolve.elementResolve(trnb2e0035rs));
                int baginnum = Integer.parseInt(trnb2e0035rs.elementText("totalnum"));
                list.addAll(query(siteid, 1 + baginnum));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}
