select distinct t.systemid, t.systemmoduleid, t.systemmodule, t.systemmodulename, t.sequence
from (
         select distinct t5.systemid, t4.systemmoduleid, t4.systemmodule, t4.systemmodulename, t4.sequence
         from sys_roleappoptionauth t1
                  inner join sys_systemapp_options t2 on t1.optionid = t2.optionid and t2.isused = 1
                  inner join sys_systemapp t3 on t2.systemappid = t3.systemappid and t3.isused = 1 and (t3.showplace = $showplace$ or $showplace$ = '1')
                  inner join sys_systemmodule t4 on t3.systemmoduleid = t4.systemmoduleid and t4.isused = 1
                  inner join sys_systemclient t5 on t4.systemclientid = t5.systemclientid and t5.isused = 1
         where t5.systemclient = $systemclient$
           and exists(select * from sys_userrole where roleid = t1.roleid and userid = $userid$ and siteid = $siteid$)
         union all
         select distinct t3.systemid, t2.systemmoduleid, t2.systemmodule, t2.systemmodulename, t2.sequence
         from sys_systemapp t1
                  inner join sys_systemmodule t2 on t1.systemmoduleid = t2.systemmoduleid and t2.isused = 1
                  inner join sys_systemclient t3 on t2.systemclientid = t3.systemclientid and t3.isused = 1
         where t1.isused = 1
           and t1.isneedauth = 0
           and t3.systemclient = $systemclient$ and  (t1.showplace = $showplace$ or $showplace$ = '1') ) t
order by t.sequence