package restcontroller.sysmanage.develop.sysmsg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnectPool;
import restcontroller.R;

import java.lang.management.*;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.List;

public class sysmsg extends Controller {
    public sysmsg(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统监控", apiversion = R.ID10024601.v1.class)
    public String getMsg() throws YosException {
        JSONObject object = new JSONObject();
        {
            OperatingSystemMXBean system = ManagementFactory.getOperatingSystemMXBean();
            JSONObject systemObject = new JSONObject();
            systemObject.put("Name", system.getName());
            systemObject.put("Version", system.getVersion());
            systemObject.put("Arch", system.getArch());
            try {
                systemObject.put("HostName", InetAddress.getLocalHost().getHostName());
            } catch (Exception e) {
                e.printStackTrace();
            }
            systemObject.put("AvailableProcessors", system.getAvailableProcessors());
            object.put("system", systemObject);
        }
        {
            JSONObject mysqlObject = new JSONObject();
            mysqlObject.put("Version", dbConnect.runSqlQuery("select version() as version ").get(0).getString("version"));
            mysqlObject.put("ConnectPoolsSize", DBConnectPool.POOLS_MAP.get("default").size());

            Rows variableRows = dbConnect.runSqlQuery("show variables where Variable_name in('innodb_buffer_pool_size','innodb_log_file_size','innodb_log_buffer_size','key_buffer_size','tmp_table_size','read_buffer_size','sort_buffer_size','read_rnd_buffer_size')");
            mysqlObject.put("Variables", variableRows);

            JSONArray processArray = new JSONArray();
            Rows processRows = dbConnect.runSqlQuery("SHOW full PROCESSLIST");
            for (Row processRow : processRows) {
                if (processRow.getString("User").equalsIgnoreCase("event_scheduler")) {
                    continue;
                }
                JSONObject ProcessObject = new JSONObject();
                ProcessObject.put("User", processRow.getString("User"));
                ProcessObject.put("Command", processRow.getString("Command"));
                ProcessObject.put("State", processRow.getString("State"));
                ProcessObject.put("Time", processRow.getString("Time"));
                ProcessObject.put("Id", processRow.getString("Id"));
                ProcessObject.put("Info", processRow.getString("Info"));
                ProcessObject.put("db", processRow.getString("db"));
                processArray.add(ProcessObject);
            }
            processArray.sort(new Comparator<Object>() {
                @Override
                public int compare(Object o1, Object o2) {
                    JSONObject object1 = (JSONObject) o1;
                    JSONObject object2 = (JSONObject) o2;
                    String Command_o1 = "";
                    String Command_o2 = "";
                    try {
                        Command_o1 = object1.getString("Command");
                        Command_o2 = object2.getString("Command");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!Command_o1.equals("Sleep") && !Command_o2.equals(Command_o1)) {
                        return -1;
                    } else if (Command_o1.equals(Command_o2)) {
                        return 0;
                    } else {
                        return 1;
                    }
                }
            });

            mysqlObject.put("Processlist", processArray);

            object.put("mysql", mysqlObject);
        }

        {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            JSONObject javaObject = new JSONObject();
            javaObject.put("PID", runtime.getName().split("@")[0]);
            //javaObject.put("SpecName", runtime.getSpecName());
            //javaObject.put("SpecVendor", runtime.getSpecVendor());
            javaObject.put("SpecVersion", runtime.getSpecVersion());
            javaObject.put("StartTime", getDateTime_Str(runtime.getStartTime()));
            //javaObject.put("VmName", runtime.getVmName());
            //javaObject.put("VmVendor", runtime.getVmVendor());
            javaObject.put("VmVersion", runtime.getVmVersion());
            long runtitme = runtime.getUptime();
            String timestr = "";
            long daytimes = 86400000;
            if (runtitme / daytimes > 0) {
                timestr = runtitme / daytimes + "天";
                runtitme = runtitme % daytimes;
            }
            long hourtimes = 3600000;
            if (runtitme / hourtimes > 0) {
                timestr = timestr + runtitme / hourtimes + "小时";
                runtitme = runtitme % hourtimes;
            }
            long mtimes = 60000;
            if (runtitme / mtimes > 0) {
                timestr = timestr + runtitme / mtimes + "分";
                runtitme = runtitme % mtimes;
            }
            long mmtimes = 1000;
            if (runtitme / mmtimes > 0) {
                timestr = timestr + runtitme / mmtimes + "秒";
            }
            javaObject.put("UpTime", timestr);

            //javaObject.put("InputArguments", runtime.getInputArguments());

            JSONObject array = new JSONObject();

            List<GarbageCollectorMXBean> garbages = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean g : garbages) {
                JSONObject object1 = new JSONObject();
                object1.put("count", g.getCollectionCount());
                object1.put("time", g.getCollectionTime());
                array.put(g.getName().replace(" ", ""), object1);
            }
            javaObject.put("GarbageCollector", array);

            JSONObject MemoryUsageObject = new JSONObject();

            MemoryUsageObject.put("NonHeap", JSON.toJSON(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
            MemoryUsageObject.put("Heap", JSON.toJSON(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
            javaObject.put("MemoryUsage", MemoryUsageObject);

            List<MemoryPoolMXBean> memoryPoolMXBeansList = ManagementFactory.getMemoryPoolMXBeans();
            JSONObject memoryPoolMXBeansObject = new JSONObject();
            for (MemoryPoolMXBean m : memoryPoolMXBeansList) {
                String poolname = m.getName().replace(" ", "");
//                if (Arrays.asList(new String[]{"CodeCache", "Metaspace", "CompressedClassSpace"}).contains(poolname)) {
//                    continue;
//                }
                memoryPoolMXBeansObject.put(poolname, JSON.toJSON(m.getUsage()));
            }
            javaObject.put("MemoryPool", memoryPoolMXBeansObject);
            object.put("java", javaObject);
        }
        {
            ThreadMXBean thread = ManagementFactory.getThreadMXBean();
            JSONObject threadObject = new JSONObject();
            threadObject.put("threadCount", thread.getThreadCount());
            threadObject.put("peakThreadCount", thread.getPeakThreadCount());

            long[] deadlockedIds = thread.findDeadlockedThreads();
            if (deadlockedIds != null && deadlockedIds.length > 0) {
                threadObject.put("deadlockedthreads", JSON.toJSON(thread.getThreadInfo(deadlockedIds)));
            } else {
                threadObject.put("deadlockedthreads", new JSONArray());
            }
            object.put("threads", threadObject);
        }
        return getSucReturnObject().setData(object).toString();
    }
}
