package restcontroller.sysmanage.develop.sys_view;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;

import java.util.ArrayList;

public class sys_view extends Controller {
    public sys_view(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "视图列表查询")
    public String queryViewList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select table_name as table_name,view_definition as view_definition from information_schema.VIEWS where table_schema='" + dbConnect.getDBName() + "'");

        RowsMap sys_viewRowsMap = dbConnect.runSqlQuery("select * from sys_view").toRowsMap("view_name");
        JSONArray viewArray = new JSONArray();
        for (Row row : rows) {
            JSONObject viewObject = new JSONObject();
            String view_name = row.getString("table_name");
            viewObject.put("table_name", view_name);
            viewObject.put("sql", row.getString("view_definition"));
            if (sys_viewRowsMap.containsKey(view_name)) {
                Row sys_viewRow = sys_viewRowsMap.get(view_name).get(0);
                viewObject.put("table_comment", sys_viewRow.getString("view_comment"));
                viewObject.put("createdate", sys_viewRow.getDate("createdate"));
                viewObject.put("changedate", sys_viewRow.getDate("changedate"));
                viewObject.put("sys_viewid", sys_viewRow.getLong("sys_viewid"));
            } else {
                viewObject.put("table_comment", view_name);
            }
            viewArray.add(viewObject);
        }
        return getSucReturnObject().setData(viewArray).toString();
    }

    @API(title = "创建视图")
    public String insertView() throws YosException {
        String table_name = content.getString("table_name").toLowerCase();
        if (table_name.equals("")) {
            return getErrReturnObject().setErrMsg("视图名称不可为空").toString();
        }
        if (!table_name.endsWith("_view")) {
            table_name = table_name + "_view";
        }
        String table_comment = content.getString("table_comment");
        String sql = content.getString("sql", true);
        if (!content.getStringValue("datakey").equals("") && content.getStringValue("datakey").equalsIgnoreCase("default")) {
            return getErrReturnObject().setErrMsg("该数据源不可创建视图").toString();
        }

        if (table_comment.equals("")) {
            return getErrReturnObject().setErrMsg("视图描述不可为空").toString();
        }
        if (sql.equals("")) {
            return getErrReturnObject().setErrMsg("SQL语句不可为空").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_object where table_name='" + table_name + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("视图名称不可和表名称重复！").toString();
        }
        try {
            dbConnect.runSqlQuery(sql + " limit 0,1");
        } catch (Exception e) {
            return getErrReturnObject().setErrMsg("SQL语句错误，请检查！").toString();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        Rows sys_viewRows = dbConnect.runSqlQuery("select * from sys_view where view_name='" + table_name + "'");
        if (sys_viewRows.isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_view");
            insertSQL.setValue("view_name", table_name);
            insertSQL.setValue("view_comment", table_comment);
            sqllist.add(insertSQL.getSQL());
        } else {
            UpdateSQL updateSQL = SQLFactory.createUpdateSQL(this, "sys_view");
            updateSQL.setValue("view_comment", table_comment);
            updateSQL.setWhere("view_name", table_name);
            sqllist.add(updateSQL.getSQL());
        }
        Rows rows = dbConnect.runSqlQuery("select * from information_schema.VIEWS where table_schema='" + dbConnect.getDBName() + "' and table_name='" + table_name + "';");
        if (rows.isEmpty()) {
            sqllist.add("CREATE VIEW " + table_name + " AS " + sql);
        } else {
            sqllist.add("ALTER VIEW " + table_name + " AS " + sql);
        }
        dbConnect.runSqlUpdate(sqllist);
        return getSucReturnObject().toString();
    }

    @API(title = "视图删除")
    public String deleteView_Comment() throws YosException {
        String table_name = content.getString("table_name");
        ArrayList<String> list = new ArrayList<>();
        list.add("DROP VIEW " + table_name + ";");
        list.add("delete from sys_view where view_name='" + table_name + "'");
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "视图栏位查询")
    public String queryView_Fields() throws YosException {
        String table_name = content.getString("table_name");
        Rows rows = dbConnect.runSqlQuery("SELECT table_name as table_name,column_name as column_name,data_type as column_type,case when numeric_precision is null then CHARACTER_MAXIMUM_LENGTH else numeric_precision end as numeric_precision,numeric_scale as numeric_scale,column_comment as column_comment FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' AND TABLE_NAME = '" + table_name + "';");
        return getSucReturnObject().setData(rows).toString();
    }
}
