package restcontroller.sysmanage.develop.payorder;

import com.alibaba.fastjson.JSONObject;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.AutoUpdateCertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import common.BaseClass;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

public class WeChatHelper extends BaseClass {

    // 商户证书序列号
    public static String mchSerialNo = "298BBD8036E37F7511C9995F98914A39DF7BCFA9";
    // api密钥
    public static String apiV3Key = "53ff487a092bded91251009a9fe19684";
    public static String privateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCdx7yW3tWoKsNFLjIo8BWlNXy38Iw9KQZQN95qtZHp5vv4S1U1bYmNuMcLJmW2BjqSZkifkhVSMnsmrm0t/pOfATsKDHKZNUBBtONPcmxRZwTRS2MJJgkYQ/Ecx7QQBuedbt3hvNKnNJFL7NOf+6W2mYeA3P2PLcvMf2g1CpaSKNRnumr8P7ld9SpxoT0+5ca3mRLPlJCzG1HcnWQgGRNcuwvp81SRXujodG9cnAUmg7YtjeFwAM5pUzIHQBgSDOJs0xVAYR+yFoNMo1bUn7eGGDfur97kRk4RlzIpHyVfZcAhxdP/EIzBLajhsljnvPIvjz1mYKn5k8U9kDSnSSLRAgMBAAECggEAQrHmx0OkvzRsXLb9Xw61p6Nnd/2H2maYE5q6OxNLfbs1MazudOo7phvAj7cIcZxKcA4qjsFan+dU5XIAFtwxHJqRkVrXqmm3Is9K8w9kODi68ZnTYE+iso4twsOsGsZAa+0sf7qotSNkc9rFTjA6yWg2vkMsL7TlHCmTLDCwm1FbIrWlMoPiIqNA68SlX3pre2B97kQH8BdcH5Q/cWf8ap9A23HU3x6gfzJrU46BwUN43NKuShnRMaMrqgyaTZnt8v0JC/NUl+326K5Ota4KQEik55BYWJZDvXo4w5VK17SezBMZwdykfSO2j9UBOlkzHTQndGAStgHKPc9h3btcAQKBgQDLtBN+q9y8aRzhUX02fQYdna9nFs9r8gA9ytFj4+52amjoBOMF1jw2yXOcaQobFvayisrRr6gaGQPkM4Xfln01TeQtmeB50i22Uu0Nteq2u23OWJjwpQozyYqkTqWi8lhgISCCjVB4+aGbuVB2/JjkPeO+nkjLRabRAknoTTS2QQKBgQDGSXeXmfY3jEo9LUkGiytq6XjrhePi1ohZiwGK15W1DOaSbX1Y0o55xZk4QAoucgKhg3CKGkJdzkAU3UCWxlFZxzNS8kPWhCbMmY8JOCsAH5JiadeKAKscO9CBMfnaIZPmJ7eWwq/8VAGsClNmx9PW4hZZxFrkqZb0xW3e5IPokQKBgATBbXsVlA+p/IyeFGhDPvNODRxBAhKpEaxfocfNOHH3Rf+0rYAjYkB9L3/FTAEZ5iSA7P88NJZ3Ywne0g9IOiAWc29FGmJ9r6eEBBi/2Hzvnz6j/t4PXE+dMulnFKLbOYj0/QdPOUO5wDYce25rsz4Q29JFa7mjJKPYg9UyiDqBAoGAXSCMJouM9DHTfEAUmBos3h2hSRytFxCjIUsEAm2WRl40vHjn8huSBucjOyP4pC+vxKOy62nB2cTQm/v+JdImyv+fv0lBSzLt9hH499+Fcp1hZw9Gx+3gb3Y4SzVpn2U9zU7CDvCJLv1Ve7Ot0AvyFm5BCRALkHGGEJfZLmItAcECgYBYg9be3JK1DNwK+mbIc3C5P52LsrONNeNaNUd4gWwk1OEo2jBF3CPOH4tyxjG099YZstYnCzjCFKaH3y94JKIcr0sU8PMFpcfZX5bankZ4SxezJ3SrFGh6vnxBwBifIWoM+skt7u7a2sdO1lAZ7ixwXVKxw0KTW8i35jneU6ppow==";
    //支付结果通知地址
    public static String notify_url = "https://meida.cnyunl.com/yos/rest/index/wechatpay/returnorderstatenative";
    public static String mch_id = "1489164782";
    public static String mch_key = "53ff487a092bded91251009a9fe19684";
    public static String appid = "wx2040645ab5e3d60d";

    /**
     * 创建订单前先调用此方法
     */
    public static CloseableHttpClient httpClient() {
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey(
                new ByteArrayInputStream(privateKey.getBytes(StandardCharsets.UTF_8)));
        //使用自动更新的签名验证器，不需要传入证书
        PrivateKeySigner privateKeySigner = new PrivateKeySigner(mchSerialNo, merchantPrivateKey);
        WechatPay2Credentials wechatPay2Credentials = new WechatPay2Credentials(mch_id, privateKeySigner);
        AutoUpdateCertificatesVerifier verifier = new AutoUpdateCertificatesVerifier(wechatPay2Credentials, apiV3Key.getBytes(StandardCharsets.UTF_8));
        WechatPay2Validator wechatPay2Validator = new WechatPay2Validator(verifier);
        CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create().withMerchant(mch_id, mchSerialNo, merchantPrivateKey).withValidator(wechatPay2Validator).build();
        return httpClient;
    }

    public static JSONObject refund(String out_refund_no) {
        CloseableHttpClient httpClient = httpClient();
        try {
            HttpGet httpPost = new HttpGet("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds/" + out_refund_no);
            httpPost.setHeader("Accept", "application/json");
            //完成签名并执行请求
            CloseableHttpResponse response = httpClient.execute(httpPost);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    JSONObject returnobject = JSONObject.parseObject(EntityUtils.toString(response.getEntity()));
                    return returnobject;
                } else if (statusCode == 204) {
                    //处理成功，无返回Body
                    //System.out.println("success");
                } else {
                    //System.out.println("failed,resp code = " + statusCode + ",return body = " + EntityUtils.toString(response.getEntity()));
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                response.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
