package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public final class sys_datawarn implements YosObject {
    @Override
    public String table_comment() {
        return "数据预警";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("sys_datawarnid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("datakey", "datakey", "datakey", 100, true, false, false, "", 1));
        arrayList.add(new LongTextCol("sqlstr", "sql语句", "sql语句", true, false, "", 3));
        arrayList.add(new VarcharCol("title", "名称", "名称", 50, true, false, false, "", 3));
        arrayList.add(new VarcharCol("type", "类型", "error，normal", 50, true, false, false, "normal", 3));
        arrayList.add(new VarcharCol("remarks", "说明", "说明", 500, true, false, false, "", 3));
        arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 0, 3));
        arrayList.add(new IntCol("level", "异常等级", "1紧急、2重要、3一般", false, false, false, 3, 3));
        arrayList.add(new SmallIntCol("displayedonhomepage", "是否在首页展示", "是否在首页展示", false, false, false, 1, 3));
        return arrayList;
    }
    @Override
    public void DataInit() throws YosException {

    }
}
