/**
 *
 */
package common.data.db;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.BucketRetentionRules;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import com.influxdb.query.FluxTable;
import common.YosException;
import common.data.Row;
import common.data.Rows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 沈静伟
 *
 * 获取一个数据库连接
 */
public class InfluxDBConnect {
    private static HashMap<String, InfluxDBConnect> cmap = new HashMap<>();

    private InfluxDBClient influxDBClient;
    private String org;
    private String siteid;

    public InfluxDBClient getInfluxDBClient() {
        return influxDBClient;
    }

    public void setInfluxDBClient(InfluxDBClient influxDBClient) {
        this.influxDBClient = influxDBClient;
    }

    public String getOrg() {
        return org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getSiteid() {
        return siteid;
    }

    public void setSiteid(String siteid) {
        this.siteid = siteid;
    }

    private static InfluxDBConnect getConnect(String siteid) throws YosException {
        if (!cmap.containsKey(siteid)) {
            synchronized (InfluxDBConnect.class) {
                Rows rows = new DBConnect().runSqlQuery("select servername,org,orgid,token,url from sys_site t1 inner join sys_influxdb t2 on t1.sys_influxdbid=t2.sys_influxdbid where t1.siteid='" + siteid + "'");
                if (rows.isNotEmpty()) {
                    InfluxDBConnect influxClient = new InfluxDBConnect();
                    influxClient.setInfluxDBClient(InfluxDBClientFactory.create(rows.get(0).getString("url"), rows.get(0).getString("token").toCharArray()));
                    influxClient.setOrg(rows.get(0).getString("org"));
                    influxClient.setSiteid(siteid);
                    cmap.put(siteid, influxClient);
                    try {
                        Bucket bucket = cmap.get(siteid).getInfluxDBClient().getBucketsApi().findBucketByName(siteid);
                        if (bucket == null) {
                            BucketRetentionRules bucketRetentionRules = new BucketRetentionRules();
                            bucketRetentionRules.setEverySeconds(0);
                            cmap.get(siteid).getInfluxDBClient().getBucketsApi().createBucket(siteid, bucketRetentionRules, rows.get(0).getString("orgid"));
                        }
                    } catch (Exception e) {
                    }
                } else {
                    //  throw new YosException("该站点未配置时序数据库服务器！");
                }
            }
        }
        return cmap.getOrDefault(siteid, null);
    }


    public static List<FluxTable> runSqlQuery(String siteid, String query) throws YosException {
        InfluxDBConnect influxDBConnect = getConnect(siteid);
        if (influxDBConnect != null) {
            return influxDBConnect.getInfluxDBClient().getQueryApi().query(query, influxDBConnect.getOrg());
        } else {
            return new ArrayList<>();
        }
    }

    public static void runSqlUpdate(String siteid, long w_productid, long w_deviceid, Row valueRow, HashMap<String, String> column_types, long time) throws YosException {
        InfluxDBConnect influxDBConnect = getConnect(siteid);
        if (influxDBConnect != null) {
            System.out.println("influxdb存储 w_productid:" + w_productid + ";w_deviceid:" + w_deviceid + "value:" + valueRow.toJsonObject() + "time:" + time);
            Map<String, String> tagsToAdd = new HashMap<>();
            tagsToAdd.put("deviceid", String.valueOf(w_deviceid));
            Point point = Point.measurement(String.valueOf(w_productid));
            point.addTags(tagsToAdd);
            for (String key : valueRow.keySet()) {
                switch (column_types.get(key)) {
                    case "double": {
                        point.addField(key, valueRow.getDouble(key));
                        break;
                    }
                    case "int": {
                        point.addField(key, valueRow.getInteger(key));
                        break;
                    }
                    case "long": {
                        point.addField(key, valueRow.getLong(key));
                        break;
                    }
                    case "boolean": {
                        point.addField(key, valueRow.getBoolean(key));
                        break;
                    }
                    default: {
                        point.addField(key, valueRow.getString(key));
                        break;
                    }
                }
            }
            //point.addFields(valueRow);
            point.time(time, WritePrecision.MS);//ms 毫秒秒 us 微妙 ns 纳秒

            WriteApiBlocking writeApi = influxDBConnect.getInfluxDBClient().getWriteApiBlocking();
            writeApi.writePoint(siteid, influxDBConnect.getOrg(), point);
            System.out.println("influxdb存储完成");
        }
    }
}


